/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.jsmcommon.util.datasource;

import com.cognos.jsmcommon.logging.SDSLevel;
import com.cognos.jsmcommon.logging.SDSLogger;
import com.cognos.jsmcommon.util.JSMCommonCategory;
import com.cognos.jsmcommon.util.datasource.ByteArrayDataSource;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.ImageWriter;
import javax.imageio.stream.MemoryCacheImageInputStream;
import javax.imageio.stream.MemoryCacheImageOutputStream;
import org.apache.commons.io.IOUtils;

public final class PngByteArrayDataSource
extends ByteArrayDataSource {
    static final long serialVersionUID = 70009003L;
    private static final String JPEG_MIME = "image/jpeg";

    PngByteArrayDataSource(byte[] content, String contentType) {
        super(null, JPEG_MIME, null);
        byte[] jpegBytes = PngByteArrayDataSource.convertToJpg(content, contentType);
        if (jpegBytes == null) {
            this.setContentType(contentType);
            this.setContent(content);
        } else {
            this.setContent(jpegBytes);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] convertToJpg(byte[] content, String contentType) {
        ByteArrayInputStream bais = new ByteArrayInputStream(content);
        MemoryCacheImageInputStream mcis = new MemoryCacheImageInputStream(bais);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] converted_img = new byte[]{};
        ImageWriter jpegImageWriter = null;
        ImageReader pngImageReader = null;
        try {
            Iterator<Object> it = ImageIO.getImageReadersByMIMEType(contentType);
            pngImageReader = it.next();
            pngImageReader.setInput(mcis);
            BufferedImage input = pngImageReader.read(0);
            pngImageReader.dispose();
            mcis.close();
            bais.close();
            MemoryCacheImageOutputStream output = new MemoryCacheImageOutputStream(baos);
            int transparency = input.getColorModel().getTransparency();
            it = ImageIO.getImageWritersByMIMEType(JPEG_MIME);
            jpegImageWriter = (ImageWriter)it.next();
            if (transparency != 1) {
                int w = input.getWidth();
                int h = input.getHeight();
                BufferedImage whiteBackGround = new BufferedImage(w, h, 1);
                Graphics2D g = whiteBackGround.createGraphics();
                g.setColor(Color.WHITE);
                g.fillRect(0, 0, w, h);
                g.drawRenderedImage(input, null);
                input = whiteBackGround;
                g.dispose();
            }
            jpegImageWriter.setOutput(output);
            jpegImageWriter.write(input);
            output.flush();
            baos.flush();
            output.close();
        }
        catch (Throwable e) {
            SDSLogger.getLogger(JSMCommonCategory.RUNTIME).log(SDSLevel.INFO, e);
        }
        finally {
            try {
                if (jpegImageWriter != null) {
                    jpegImageWriter.dispose();
                }
                if (pngImageReader != null) {
                    pngImageReader.dispose();
                }
                mcis.close();
                bais.close();
            }
            catch (IOException it) {}
        }
        converted_img = baos.toByteArray();
        if (converted_img == null || converted_img.length == 0) {
            SDSLogger.getLogger(JSMCommonCategory.RUNTIME).debug("failed to convert png to jpg");
            converted_img = null;
        }
        return converted_img;
    }

    public static void main(String[] args) {
        try {
            byte[] png_bytes = IOUtils.toByteArray((InputStream)new FileInputStream("E://temp//png_image_2.png"));
            PngByteArrayDataSource pbads = new PngByteArrayDataSource(png_bytes, "image/png");
            FileOutputStream fos = new FileOutputStream("E://temp//jpg_image_4.jpg");
            fos.write(pbads.getBytes());
            fos.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

