/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.jsmcommon.util.datasource;

import com.cognos.jsmcommon.util.datasource.ByteArrayDataSource;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;

public final class ZippedByteArrayDataSource
extends ByteArrayDataSource {
    static final long serialVersionUID = 70009003L;

    ZippedByteArrayDataSource(byte[] content, String name) throws IOException {
        super(content, "application/x-zip-compressed", name);
    }

    @Override
    public String getContentEncoding() {
        return "zip";
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return new ByteArrayInputStream(this.getBytes());
    }

    @Override
    public String getName() {
        String name = super.getName();
        if (name == null || name.endsWith(".zip")) {
            return name;
        }
        name = name + ".zip";
        return name;
    }

    public static void main(String[] args) {
        String[] tests = new String[]{"test.mht", "2mhttest.mht.mht", "test", "test.blah_blah.gif", "ballacks spaced.html", "", null};
        try {
            for (int i = 0; i < tests.length; ++i) {
                System.out.println(tests[i] + " => " + new ZippedByteArrayDataSource(new byte[0], tests[i]).getName());
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

