/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.jsmcommon.util.io;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class LimitedBufferedOutputStream
extends FilterOutputStream {
    protected byte[] buf;
    protected int count;
    private long totalBytes;
    private long byteLimit = 0L;

    public LimitedBufferedOutputStream(OutputStream out) {
        this(out, 8192, 0L);
    }

    public LimitedBufferedOutputStream(OutputStream out, long limit) {
        this(out, 8192, limit);
    }

    public LimitedBufferedOutputStream(OutputStream out, int size, long limit) {
        super(out);
        if (size <= 0) {
            throw new IllegalArgumentException("Buffer size <= 0");
        }
        this.buf = new byte[size];
        this.byteLimit = limit;
    }

    public long getTotalCount() {
        return this.totalBytes;
    }

    private void updateTotalCount(int count) throws IOException {
        this.totalBytes += (long)count;
        if (this.byteLimit > 0L && this.totalBytes > this.byteLimit) {
            throw new IOException();
        }
    }

    private void flushBuffer() throws IOException {
        if (this.count > 0) {
            this.updateTotalCount(this.count);
            this.out.write(this.buf, 0, this.count);
            this.count = 0;
        }
    }

    @Override
    public synchronized void write(int b) throws IOException {
        if (this.count >= this.buf.length) {
            this.flushBuffer();
        }
        this.buf[this.count++] = (byte)b;
    }

    @Override
    public synchronized void write(byte[] b, int off, int len) throws IOException {
        if (len >= this.buf.length) {
            this.flushBuffer();
            this.out.write(b, off, len);
            return;
        }
        if (len > this.buf.length - this.count) {
            this.flushBuffer();
        }
        System.arraycopy(b, off, this.buf, this.count, len);
        this.count += len;
    }

    @Override
    public synchronized void flush() throws IOException {
        this.flushBuffer();
        this.out.flush();
    }
}

