/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.jsmcommon.util.io;

import com.cognos.jsmcommon.util.io.StreamConverterSource;
import java.io.IOException;
import java.io.InputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;

public class StreamConverter
extends InputStream {
    private StreamConverterSource m_streamSource;
    private ConverterThread m_thread;
    private PipedInputStream m_pIs;
    private Throwable m_t = null;

    public StreamConverter(StreamConverterSource streamSource) {
        this.m_streamSource = streamSource;
    }

    private InputStream getStream() {
        if (this.m_pIs == null) {
            this.m_pIs = new PipedInputStream();
            this.m_thread = new ConverterThread(this.m_streamSource, this.m_pIs);
            this.m_thread.start();
        }
        return this.m_pIs;
    }

    public Throwable getError() {
        return this.m_t == null ? (this.m_thread != null ? this.m_thread.getError() : null) : this.m_t;
    }

    @Override
    public int available() throws IOException {
        return this.getStream().available();
    }

    @Override
    public void close() throws IOException {
        this.getStream().close();
    }

    @Override
    public synchronized void mark(int readlimit) {
        this.getStream().mark(readlimit);
    }

    @Override
    public boolean markSupported() {
        return this.getStream().markSupported();
    }

    @Override
    public int read() throws IOException {
        return this.getStream().read();
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        return this.getStream().read(b, off, len);
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.getStream().read(b);
    }

    @Override
    public synchronized void reset() throws IOException {
        this.getStream().reset();
    }

    @Override
    public long skip(long n) throws IOException {
        return this.getStream().skip(n);
    }

    private static class ConverterThread
    extends Thread {
        private PipedInputStream in;
        private StreamConverterSource source;
        private Throwable t;

        public ConverterThread(StreamConverterSource source, PipedInputStream in) {
            this.source = source;
            this.in = in;
        }

        @Override
        public void run() {
            try {
                PipedOutputStream out = new PipedOutputStream(this.in);
                this.source.convert(out);
            }
            catch (Throwable t) {
                this.t = t;
            }
        }

        public Throwable getError() {
            return this.t;
        }
    }
}

