/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.jsmcommon.version;

import com.cognos.jsmcommon.version.BuildComposite;
import com.cognos.jsmcommon.version.IVersionInfo;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLDecoder;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import java.util.StringTokenizer;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;

public abstract class VersionInfo
implements IVersionInfo {
    private final JarFile m_jarFile = this.initialise();
    private static final String BUILD_DATE = "Implementation-Build-Date";

    protected VersionInfo() {
    }

    protected int getBuildComposite(String buildNumber, BuildComposite bc) {
        int composite = 0;
        try {
            StringTokenizer tokenizer = new StringTokenizer(buildNumber, ".");
            String token = "0";
            for (int i = 0; i <= bc.getIndex(); ++i) {
                token = tokenizer.nextToken();
            }
            composite = Integer.parseInt(token);
        }
        catch (NumberFormatException numberFormatException) {
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return composite;
    }

    protected String getBuildDate(String component) {
        Attributes attributes = null;
        if (null != this.m_jarFile) {
            try {
                Manifest manifest = this.m_jarFile.getManifest();
                attributes = manifest.getAttributes(component);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return attributes != null ? attributes.getValue(BUILD_DATE) : "";
    }

    protected String getManifestValue(String component, Attributes.Name name) {
        Attributes attributes = null;
        if (null != this.m_jarFile) {
            try {
                Manifest manifest = this.m_jarFile.getManifest();
                attributes = manifest.getAttributes(component);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return attributes != null ? attributes.getValue(name) : "";
    }

    protected abstract JarFile initialise();

    protected String searchClassLoader(String jarName) {
        String jarPath = null;
        try {
            ClassLoader loader = VersionInfo.class.getClassLoader();
            if (loader instanceof URLClassLoader) {
                URLClassLoader urlLoader = (URLClassLoader)loader;
                URL[] urls = urlLoader.getURLs();
                URL url = null;
                for (int i = 0; i < urls.length; ++i) {
                    url = urls[i];
                    if (url.getPath().indexOf(jarName) <= 0) continue;
                    jarPath = url.getPath();
                    break;
                }
            } else {
                CodeSource cs;
                ProtectionDomain pd = this.getClass().getProtectionDomain();
                if (null != pd && null != (cs = pd.getCodeSource())) {
                    jarPath = cs.getLocation().getPath();
                }
            }
            if (null == jarPath) {
                throw new RuntimeException("Failed to find JAR file path");
            }
            String encoding = System.getProperty("file.encoding", "UTF-8");
            jarPath = URLDecoder.decode(jarPath, encoding);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Unexpected error decoding JAR file path", e);
        }
        return jarPath;
    }
}

