/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.jsmcommon.version.repository;

import com.cognos.jsmcommon.jdbc.JDBCConnection;
import com.cognos.jsmcommon.jdbc.NCConnection;
import com.cognos.jsmcommon.jdbc.props.DatabaseType;
import com.cognos.jsmcommon.jdbc.props.JDBCConnectionProperties;
import com.cognos.jsmcommon.logging.SDSLevel;
import com.cognos.jsmcommon.logging.SDSLogger;
import com.cognos.jsmcommon.property.CRNProperties;
import com.cognos.jsmcommon.property.PropertiesException;
import com.cognos.jsmcommon.util.JSMCommonCategory;
import com.cognos.jsmcommon.version.repository.utils.SQLUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;

public final class DBType {
    private static final String CONFIGURATION_SCHEMAS_DIR = File.separator + ".." + File.separator + "configuration" + File.separator + "schemas" + File.separator;
    private static final String NOTIFICATION_DIR = CONFIGURATION_SCHEMAS_DIR + "delivery";
    private String m_script_root;
    private static String m_injectedScriptRoot;
    private DatabaseType type;
    private String component;
    private int m_index = 0;
    public static Object[][] m_types;

    public DBType(JDBCConnectionProperties props, String script_root) {
        this.selectType(props.getDBType());
        this.m_script_root = script_root;
    }

    public DBType() {
        this((String)null, (String)null);
    }

    public DBType(DatabaseType database) {
        this((String)null, (String)null);
        this.selectType(database);
    }

    public DBType(String component, String scriptDir) {
        this.component = component;
        JDBCConnectionProperties nc_props = null;
        try {
            nc_props = JDBCConnectionProperties.instance(component);
        }
        catch (Exception e) {
            System.err.println(e.toString());
        }
        if (nc_props != null) {
            this.type = nc_props.getDBType();
        }
        this.selectType(this.type);
        if (m_injectedScriptRoot == null) {
            String ncRoot = null;
            try {
                ncRoot = CRNProperties.getInstance().getProperty("pwd");
            }
            catch (PropertiesException propertiesException) {
                // empty catch block
            }
            this.m_script_root = ncRoot + (component != null ? CONFIGURATION_SCHEMAS_DIR + scriptDir : NOTIFICATION_DIR);
        } else {
            this.m_script_root = m_injectedScriptRoot;
        }
    }

    public DatabaseType getType() {
        return this.type;
    }

    private void selectType(DatabaseType type) {
        if (type == null) {
            return;
        }
        this.type = this.checkDB2(type);
        for (int counter = m_types.length - 1; counter >= 0; --counter) {
            if (!m_types[counter][0].equals(this.type)) continue;
            this.m_index = counter;
            break;
        }
    }

    private DatabaseType checkDB2(DatabaseType type) {
        DatabaseType result = type;
        if (DatabaseType.DB2.equals(type)) {
            try {
                if (this.isZOS_DB2()) {
                    result = DatabaseType.DB2_ZOS;
                }
            }
            catch (SQLException ex) {
                ex.printStackTrace();
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isZOS_DB2() throws SQLException {
        boolean isZOS = false;
        DatabaseMetaData metaData = null;
        ResultSet rs = null;
        JDBCConnection conn = NCConnection.instance(this.component).getConnectionFactory().createConnection();
        try {
            String prodVersion;
            metaData = conn.getMetaData();
            String prodName = metaData.getDatabaseProductName();
            if ("DB2".equalsIgnoreCase(prodName)) {
                isZOS = true;
            }
            if ((prodVersion = metaData.getDatabaseProductVersion()) != null && prodVersion.toUpperCase().startsWith("DSN")) {
                isZOS = true;
            }
        }
        finally {
            SQLUtils.closeResources(this.component, rs, null, conn);
        }
        return isZOS;
    }

    public File getXmlFile() throws FileNotFoundException {
        if (this.m_index <= 0) {
            throw new FileNotFoundException(m_types[0].toString());
        }
        String filePath = this.getXmlFilePathString();
        File result = new File(filePath);
        SDSLogger.getLogger(JSMCommonCategory.TRACE).log(SDSLevel.INFO, null, new String[]{"XML File Path : " + filePath});
        if (!result.exists()) {
            throw new FileNotFoundException(filePath.toString());
        }
        if (!result.isFile()) {
            throw new FileNotFoundException(filePath + " is not a file");
        }
        return result;
    }

    public File getFile(String name) throws FileNotFoundException {
        if (this.m_index <= 0) {
            throw new FileNotFoundException(m_types[0].toString());
        }
        String filePath = this.getFilePathString(name);
        File result = new File(filePath);
        if (!result.exists()) {
            throw new FileNotFoundException(filePath);
        }
        if (!result.isFile()) {
            throw new FileNotFoundException(filePath + " is not a file");
        }
        return result;
    }

    public String getXmlFilePathString() {
        StringBuffer filePath = new StringBuffer(this.m_script_root);
        filePath.append(File.separator);
        filePath.append(m_types[this.m_index][1].toString());
        filePath.append(File.separator);
        filePath.append(m_types[this.m_index][3].toString());
        return filePath.toString();
    }

    public String getFilePathString(String name) {
        StringBuffer filePath = new StringBuffer(this.m_script_root);
        filePath.append(File.separator);
        filePath.append(m_types[this.m_index][1].toString());
        filePath.append(File.separator);
        filePath.append(name);
        return filePath.toString();
    }

    public String getFilePathStringLoc(String name) {
        StringBuffer filePath = new StringBuffer(this.m_script_root);
        filePath.append(File.separator);
        filePath.append(m_types[this.m_index][1].toString());
        return filePath.toString();
    }

    public String getStmtSeparator() {
        return m_types[this.m_index][2].toString();
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append("type = ");
        result.append(m_types[this.m_index][0]);
        result.append(";directory = ");
        result.append(m_types[this.m_index][1]);
        result.append(";separator = ");
        result.append(m_types[this.m_index][2]);
        result.append(";XML = ");
        result.append(m_types[this.m_index][3]);
        return result.toString();
    }

    public static void injectScriptRoot(String scriptRoot) {
        m_injectedScriptRoot = scriptRoot;
    }

    public static void main(String[] argv) {
        try {
            DBType dummy = new DBType();
            Object[] fileNames = m_types[dummy.m_index];
            File xmlFile = dummy.getXmlFile();
            if (xmlFile == null || !xmlFile.exists() || !xmlFile.isFile()) {
                System.err.println("invalid DBType object = " + dummy);
            }
            System.out.println(dummy);
        }
        catch (Exception ex) {
            ex.printStackTrace(System.err);
        }
    }

    static {
        m_types = new Object[][]{{DatabaseType.UNDEFINED, "undefined", "undefined", "undefined", "undefined"}, {DatabaseType.MSSQL, "sqlserver", "go", "RdbmsSchemas.xml"}, {DatabaseType.DB2, "db2", ";", "RdbmsSchemas.xml"}, {DatabaseType.ORACLE, "oracle", ";", "RdbmsSchemas.xml"}, {DatabaseType.SYBASE, "sybase", "go", "RdbmsSchemas.xml"}, {DatabaseType.DERBY, "Derby", ";", "RdbmsSchemas.xml"}, {DatabaseType.DB2_ZOS, "zosdb2", ";", "RdbmsSchemas.xml"}, {DatabaseType.INFORMIX, "informix", ";", "RdbmsSchemas.xml"}, {DatabaseType.HSQL, "hsql", ";", "RdbmsSchemas.xml"}};
    }
}

