/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.jsmcommon.version.repository;

import com.cognos.jsmcommon.i18n.I18NCode;
import com.cognos.jsmcommon.jdbc.JDBCConnection;
import com.cognos.jsmcommon.jdbc.props.DatabaseType;
import com.cognos.jsmcommon.jdbc.props.JDBCConnectionProperties;
import com.cognos.jsmcommon.jdbc.util.SqlResourceCloser;
import com.cognos.jsmcommon.logging.SDSLevel;
import com.cognos.jsmcommon.logging.SDSLogger;
import com.cognos.jsmcommon.util.JSMCommonCategory;
import com.cognos.jsmcommon.version.repository.DBType;
import com.cognos.jsmcommon.version.repository.DBVersionDocument;
import com.cognos.jsmcommon.version.repository.InstallType;
import com.cognos.jsmcommon.version.repository.RepositoryErrorCode;
import com.cognos.jsmcommon.version.repository.ScriptMetadata;
import com.cognos.jsmcommon.version.repository.utils.SQLUtils;
import java.io.FileNotFoundException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;

public class DBVersion {
    private int m_installed_version = -1;
    private int m_version_to_install = -1;
    private DBVersionDocument m_version_document;
    private InstallType m_install_type;
    private boolean m_verbose;
    private DBType m_db_type;
    private static final String m_version_select = "SELECT MAX(DB_VERSION_ID) FROM NC_DB_VERSION";

    public DBVersion(DBType db_type, InstallType install_type, boolean verbose) {
        this.m_db_type = db_type;
        this.m_verbose = verbose;
        try {
            this.m_version_document = new DBVersionDocument(db_type.getXmlFile(), verbose);
            this.m_installed_version = this.getInstalledVersion(verbose);
            this.getInstallVersion(install_type == InstallType.AUTOMATIC ? InstallType.CREATE : install_type);
            this.calculateInstallType(install_type);
        }
        catch (FileNotFoundException e) {
            SDSLogger.getLogger(JSMCommonCategory.TRACE).log(SDSLevel.ERROR, I18NCode.MSG_CANNOT_READ_XML_VERSION_FILE, new String[]{db_type.getXmlFilePathString()});
        }
    }

    public ScriptMetadata[] getScriptMetaData() {
        ScriptMetadata[] meta_data = new ScriptMetadata[]{};
        if (this.succeeded()) {
            meta_data = this.m_version_document.getScriptMetadata(this.m_install_type);
            meta_data = this.trimMetaDataToVersion(meta_data);
        }
        return meta_data;
    }

    public boolean succeeded() {
        return this.m_version_document != null && this.m_version_document.succeeded() && this.m_install_type != null;
    }

    public InstallType getInstallType() {
        return this.m_install_type;
    }

    public RepositoryErrorCode validateDatabaseSchema() {
        RepositoryErrorCode iReturn = RepositoryErrorCode.ACCESS_FAILURE;
        if (this.m_installed_version <= 0) {
            String s = "Unable to connect to the NoticeCast Data Store.\r\nIf this is a new install, then all is well so far.\r\nIf this is an upgrade, there are RDBMS connection issues.";
            SDSLogger.getLogger(JSMCommonCategory.AUDIT).log(SDSLevel.INFO, null, new String[]{s});
            iReturn = RepositoryErrorCode.UNKNOWN_DATASTORE_VERSION;
        } else if (this.m_installed_version > this.m_version_to_install) {
            String s = "The current NoticeCast Data Store, version " + this.m_installed_version + ", is not valid for this install." + "\r\nYou are attempting to install an earlier version, version " + this.m_version_to_install + " of the Data Store." + "\r\n ** Please see your DBA or System Administrator. **";
            SDSLogger.getLogger(JSMCommonCategory.TRACE).log(SDSLevel.INFO, null, new String[]{s});
            iReturn = RepositoryErrorCode.INVALID_DATASTORE_VERSION;
        } else if (this.m_installed_version == this.m_version_to_install) {
            String s = "The current NoticeCast Data Store version is valid for this server upgrade.\r\n ** Please DO NOT UPDATE the Data Store. **";
            SDSLogger.getLogger(JSMCommonCategory.AUDIT).log(SDSLevel.INFO, null, new String[]{s});
            iReturn = RepositoryErrorCode.DONT_UPDATE_DATASTORE;
        } else if (this.m_version_to_install <= 0) {
            String s = "Unable to determine NoticeCast Data Store version.cannot continue";
            SDSLogger.getLogger(JSMCommonCategory.AUDIT).log(SDSLevel.INFO, null, new String[]{s});
            iReturn = RepositoryErrorCode.INVALID_DATASTORE_VERSION;
        } else {
            String s = "The current NoticeCast Data Store, version " + this.m_installed_version + ", is no longer valid." + "\r\nThis server upgrade requires Data Store version " + this.m_version_to_install + " to function." + "\r\n** Please update the Data Store to version " + this.m_version_to_install + " now. **";
            SDSLogger.getLogger(JSMCommonCategory.AUDIT).log(SDSLevel.INFO, null, new String[]{s});
            iReturn = RepositoryErrorCode.UPDATE_DATASTORE;
        }
        SDSLogger.getLogger(JSMCommonCategory.TRACE).debug("validateDatabaseSchema: return value: " + iReturn);
        return iReturn;
    }

    private void getInstallVersion(InstallType type) {
        this.m_version_to_install = this.m_version_document != null ? this.m_version_document.getVersion(type) : -1;
    }

    private ScriptMetadata[] trimMetaDataToVersion(ScriptMetadata[] meta_data) {
        if (!InstallType.UPDATE.equals(this.getInstallType())) {
            return meta_data;
        }
        ArrayList<ScriptMetadata> meta_data_list = new ArrayList<ScriptMetadata>();
        meta_data_list.addAll(Arrays.asList(meta_data));
        Iterator iter = meta_data_list.iterator();
        while (iter.hasNext()) {
            ScriptMetadata one_meta_data = (ScriptMetadata)iter.next();
            if (one_meta_data.getVersion() > this.m_installed_version) continue;
            iter.remove();
        }
        ScriptMetadata[] trimmed_meta_data = new ScriptMetadata[meta_data_list.size()];
        meta_data_list.toArray(trimmed_meta_data);
        return trimmed_meta_data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private int getInstalledVersion(boolean verbose) {
        int installed_version;
        ResultSet resultSet;
        Statement myStatement;
        JDBCConnection connection;
        block6: {
            connection = null;
            myStatement = null;
            resultSet = null;
            Object sqlString = null;
            installed_version = 0;
            try {
                connection = SQLUtils.getConnection(null);
                myStatement = connection.createStatement();
                resultSet = myStatement.executeQuery(m_version_select);
                resultSet.next();
                installed_version = resultSet.getInt(1);
                if (installed_version == 8) {
                    this.doWaftyUpgade(connection);
                }
                if (installed_version > 304 && installed_version < 314) {
                    this.doWaftyUpgadeII(connection);
                }
                if (!verbose) break block6;
                SDSLogger.getLogger(JSMCommonCategory.TRACE).debug("Installed Schema Version:" + installed_version);
            }
            catch (SQLException s) {
                SQLUtils.closeResources("SDS", resultSet, myStatement, connection);
                String s2 = "";
                s2 = installed_version > 0 ? "The currently installed NoticeCast Data Store is version " + installed_version + "." : "Unable to query the NoticeCast Data Store. Possible RDBMS connection issues. \r\nThe Data Store may not exist. The query table may be absent, empty or corrupt.";
                SDSLogger.getLogger(JSMCommonCategory.AUDIT).log(SDSLevel.INFO, null, new String[]{s2});
                catch (Throwable throwable) {
                    SQLUtils.closeResources("SDS", resultSet, myStatement, connection);
                    String s3 = "";
                    s3 = installed_version > 0 ? "The currently installed NoticeCast Data Store is version " + installed_version + "." : "Unable to query the NoticeCast Data Store. Possible RDBMS connection issues. \r\nThe Data Store may not exist. The query table may be absent, empty or corrupt.";
                    SDSLogger.getLogger(JSMCommonCategory.AUDIT).log(SDSLevel.INFO, null, new String[]{s3});
                    throw throwable;
                }
            }
        }
        SQLUtils.closeResources("SDS", resultSet, myStatement, connection);
        String s = "";
        s = installed_version > 0 ? "The currently installed NoticeCast Data Store is version " + installed_version + "." : "Unable to query the NoticeCast Data Store. Possible RDBMS connection issues. \r\nThe Data Store may not exist. The query table may be absent, empty or corrupt.";
        SDSLogger.getLogger(JSMCommonCategory.AUDIT).log(SDSLevel.INFO, null, new String[]{s});
        return installed_version;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doWaftyUpgade(Connection conn) {
        Statement stmt = null;
        boolean executed = false;
        try {
            stmt = conn.createStatement();
            executed = stmt.execute("DROP TABLE NC_EVENTSTATUS");
            executed = stmt.execute("DELETE FROM NC_CONFIGURATION WHERE PROPERTY_KEY = 'scheduler.queue.poll.interval.seconds'");
        }
        catch (SQLException sQLException) {
        }
        finally {
            if (stmt != null) {
                SqlResourceCloser.closeResources(null, stmt);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doWaftyUpgadeII(Connection conn) {
        Statement stmt = null;
        try {
            stmt = conn.createStatement();
            String dropsql = null;
            DatabaseType db = JDBCConnectionProperties.instance("SDS").getDBType();
            if (!DatabaseType.MSSQL.equals(db)) {
                return;
            }
            dropsql = "CREATE INDEX X_NC_TASK_QUEUE_SLTR ON NC_TASK_QUEUE (RESTART_ID)";
            SDSLogger.getLogger(JSMCommonCategory.AUDIT).log(SDSLevel.INFO, null, new String[]{"Executing special update sql " + dropsql});
            stmt.execute(dropsql);
            conn.commit();
        }
        catch (SQLException sQLException) {
        }
        finally {
            if (stmt != null) {
                SqlResourceCloser.closeResources(null, stmt);
            }
        }
    }

    private void calculateInstallType(InstallType installType) {
        RepositoryErrorCode code = this.validateDatabaseSchema();
        if (InstallType.AUTOMATIC.equals(installType)) {
            this.calculateAutomaticInstallType(code);
            return;
        }
        if (InstallType.CREATE.equals(installType)) {
            if (code == RepositoryErrorCode.UNKNOWN_DATASTORE_VERSION) {
                this.m_install_type = InstallType.CREATE;
            } else {
                if (code == RepositoryErrorCode.INVALID_DATASTORE_VERSION) {
                    SDSLogger.getLogger(JSMCommonCategory.AUDIT).log(SDSLevel.ERROR, I18NCode.MSG_PROBLEM_CREATING_SCHEMA);
                }
                this.m_install_type = InstallType.NONE;
            }
        } else if (InstallType.UPDATE.equals(installType)) {
            if (code == RepositoryErrorCode.UPDATE_DATASTORE) {
                this.m_install_type = InstallType.UPDATE;
            } else {
                SDSLogger.getLogger(JSMCommonCategory.AUDIT).log(SDSLevel.ERROR, I18NCode.MSG_PROBLEM_UPDATING_SCHEMA);
                this.m_install_type = InstallType.NONE;
            }
        } else {
            this.m_install_type = installType;
        }
    }

    private void calculateAutomaticInstallType(RepositoryErrorCode code) {
        this.m_install_type = code == RepositoryErrorCode.UPDATE_DATASTORE ? InstallType.UPDATE : (code == RepositoryErrorCode.DONT_UPDATE_DATASTORE ? InstallType.NONE : (code == RepositoryErrorCode.UNKNOWN_DATASTORE_VERSION ? InstallType.CREATE : InstallType.NONE));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static int getInstalledSchemaVersion(boolean verbose) {
        int installed_version;
        ResultSet resultSet;
        Statement myStatement;
        JDBCConnection connection;
        block4: {
            connection = null;
            myStatement = null;
            resultSet = null;
            Object sqlString = null;
            installed_version = 0;
            try {
                connection = SQLUtils.getConnection("SDS");
                myStatement = connection.createStatement();
                resultSet = myStatement.executeQuery(m_version_select);
                resultSet.next();
                installed_version = resultSet.getInt(1);
                if (!verbose) break block4;
                SDSLogger.getLogger(JSMCommonCategory.TRACE).debug("Installed Schema Version:" + installed_version);
            }
            catch (SQLException s) {
                SQLUtils.closeResources("SDS", resultSet, myStatement, connection);
                String s2 = "";
                s2 = installed_version > 0 ? "The currently installed NoticeCast Data Store is version " + installed_version + "." : "Unable to query the NoticeCast Data Store. Possible RDBMS connection issues. \r\nThe Data Store may not exist. The query table may be absent, empty or corrupt.";
                SDSLogger.getLogger(JSMCommonCategory.AUDIT).log(SDSLevel.INFO, null, new String[]{s2});
                catch (Throwable throwable) {
                    SQLUtils.closeResources("SDS", resultSet, myStatement, connection);
                    String s3 = "";
                    s3 = installed_version > 0 ? "The currently installed NoticeCast Data Store is version " + installed_version + "." : "Unable to query the NoticeCast Data Store. Possible RDBMS connection issues. \r\nThe Data Store may not exist. The query table may be absent, empty or corrupt.";
                    SDSLogger.getLogger(JSMCommonCategory.AUDIT).log(SDSLevel.INFO, null, new String[]{s3});
                    throw throwable;
                }
            }
        }
        SQLUtils.closeResources("SDS", resultSet, myStatement, connection);
        String s = "";
        s = installed_version > 0 ? "The currently installed NoticeCast Data Store is version " + installed_version + "." : "Unable to query the NoticeCast Data Store. Possible RDBMS connection issues. \r\nThe Data Store may not exist. The query table may be absent, empty or corrupt.";
        SDSLogger.getLogger(JSMCommonCategory.AUDIT).log(SDSLevel.INFO, null, new String[]{s});
        return installed_version;
    }
}

