/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.jsmcommon.version.repository;

import com.cognos.jsmcommon.i18n.I18NCode;
import com.cognos.jsmcommon.logging.SDSLevel;
import com.cognos.jsmcommon.logging.SDSLogger;
import com.cognos.jsmcommon.util.JSMCommonCategory;
import com.cognos.jsmcommon.util.XMLParser;
import com.cognos.jsmcommon.version.repository.InstallType;
import com.cognos.jsmcommon.version.repository.ScriptMetadata;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class DBVersionDocument {
    private static final String VERSION = "version";
    private static final String BUILD = "build";
    private static final String SCRIPT = "script";
    private InstallType[] m_install_types = new InstallType[]{InstallType.CREATE, InstallType.UPDATE, InstallType.DROP};
    private File m_version_file;
    private boolean m_verbose;
    private HashMap m_update_versions;

    public DBVersionDocument(File version_file, boolean verbose) {
        this.m_version_file = version_file;
        this.m_verbose = verbose;
        try {
            this.readVersionDocument();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            // empty catch block
        }
        this.log();
    }

    public boolean succeeded() {
        return this.m_update_versions != null;
    }

    public ScriptMetadata[] getScriptMetadata(InstallType type) {
        ScriptMetadata[] versions = new ScriptMetadata[]{};
        ArrayList list = (ArrayList)this.m_update_versions.get(type);
        if (list != null) {
            versions = new ScriptMetadata[list.size()];
            list.toArray(versions);
        }
        return versions;
    }

    public ScriptMetadata getHighestVersionEntry(InstallType installType) {
        ScriptMetadata version = null;
        ArrayList list = (ArrayList)this.m_update_versions.get(installType);
        if (list != null) {
            for (ScriptMetadata one_version : list) {
                if (version != null && version.getVersion() >= one_version.getVersion()) continue;
                version = one_version;
            }
        }
        return version;
    }

    public int getVersion(InstallType type) {
        int result = -1;
        ScriptMetadata metaData = this.getHighestVersionEntry(type);
        result = metaData == null ? -1 : metaData.getVersion();
        return result;
    }

    private void readVersionDocument() throws ParserConfigurationException {
        try {
            if (this.m_update_versions == null && this.m_version_file.exists() && this.m_version_file.isFile() && this.m_version_file.canRead()) {
                this.m_update_versions = new HashMap();
                FileReader fileReader = new FileReader(this.m_version_file);
                XMLParser xmlParser = new XMLParser(fileReader);
                Document version_document = xmlParser.parse();
                for (int x = 0; x < this.m_install_types.length; ++x) {
                    NodeList docNodeList = version_document.getElementsByTagName(this.m_install_types[x].toString());
                    for (int y = 0; y < docNodeList.getLength(); ++y) {
                        Node node = docNodeList.item(y);
                        this.readEntry(node, this.m_install_types[x]);
                    }
                }
            }
        }
        catch (FileNotFoundException e) {
            SDSLogger.getLogger(JSMCommonCategory.AUDIT).log(SDSLevel.ERROR, I18NCode.MSG_CANNOT_READ_XML_VERSION_FILE, new String[]{"" + e.getMessage()});
            this.m_update_versions = null;
        }
        catch (IOException e) {
            SDSLogger.getLogger(JSMCommonCategory.AUDIT).log(SDSLevel.ERROR, I18NCode.MSG_CANNOT_READ_XML_VERSION_FILE, new String[]{"" + e.getMessage()});
            this.m_update_versions = null;
        }
        catch (SAXException e) {
            SDSLogger.getLogger(JSMCommonCategory.AUDIT).log(SDSLevel.ERROR, I18NCode.MSG_CANNOT_READ_XML_VERSION_FILE, new String[]{"" + e.getMessage()});
            this.m_update_versions = null;
        }
    }

    private void readEntry(Node aNode, InstallType install_type) {
        NamedNodeMap namedNodeAttrs = aNode.getAttributes();
        Node idNode = namedNodeAttrs.getNamedItem(VERSION);
        Node buildNode = namedNodeAttrs.getNamedItem(BUILD);
        Node scriptNode = namedNodeAttrs.getNamedItem(SCRIPT);
        int version = Integer.parseInt(idNode.getNodeValue());
        String buildNo = buildNode.getNodeValue();
        String script = scriptNode.getNodeValue();
        ScriptMetadata update_version = null;
        update_version = new ScriptMetadata(install_type, version, buildNo, script);
        this.addToMap(update_version);
    }

    private void log() {
        if (!this.m_verbose) {
            return;
        }
        for (int x = 0; x < this.m_install_types.length; ++x) {
            ScriptMetadata[] versions = this.getScriptMetadata(this.m_install_types[x]);
            for (int y = 0; y < versions.length; ++y) {
                SDSLogger.getLogger(JSMCommonCategory.TRACE).debug(versions[y].toString());
            }
        }
    }

    private void addToMap(ScriptMetadata version) {
        ArrayList<ScriptMetadata> list = (ArrayList<ScriptMetadata>)this.m_update_versions.get(version.getType());
        if (list == null) {
            list = new ArrayList<ScriptMetadata>();
            this.m_update_versions.put(version.getType(), list);
        }
        list.add(version);
    }
}

