/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.jsmcommon.version.repository;

import java.io.Serializable;

public class RepositoryErrorCode
implements Serializable {
    static final long serialVersionUID = 70009003L;
    private int m_error_code;
    private static final transient int OK_CODE = 0;
    private static final transient int ACCESS_FAILURE_CODE = 1;
    private static final transient int UNKNOWN_DATASTORE_VERSION_CODE = 3;
    private static final transient int DONT_UPDATE_DATASTORE_CODE = 4;
    private static final transient int UPDATE_DATASTORE_CODE = 5;
    private static final transient int INVALID_DATASTORE_VERSION_CODE = 7;
    private static final transient int ACCESS_FAILURE_UNKNOWN_CODE = 8;
    private static final transient int ACCESS_FAILURE_2_CODE = 9;
    private static final transient int ALREADY_ADMINISTERING_CODE = 10;
    public static final transient RepositoryErrorCode OK = new RepositoryErrorCode(0);
    public static final transient RepositoryErrorCode ACCESS_FAILURE = new RepositoryErrorCode(1);
    public static final transient RepositoryErrorCode ALREADY_ADMINISTERING = new RepositoryErrorCode(10);
    public static final transient RepositoryErrorCode ACCESS_FAILURE_2 = new RepositoryErrorCode(9);
    public static final transient RepositoryErrorCode ACCESS_FAILURE_UNKNOWN = new RepositoryErrorCode(8);
    public static final transient RepositoryErrorCode INVALID_DATASTORE_VERSION = new RepositoryErrorCode(7);
    public static final transient RepositoryErrorCode UNKNOWN_DATASTORE_VERSION = new RepositoryErrorCode(3);
    public static final transient RepositoryErrorCode DONT_UPDATE_DATASTORE = new RepositoryErrorCode(4);
    public static final transient RepositoryErrorCode UPDATE_DATASTORE = new RepositoryErrorCode(5);

    private RepositoryErrorCode(int code) {
        this.m_error_code = code;
    }

    public int getErrorCode() {
        return this.m_error_code;
    }

    public boolean equals(Object obj) {
        boolean equal = false;
        if (obj instanceof RepositoryErrorCode) {
            RepositoryErrorCode rhs = (RepositoryErrorCode)obj;
            if (this.m_error_code == rhs.m_error_code) {
                equal = true;
            }
        }
        return equal;
    }

    public String getErrorCodeAsString() {
        String errorName = "NO_ERROR";
        switch (this.m_error_code) {
            case 1: {
                errorName = "ACCESS_FAILURE";
                break;
            }
            case 3: {
                errorName = "UNKNOWN_DATASTORE_VERSION";
                break;
            }
            case 4: {
                errorName = "DONT_UPDATE_DATASTORE";
                break;
            }
            case 5: {
                errorName = "UPDATE_DATASTORE";
                break;
            }
            case 7: {
                errorName = "INVALID_DATASTORE_VERSION";
                break;
            }
            case 8: {
                errorName = "ACCESS_FAILURE_UNKNOWN";
                break;
            }
            case 9: {
                errorName = "ACCESS_FAILURE_2";
                break;
            }
            case 10: {
                errorName = "ALREADY_ADMINISTERING";
            }
        }
        return errorName;
    }
}

