/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.jsmcommon.version.repository;

import com.cognos.jsmcommon.version.repository.InstallType;
import com.cognos.jsmcommon.version.repository.RepositoryErrorCode;
import com.cognos.jsmcommon.version.repository.RoboRepository;

public class RoboDirectorFactory {
    public static RoboDirector getDirector(InstallType instal_type) {
        RoboDirector director = InstallType.AUTOMATIC.equals(instal_type) ? new BasicDirector(instal_type) : (InstallType.CREATE.equals(instal_type) ? new BasicDirector(instal_type) : (InstallType.UPDATE.equals(instal_type) ? new BasicDirector(instal_type) : (InstallType.VERSION.equals(instal_type) ? new Version() : (InstallType.DROP.equals(instal_type) ? new BasicDirector(instal_type) : (InstallType.DROP_CREATE.equals(instal_type) ? new Drop_create() : new Unknown())))));
        return director;
    }

    public static abstract class RoboDirector {
        protected InstallType m_install_type;

        private RoboDirector() {
        }

        private RoboDirector(InstallType installType) {
            this.m_install_type = installType;
        }

        public abstract RepositoryErrorCode execute(RoboRepository var1);
    }

    private static class Unknown
    extends RoboDirector {
        private Unknown() {
        }

        @Override
        public RepositoryErrorCode execute(RoboRepository robo) {
            return RepositoryErrorCode.ACCESS_FAILURE_UNKNOWN;
        }
    }

    private static class Drop_create
    extends RoboDirector {
        private Drop_create() {
        }

        @Override
        public RepositoryErrorCode execute(RoboRepository robo) {
            RepositoryErrorCode return_code = RepositoryErrorCode.ACCESS_FAILURE;
            robo.initialise(InstallType.DROP);
            robo.retrieveInstallScripts();
            return_code = robo.execute();
            if (return_code != RepositoryErrorCode.ACCESS_FAILURE) {
                robo.initialise(InstallType.CREATE);
                robo.retrieveInstallScripts();
                return_code = robo.execute();
            }
            return return_code;
        }
    }

    private static class BasicDirector
    extends RoboDirector {
        public BasicDirector(InstallType type) {
            super(type);
        }

        @Override
        public RepositoryErrorCode execute(RoboRepository robo) {
            robo.initialise(this.m_install_type);
            robo.retrieveInstallScripts();
            return robo.execute();
        }
    }

    private static class Version
    extends RoboDirector {
        private Version() {
        }

        @Override
        public RepositoryErrorCode execute(RoboRepository robo) {
            RepositoryErrorCode return_code = RepositoryErrorCode.ACCESS_FAILURE;
            robo.initialise(InstallType.VERSION);
            robo.retrieveInstallScripts();
            return_code = robo.validateDatabaseSchema();
            return return_code;
        }
    }
}

