/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.jsmcommon.version.repository;

import com.cognos.jsmcommon.version.repository.DBType;
import com.cognos.jsmcommon.version.repository.DBVersion;
import com.cognos.jsmcommon.version.repository.InstallType;
import com.cognos.jsmcommon.version.repository.RepositoryErrorCode;
import com.cognos.jsmcommon.version.repository.SQLStatementExecutor;
import com.cognos.jsmcommon.version.repository.ScriptValidator;

public final class RoboRepository
implements Cloneable {
    private static final boolean mVerbose = true;
    private DBType mDbType = new DBType();
    private DBVersion mVersioner;
    private ScriptValidator mScriptValidator;

    public RoboRepository() {
        this(null);
    }

    public RoboRepository(String component) {
    }

    public void initialise(InstallType installType) {
        this.mVersioner = new DBVersion(this.mDbType, installType, true);
    }

    public RepositoryErrorCode validateDatabaseSchema() {
        return this.mVersioner.validateDatabaseSchema();
    }

    public void retrieveInstallScripts() {
        if (this.mVersioner == null || !this.mVersioner.succeeded()) {
            return;
        }
        this.mScriptValidator = new ScriptValidator(this.mDbType, true, this.mVersioner.getScriptMetaData());
    }

    public RepositoryErrorCode execute() {
        if (this.mScriptValidator == null || !this.mScriptValidator.succeeded()) {
            return RepositoryErrorCode.ACCESS_FAILURE;
        }
        SQLStatementExecutor executor = new SQLStatementExecutor(this.mScriptValidator.getSQLStringList());
        RepositoryErrorCode response = RepositoryErrorCode.ACCESS_FAILURE;
        if (executor.execute(this.mVersioner.getInstallType())) {
            if (this.mVersioner.getInstallType() != InstallType.NONE) {
                this.mVersioner = new DBVersion(this.mDbType, InstallType.CREATE, true);
            }
            return this.mVersioner.validateDatabaseSchema();
        }
        return response;
    }
}

