/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.jsmcommon.version.repository;

import com.cognos.jsmcommon.i18n.I18NCode;
import com.cognos.jsmcommon.jdbc.JDBCConnection;
import com.cognos.jsmcommon.jdbc.NCConnection;
import com.cognos.jsmcommon.jdbc.props.DatabaseType;
import com.cognos.jsmcommon.jdbc.props.JDBCConnectionProperties;
import com.cognos.jsmcommon.logging.SDSLevel;
import com.cognos.jsmcommon.logging.SDSLogger;
import com.cognos.jsmcommon.util.Debug;
import com.cognos.jsmcommon.util.JSMCommonCategory;
import com.cognos.jsmcommon.version.repository.InstallType;
import com.cognos.jsmcommon.version.repository.utils.SQLUtils;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;

public class SQLStatementExecutor {
    private static final int BACKUP_CREATE_100 = 100;
    private static final int BACKUP_INSERTS_110 = 110;
    private static final int FOREIGNKEY_DROP_120 = 120;
    private static final int VIEW_DROP_130 = 130;
    private static final int TABLE_DROP_140 = 140;
    private static final int TABLE_RECREATE_200 = 200;
    private static final int INDICIES_CREATE_201 = 201;
    private static final int PK_ADD_202 = 202;
    private static final int ALTER_TABLES_203 = 203;
    private static final int VIEWS_CREATE_210 = 210;
    private static final int DATA_INSERT_220 = 220;
    private static final int RESTORE_INSERT_230 = 230;
    private static final int FK_ADD_240 = 240;
    private static final int BACKUP_DROP_250 = 250;
    private List m_script_list;
    public static boolean m_sys_out;
    private String component;

    public SQLStatementExecutor(List script_list) {
        this.m_script_list = script_list;
    }

    public SQLStatementExecutor(List script_list, boolean sys_out, String component) {
        this.m_script_list = script_list;
        m_sys_out = sys_out ? sys_out : m_sys_out;
        this.component = component;
    }

    public int getScriptCount() {
        return this.m_script_list != null ? this.m_script_list.size() : -1;
    }

    public boolean execute(InstallType installType) {
        boolean success = false;
        if (InstallType.CREATE.equals(installType)) {
            success = this.executeCreate(installType);
        } else if (InstallType.UPDATE.equals(installType) || InstallType.DROP.equals(installType)) {
            success = this.executeUpdate(installType);
        } else if (InstallType.NONE.equals(installType)) {
            success = true;
        }
        return success;
    }

    public boolean executeUpdate(InstallType installType) {
        boolean success = false;
        if (this.getScriptCount() == 1) {
            success = this.exeUpdateSql(installType);
        } else if (this.getScriptCount() > 1) {
            success = this.exeMultiUpdateSql(installType);
        }
        this.log(success);
        return success;
    }

    public boolean executeCreate(InstallType installType) {
        boolean success = false;
        success = this.exeCreateSql(installType);
        this.log(success);
        return success;
    }

    private void log(boolean success) {
        if (!success) {
            SDSLogger.getLogger(JSMCommonCategory.AUDIT).log(SDSLevel.ERROR, I18NCode.MSG_REPOSITORY_UPDATE_FAILED);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean exeMultiUpdateSql(InstallType installType) {
        boolean returnBool = true;
        boolean executedUpdate = false;
        JDBCConnection connection = null;
        Statement myStatement = null;
        Iterator scriptIterator = null;
        Iterator sqlIterator = null;
        String sqlString222 = null;
        Object sFunctionId = null;
        int iFunctionId = -1;
        List sqlList222 = null;
        try {
            connection = this.getTransactionConnection();
            myStatement = connection.createStatement();
            SDSLogger.getLogger(JSMCommonCategory.AUDIT).log(SDSLevel.INFO, null, new String[]{"Executing the following SQL statements: "});
            if (m_sys_out) {
                System.out.println("\nExecuting the following SQL statements: \n");
            }
            scriptIterator = this.m_script_list.iterator();
            while (true) {
                if (scriptIterator.hasNext()) {
                    sqlList222 = (List)scriptIterator.next();
                    sqlIterator = sqlList222.iterator();
                } else {
                    connection.commit();
                    try {
                        connection.rollback();
                        this.m_script_list.clear();
                        if (sqlList222 != null) {
                            sqlList222.clear();
                        }
                        SQLUtils.closeResources(this.component, null, myStatement, connection);
                        return returnBool;
                    }
                    catch (SQLException sqle) {
                        sqle.printStackTrace();
                        SDSLogger.getLogger(JSMCommonCategory.AUDIT).log(SDSLevel.ERROR, I18NCode.MSG_REPOSITORY_UPDATE_GENERAL_FAIL, new String[]{sqle.getMessage() + ""});
                        throw new IllegalStateException(sqle.toString());
                    }
                }
                while (sqlIterator.hasNext()) {
                    sqlString222 = (String)sqlIterator.next();
                    if (sqlString222.startsWith("--$")) {
                        if (executedUpdate) {
                            connection.commit();
                            executedUpdate = false;
                        }
                        iFunctionId = Integer.parseInt(sqlString222.substring(3, 6));
                        continue;
                    }
                    SDSLogger.getLogger(JSMCommonCategory.AUDIT).log(SDSLevel.INFO, null, new String[]{sqlString222});
                    if (m_sys_out) {
                        System.out.println(sqlString222);
                    }
                    try {
                        myStatement.executeUpdate(sqlString222);
                        executedUpdate = true;
                    }
                    catch (SQLException e) {
                        if (iFunctionId == 140 || installType == InstallType.DROP) {
                            SDSLogger.getLogger(JSMCommonCategory.AUDIT).debug("skipping failed drop " + sqlString222);
                            continue;
                        }
                        DatabaseType type = JDBCConnectionProperties.instance(this.component).getDBType();
                        if (!DatabaseType.SYBASE.equals(type)) throw e;
                        if (e.getErrorCode() != 4963) throw e;
                    }
                }
                sqlList222.clear();
            }
        }
        catch (SQLException e) {
            try {
                returnBool = false;
                if (m_sys_out) {
                    e.printStackTrace();
                }
                SDSLogger.getLogger(JSMCommonCategory.AUDIT).log(SDSLevel.ERROR, I18NCode.MSG_FAILED_SQL, new String[]{sqlString222, e.getMessage() + ""});
            }
            catch (Throwable throwable) {
                try {
                    connection.rollback();
                    this.m_script_list.clear();
                    if (sqlList222 != null) {
                        sqlList222.clear();
                    }
                    SQLUtils.closeResources(this.component, null, myStatement, connection);
                    throw throwable;
                }
                catch (SQLException sqle) {
                    sqle.printStackTrace();
                    SDSLogger.getLogger(JSMCommonCategory.AUDIT).log(SDSLevel.ERROR, I18NCode.MSG_REPOSITORY_UPDATE_GENERAL_FAIL, new String[]{sqle.getMessage() + ""});
                    throw new IllegalStateException(sqle.toString());
                }
            }
            try {
                connection.rollback();
                this.m_script_list.clear();
                if (sqlList222 != null) {
                    sqlList222.clear();
                }
                SQLUtils.closeResources(this.component, null, myStatement, connection);
                return returnBool;
            }
            catch (SQLException sqle) {
                sqle.printStackTrace();
                SDSLogger.getLogger(JSMCommonCategory.AUDIT).log(SDSLevel.ERROR, I18NCode.MSG_REPOSITORY_UPDATE_GENERAL_FAIL, new String[]{sqle.getMessage() + ""});
                throw new IllegalStateException(sqle.toString());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean exeUpdateSql(InstallType installType) {
        boolean returnBool = true;
        boolean executedUpdate = false;
        JDBCConnection connection = null;
        Statement myStatement = null;
        Iterator scriptIterator = null;
        Iterator sqlIterator = null;
        String sqlString2 = null;
        Object sFunctionId = null;
        int iFunctionId = -1;
        List sqlList2 = null;
        ArrayList<String> rollbackBackupsArrayList = new ArrayList<String>();
        ArrayList<String> rollbackTablesArrayList = new ArrayList<String>();
        ArrayList<String> rollbackConsArrayList = new ArrayList<String>();
        ArrayList<String> rollbackViewsArrayList = new ArrayList<String>();
        try {
            connection = this.getTransactionConnection();
            myStatement = connection.createStatement();
            SDSLogger.getLogger(JSMCommonCategory.AUDIT).log(SDSLevel.INFO, null, new String[]{"\nExecuting the following SQL statements: \n"});
            if (m_sys_out) {
                System.out.println("\nExecuting the following SQL statements: \n");
            }
            for (List sqlList2 : this.m_script_list) {
                for (String sqlString2 : sqlList2) {
                    if (sqlString2.startsWith("--$")) {
                        if (executedUpdate) {
                            connection.commit();
                            executedUpdate = false;
                        }
                        iFunctionId = Integer.parseInt(sqlString2.substring(3, 6));
                        continue;
                    }
                    SDSLogger.getLogger(JSMCommonCategory.AUDIT).log(SDSLevel.INFO, null, new String[]{sqlString2});
                    if (m_sys_out) {
                        System.out.println(sqlString2);
                    }
                    try {
                        myStatement.executeUpdate(sqlString2);
                        executedUpdate = true;
                        switch (iFunctionId) {
                            case 100: {
                                rollbackBackupsArrayList.add(this.createRollbackDrops(new String(sqlString2)));
                                break;
                            }
                            case 200: {
                                rollbackTablesArrayList.add(this.createRollbackDrops(new String(sqlString2)));
                                break;
                            }
                            case 210: {
                                rollbackViewsArrayList.add(this.createRollbackDrops(new String(sqlString2)));
                                break;
                            }
                            case 240: {
                                rollbackConsArrayList.add(this.createRollbackAlters(new String(sqlString2)));
                            }
                        }
                    }
                    catch (SQLException e) {
                        if (iFunctionId == 140 || installType == InstallType.DROP) {
                            SDSLogger.getLogger(JSMCommonCategory.AUDIT).debug("skipping failed drop " + sqlString2);
                            continue;
                        }
                        DatabaseType type = JDBCConnectionProperties.instance(this.component).getDBType();
                        if (DatabaseType.SYBASE.equals(type) && e.getErrorCode() == 4963) continue;
                        throw e;
                    }
                }
                sqlList2.clear();
            }
            connection.commit();
        }
        catch (SQLException e) {
            returnBool = false;
            if (m_sys_out) {
                e.printStackTrace();
            }
            SDSLogger.getLogger(JSMCommonCategory.AUDIT).log(SDSLevel.ERROR, I18NCode.MSG_FAILED_SQL, new String[]{sqlString2, e.getMessage() + ""});
            try {
                connection.commit();
                switch (iFunctionId) {
                    case 100: 
                    case 110: {
                        SDSLogger.getLogger(JSMCommonCategory.AUDIT).log(SDSLevel.ERROR, I18NCode.MSG_REPOSITORY_BACKUP_FAIL, new String[]{String.valueOf(iFunctionId)});
                        this.exeRollbackSql(myStatement, rollbackBackupsArrayList);
                        connection.commit();
                        break;
                    }
                    case 120: 
                    case 130: 
                    case 140: {
                        SDSLogger.getLogger(JSMCommonCategory.AUDIT).log(SDSLevel.ERROR, I18NCode.MSG_REPOSITORY_DROP_FAIL, new String[]{String.valueOf(iFunctionId), this.getClass().toString()});
                        break;
                    }
                    case 200: 
                    case 201: 
                    case 202: {
                        SDSLogger.getLogger(JSMCommonCategory.AUDIT).log(SDSLevel.ERROR, I18NCode.MSG_REPOSITORY_CREATE_FAIL, new String[]{String.valueOf(iFunctionId)});
                        this.exeRollbackSql(myStatement, rollbackTablesArrayList);
                        connection.commit();
                        break;
                    }
                    case 203: {
                        SDSLogger.getLogger(JSMCommonCategory.AUDIT).log(SDSLevel.ERROR, I18NCode.MSG_REPOSITORY_MISC_FAIL, new String[]{String.valueOf(iFunctionId)});
                        break;
                    }
                    case 210: 
                    case 220: 
                    case 230: {
                        SDSLogger.getLogger(JSMCommonCategory.AUDIT).log(SDSLevel.ERROR, I18NCode.MSG_REPOSITORY_CREATE_FAIL, new String[]{String.valueOf(iFunctionId)});
                        this.exeRollbackSql(myStatement, rollbackViewsArrayList);
                        this.exeRollbackSql(myStatement, rollbackTablesArrayList);
                        connection.commit();
                        break;
                    }
                    case 240: {
                        SDSLogger.getLogger(JSMCommonCategory.AUDIT).log(SDSLevel.ERROR, I18NCode.MSG_REPOSITORY_CREATE_FAIL, new String[]{String.valueOf(iFunctionId)});
                        this.exeRollbackSql(myStatement, rollbackConsArrayList);
                        this.exeRollbackSql(myStatement, rollbackViewsArrayList);
                        this.exeRollbackSql(myStatement, rollbackTablesArrayList);
                        connection.commit();
                        break;
                    }
                    case 250: {
                        SDSLogger.getLogger(JSMCommonCategory.AUDIT).log(SDSLevel.ERROR, I18NCode.MSG_REPOSITORY_BACKUP_DROP_FAIL, new String[]{String.valueOf(iFunctionId)});
                    }
                }
            }
            catch (SQLException ee) {
                SDSLogger.getLogger(JSMCommonCategory.AUDIT).log(SDSLevel.ERROR, I18NCode.MSG_REPOSITORY_CORRUPTION_MINIMISATION_FAIL, new String[]{ee.getMessage() + ""});
                ee.printStackTrace();
                throw new IllegalStateException(ee.toString());
            }
        }
        finally {
            this.m_script_list.clear();
            rollbackBackupsArrayList.clear();
            rollbackTablesArrayList.clear();
            rollbackConsArrayList.clear();
            rollbackViewsArrayList.clear();
            if (sqlList2 != null) {
                sqlList2.clear();
            }
            SQLUtils.closeResources(this.component, null, myStatement, connection);
        }
        return returnBool;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean exeCreateSql(InstallType installType) {
        boolean returnBool = true;
        boolean executedUpdate = false;
        JDBCConnection connection = null;
        Statement myStatement = null;
        Iterator sqlIterator = null;
        Iterator scriptIterator = null;
        String sqlString2 = null;
        Object sFunctionId = null;
        int iFunctionId = -1;
        List sqlList2 = null;
        ArrayList<String> rollbackTablesArrayList = new ArrayList<String>();
        ArrayList<String> rollbackConsArrayList = new ArrayList<String>();
        ArrayList<String> rollbackViewsArrayList = new ArrayList<String>();
        try {
            connection = this.getTransactionConnection();
            myStatement = connection.createStatement();
            SDSLogger.getLogger(JSMCommonCategory.AUDIT).log(SDSLevel.INFO, null, new String[]{"\nExecuting the following SQL statements: \n"});
            if (m_sys_out) {
                System.out.println("\nExecuting the following SQL statements: \n");
            }
            for (List sqlList2 : this.m_script_list) {
                for (String sqlString2 : sqlList2) {
                    if (sqlString2.startsWith("--$")) {
                        if (executedUpdate) {
                            connection.commit();
                            executedUpdate = false;
                        }
                        iFunctionId = Integer.parseInt(sqlString2.substring(3, 6));
                        continue;
                    }
                    SDSLogger.getLogger(JSMCommonCategory.AUDIT).log(SDSLevel.INFO, null, new String[]{sqlString2});
                    if (m_sys_out) {
                        System.out.println(sqlString2);
                    }
                    myStatement.executeUpdate(sqlString2);
                    executedUpdate = true;
                    switch (iFunctionId) {
                        case 200: {
                            rollbackTablesArrayList.add(this.createRollbackDrops(new String(sqlString2)));
                            break;
                        }
                        case 210: {
                            rollbackViewsArrayList.add(this.createRollbackDrops(new String(sqlString2)));
                            break;
                        }
                        case 240: {
                            rollbackConsArrayList.add(this.createRollbackAlters(new String(sqlString2)));
                        }
                    }
                }
                sqlList2.clear();
            }
            connection.commit();
        }
        catch (SQLException e) {
            returnBool = false;
            if (Debug.debug || m_sys_out) {
                e.printStackTrace();
            }
            SDSLogger.getLogger(JSMCommonCategory.AUDIT).log(SDSLevel.ERROR, I18NCode.MSG_FAILED_SQL, new String[]{sqlString2, e.getMessage() + ""});
            try {
                connection.commit();
                switch (iFunctionId) {
                    case 210: {
                        this.exeRollbackSql(myStatement, rollbackViewsArrayList);
                        connection.commit();
                    }
                    case 240: {
                        this.exeRollbackSql(myStatement, rollbackConsArrayList);
                        connection.commit();
                    }
                    case 200: 
                    case 201: 
                    case 202: {
                        SDSLogger.getLogger(JSMCommonCategory.AUDIT).log(SDSLevel.ERROR, I18NCode.MSG_REPOSITORY_CREATE_FAIL, new String[]{String.valueOf(iFunctionId)});
                        this.exeRollbackSql(myStatement, rollbackTablesArrayList);
                        connection.commit();
                        break;
                    }
                    case 220: {
                        SDSLogger.getLogger(JSMCommonCategory.AUDIT).log(SDSLevel.ERROR, I18NCode.MSG_REPOSITORY_CREATE_FAIL, new String[]{String.valueOf(iFunctionId)});
                        this.exeRollbackSql(myStatement, rollbackViewsArrayList);
                        this.exeRollbackSql(myStatement, rollbackConsArrayList);
                        this.exeRollbackSql(myStatement, rollbackTablesArrayList);
                        connection.commit();
                    }
                }
            }
            catch (Exception ee) {
                SDSLogger.getLogger(JSMCommonCategory.AUDIT).log(SDSLevel.ERROR, I18NCode.MSG_REPOSITORY_CORRUPTION_MINIMISATION_FAIL, new String[]{ee.getMessage() + ""});
                if (Debug.debug) {
                    ee.printStackTrace();
                }
                throw new IllegalStateException(ee.toString());
            }
        }
        finally {
            if (this.m_script_list != null) {
                this.m_script_list.clear();
            }
            rollbackTablesArrayList.clear();
            rollbackConsArrayList.clear();
            rollbackViewsArrayList.clear();
            SQLUtils.closeResources(this.component, null, myStatement, connection);
            if (sqlList2 != null) {
                sqlList2.clear();
            }
        }
        return returnBool;
    }

    private String createRollbackAlters(String sSql) {
        StringBuffer sbDrop = new StringBuffer("");
        String sAuto = null;
        StringTokenizer st = new StringTokenizer(sSql);
        while (st.hasMoreTokens()) {
            int i;
            sAuto = st.nextToken();
            if (!sAuto.equalsIgnoreCase("ALTER")) continue;
            sbDrop.append(sAuto).append(" ").append(st.nextToken()).append(" ").append(st.nextToken()).append(" ").append("DROP ");
            sAuto = st.nextToken();
            sAuto = st.nextToken();
            if (sAuto.equals("(")) {
                sAuto = st.nextToken();
            }
            if ((i = sAuto.indexOf("(")) != -1) {
                sAuto = sAuto.substring(i + 1, sAuto.length());
            }
            sbDrop.append(sAuto).append(" ").append(st.nextToken());
            break;
        }
        return sbDrop.toString();
    }

    private String createRollbackDrops(String sSql) {
        StringBuffer sbDrop = new StringBuffer("");
        String sAuto = null;
        StringTokenizer st = new StringTokenizer(sSql);
        while (st.hasMoreTokens()) {
            sAuto = st.nextToken();
            if (!sAuto.equalsIgnoreCase("CREATE")) continue;
            sbDrop.append("DROP ").append(st.nextToken()).append(" ");
            sAuto = st.nextToken();
            int i = sAuto.lastIndexOf("(");
            if (i != -1) {
                sAuto = sAuto.substring(0, i);
            }
            sbDrop.append(sAuto);
            break;
        }
        return sbDrop.toString();
    }

    private void exeRollbackSql(Statement myStatement, ArrayList arrayList) {
        String sql = null;
        try {
            SDSLogger.getLogger(JSMCommonCategory.AUDIT).log(SDSLevel.INFO, null, new String[]{"The following SQL executing to minimise Data Store corruption:"});
            for (int i = 0; i < arrayList.size(); ++i) {
                sql = (String)arrayList.get(i);
                try {
                    myStatement.executeUpdate(sql);
                    SDSLogger.getLogger(JSMCommonCategory.AUDIT).log(SDSLevel.INFO, null, new String[]{sql});
                    continue;
                }
                catch (SQLException sqle) {
                    SDSLogger.getLogger(JSMCommonCategory.AUDIT).log(SDSLevel.INFO, null, new String[]{sql + ": " + sqle.toString()});
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private JDBCConnection getTransactionConnection() throws SQLException {
        JDBCConnection con = NCConnection.instance(this.component).getConnectionFactory().createConnection();
        con.setAutoCommit(false);
        return con;
    }

    protected void finalize() {
        this.m_script_list.clear();
        this.m_script_list = null;
    }
}

