/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.jsmcommon.version.repository;

import com.cognos.jsmcommon.i18n.I18NCode;
import com.cognos.jsmcommon.i18n.I18NUtil;
import com.cognos.jsmcommon.logging.SDSLevel;
import com.cognos.jsmcommon.logging.SDSLogger;
import com.cognos.jsmcommon.util.JSMCommonCategory;
import com.cognos.jsmcommon.version.repository.DBType;
import com.cognos.jsmcommon.version.repository.ScriptMetadata;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.util.ArrayList;
import java.util.List;

public class ScriptValidator {
    private ArrayList m_script_list;
    private ScriptMetadata[] m_script_metadata;
    private DBType m_db_type;
    private boolean m_verbose;

    public ScriptValidator(DBType db_type, boolean verbose, ScriptMetadata[] metadata) {
        this.m_script_metadata = metadata;
        this.m_db_type = db_type;
        this.m_verbose = verbose;
        this.validateSqlScripts();
        this.log();
    }

    public List getSQLStringList() {
        return this.m_script_list;
    }

    public boolean succeeded() {
        return this.m_script_list != null;
    }

    private void log() {
        if (!this.succeeded()) {
            SDSLogger.getLogger(JSMCommonCategory.AUDIT).log(SDSLevel.ERROR, I18NCode.MSG_CANNOT_READ_SCRIPTS);
        } else {
            for (int x = 0; x < this.m_script_metadata.length; ++x) {
                SDSLogger.getLogger(JSMCommonCategory.AUDIT).log(SDSLevel.INFO, null, new String[]{"Validated script file " + this.m_script_metadata[x]});
            }
        }
    }

    private void validateSqlScripts() {
        Object scriptMetadata = null;
        this.m_script_list = new ArrayList(this.m_script_metadata.length);
        ArrayList sqlList = null;
        File scriptFile = null;
        for (int i = this.m_script_metadata.length - 1; i >= 0; --i) {
            try {
                sqlList = new ArrayList();
                scriptFile = this.m_db_type.getFile(this.m_script_metadata[i].getScriptFile());
                if (this.parseScriptFile(scriptFile, sqlList)) {
                    this.m_script_list.add(sqlList);
                    continue;
                }
                sqlList.clear();
                sqlList = null;
                this.m_script_list.clear();
                this.m_script_list = null;
            }
            catch (FileNotFoundException e) {
                if (sqlList != null) {
                    sqlList.clear();
                    sqlList = null;
                }
                this.m_script_list.clear();
                this.m_script_list = null;
            }
            break;
        }
    }

    private boolean parseScriptFile(File scriptFile, List sqlList) {
        boolean returnBool;
        block7: {
            boolean loopBool = true;
            returnBool = true;
            String sqlString = null;
            String lineString = null;
            LineNumberReader lineNumberReader = null;
            try {
                lineNumberReader = new LineNumberReader(new FileReader(scriptFile));
                while (loopBool) {
                    block8: {
                        sqlString = "";
                        lineString = lineNumberReader.readLine();
                        if (lineString == null) break block7;
                        if ((lineString = lineString.trim()).length() < 1 || lineString.equals("")) continue;
                        if (lineString.startsWith("--")) {
                            SDSLogger.getLogger(JSMCommonCategory.TRACE).debug(lineString);
                            if (!lineString.startsWith("--$")) continue;
                            sqlList.add(lineString.trim());
                            continue;
                        }
                        do {
                            if (lineString.toLowerCase().endsWith(this.m_db_type.getStmtSeparator())) {
                                int sepIndex = lineString.toLowerCase().lastIndexOf(this.m_db_type.getStmtSeparator());
                                String restStr = lineString.substring(0, sepIndex);
                                sqlString = sqlString + restStr;
                            } else {
                                sqlString = sqlString + lineString + " ";
                                lineString = lineNumberReader.readLine();
                                if (lineString != null) continue;
                                returnBool = false;
                            }
                            break block8;
                        } while (!(lineString = lineString.trim()).equals("") && lineString.length() >= 1);
                        String message = I18NUtil.getMessage(I18NCode.MSG_BAD_SQL_AT_LINE, sqlString, SDSLogger.getLocale());
                        throw new IOException(message);
                    }
                    sqlList.add(sqlString);
                }
            }
            catch (Exception e) {
                returnBool = false;
                e.printStackTrace(System.err);
                SDSLogger.getLogger(JSMCommonCategory.AUDIT).log(SDSLevel.ERROR, I18NCode.GEN_THROWABLE_ERROR, new String[]{e.getMessage() + ""});
            }
        }
        return returnBool;
    }

    protected void finalize() {
        this.m_script_list.clear();
        this.m_script_list = null;
        this.m_script_metadata = null;
    }
}

