/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.jsmcommon.version.repository.utils;

import com.cognos.jsmcommon.i18n.I18NCode;
import com.cognos.jsmcommon.jdbc.JDBCConnection;
import com.cognos.jsmcommon.jdbc.NCConnection;
import com.cognos.jsmcommon.logging.SDSLevel;
import com.cognos.jsmcommon.logging.SDSLogger;
import com.cognos.jsmcommon.util.JSMCommonCategory;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class SQLUtils {
    public static JDBCConnection getConnection(String component) throws SQLException {
        return NCConnection.instance(component).getConnectionFactory().createConnection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void closeResources(String component, ResultSet rs, Statement statement, JDBCConnection connection) {
        try {
            if (null != rs) {
                rs.close();
                rs = null;
            }
            if (null != statement) {
                statement.close();
                statement = null;
            }
        }
        catch (SQLException ex) {
            SDSLogger.getLogger(JSMCommonCategory.AUDIT).log(SDSLevel.WARN, I18NCode.MSG_FAILED_TO_CLOSE_RESOURCES);
        }
        finally {
            if (null != connection) {
                SQLUtils.releaseConnection(component, connection);
            }
        }
    }

    public static void releaseConnection(String component, JDBCConnection connection) {
        try {
            NCConnection.instance(component).getConnectionFactory().releaseConnection(connection);
        }
        catch (SQLException ex) {
            SDSLogger.getLogger(JSMCommonCategory.AUDIT).log(SDSLevel.WARN, I18NCode.MSG_FAILED_TO_CLOSE_RESOURCES);
            SDSLogger.getLogger(JSMCommonCategory.AUDIT).log(SDSLevel.WARN, I18NCode.GEN_3RD_PARTY_FAULT, new String[]{"Unable to release connection: " + ex.getMessage()});
        }
    }
}

