/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.jsmcommon.dbschemavalidator;

import com.cognos.cclcfgapi.CCLConfigurationUtils;
import com.cognos.jsmcommon.jdbc.JDBCConnection;
import com.cognos.jsmcommon.jdbc.NCConnection;
import com.cognos.jsmcommon.jdbc.util.SqlResourceCloser;
import com.cognos.jsmcommon.logging.SDSLevel;
import com.cognos.jsmcommon.logging.SDSLogger;
import com.cognos.jsmcommon.property.CRNProperties;
import com.cognos.jsmcommon.property.PropertiesException;
import com.cognos.jsmcommon.util.JSMCommonCategory;
import com.ibm.cognos.jsmcommon.dbschemavalidator.DBSchemaMetadata;
import com.ibm.cognos.jsmcommon.dbschemavalidator.DBSchemaValidatorUtil;
import java.io.File;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;

public class DBSchemaValidator {
    private static String dbSchemaValidationInfoFile = null;
    private boolean isDBSchemaValidationEnabled = true;
    private static final String SQL_CHECK_TABLE_EXIST = "SELECT 1 FROM ? WHERE 1 = 0";
    private static final String SQL_GET_INSTALLED_DB_VERSION_NC = "SELECT MAX(DB_VERSION_ID) FROM NC_DB_VERSION";
    private static final String SQL_GET_INSTALLED_DB_VERSION_HTS = "SELECT MAX(dbVersionId) FROM HTS_VERSION";
    private static final String SQL_GET_INSTALLED_DB_VERSION_ANN = "SELECT MAX(version) FROM ANN_VERSION";
    private boolean isRunningInTestMode = false;
    private DBSchemaMetadata dbSchemaMetadata = null;

    public DBSchemaValidator() {
        this(false);
    }

    public DBSchemaValidator(boolean isRunningInTestMode) {
        try {
            this.isRunningInTestMode = isRunningInTestMode;
            dbSchemaValidationInfoFile = this.isRunningInTestMode ? "./jsmcommon/prod/schemas/sql/DBSchemaValidationData/DBSchemaValidationInfo.xml" : CCLConfigurationUtils.resolveEffectivePath((String)"../configuration/DBSchemaValidationInfo.xml");
            this.dbSchemaMetadata = this.parseDBSchemaValidationInfoXML();
        }
        catch (Exception ex) {
            SDSLogger.getLogger(JSMCommonCategory.TRACE).debug("DBSchemaValidator: DBSchemaValidator() : Exception : " + ex.getMessage());
        }
    }

    public DBSchemaMetadata getDBSchemaMetadata() {
        if (this.dbSchemaMetadata == null) {
            this.dbSchemaMetadata = this.parseDBSchemaValidationInfoXML();
        }
        return this.dbSchemaMetadata;
    }

    public boolean getPropertyValueFromXMLMetadatFile(String propertyName, boolean defaultValue) {
        boolean propertyValue = defaultValue;
        try {
            DBSchemaMetadata dbSchemaMetadata = this.getDBSchemaMetadata();
            if (dbSchemaMetadata != null && propertyName != null && "emf.dbSchema.validation.enabled".equalsIgnoreCase(propertyName)) {
                propertyValue = dbSchemaMetadata.isIsDbschemaValidationEnabled();
            }
        }
        catch (Exception ex) {
            SDSLogger.getLogger(JSMCommonCategory.TRACE).debug("DBSchemaValidator: getPropertyValueFromXMLMetadatFile() : Exception : " + ex.getMessage());
        }
        return propertyValue;
    }

    public Connection getDBConnection(ComponentName cName) {
        if (this.isRunningInTestMode) {
            return this.getTestConnection();
        }
        return this.getConnection(cName);
    }

    private Connection getTestConnection() {
        Connection dbConnection = null;
        try {
            String sDriverClass = "com.jnetdirect.jsql.JSQLDriver";
            String sUser = "nc_user2";
            String sPassword = "password123";
            String sUrl = "jdbc:JSQLConnect://localhost/Titan_10.2.7001.154";
            Class.forName(sDriverClass).newInstance();
            dbConnection = DriverManager.getConnection(sUrl, sUser, sPassword);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return dbConnection;
    }

    private JDBCConnection getConnection(ComponentName cName) {
        JDBCConnection jdbcConnection = null;
        try {
            jdbcConnection = cName != null && (ComponentName.HTS.equals((Object)cName) || ComponentName.ANN.equals((Object)cName)) ? NCConnection.instance("HTS").getConnectionFactory().createConnection() : NCConnection.instance().getConnectionFactory().createReadOnlyConnection();
        }
        catch (Exception ex) {
            SDSLogger.getLogger(JSMCommonCategory.TRACE).debug("DBSchemaValidator: getConnectionFromPool() : Exception : " + ex.getMessage());
        }
        return jdbcConnection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public int getInstalledDBVersion(ComponentName componentName) {
        int installedDBVersion = -1;
        PreparedStatement ps = null;
        ResultSet rs = null;
        Connection con = null;
        String getDBVersionSql = null;
        try {
            if (componentName != null) {
                if (ComponentName.NC.compareTo(componentName) == 0) {
                    getDBVersionSql = SQL_GET_INSTALLED_DB_VERSION_NC;
                } else if (ComponentName.HTS.compareTo(componentName) == 0) {
                    getDBVersionSql = SQL_GET_INSTALLED_DB_VERSION_HTS;
                } else if (ComponentName.ANN.compareTo(componentName) == 0) {
                    getDBVersionSql = SQL_GET_INSTALLED_DB_VERSION_ANN;
                }
                con = this.getDBConnection(componentName);
                if (con != null && getDBVersionSql != null && getDBVersionSql.trim().length() != 0 && (rs = (ps = con.prepareStatement(getDBVersionSql)).executeQuery()) != null) {
                    rs.next();
                    installedDBVersion = rs.getInt(1);
                }
            }
            this.releaseResources(componentName, ps, rs, con);
        }
        catch (Exception ex) {
            SDSLogger.getLogger(JSMCommonCategory.TRACE).debug("DBSchemaValidator: getInstalledDBVersion() : Exception : " + ex.getMessage());
            this.releaseResources(componentName, ps, rs, con);
        }
        catch (Throwable t) {
            SDSLogger.getLogger(JSMCommonCategory.TRACE).debug("DBSchemaValidator: getInstalledDBVersion() : Throwable Exception : " + t.getMessage());
            this.releaseResources(componentName, ps, rs, con);
            {
                catch (Throwable throwable) {
                    this.releaseResources(componentName, ps, rs, con);
                    throw throwable;
                }
            }
        }
        return installedDBVersion;
    }

    private void releaseResources(ComponentName cName, PreparedStatement ps, ResultSet rs, Connection con) {
        SqlResourceCloser.closeResources(rs, ps);
        if (con != null) {
            if (con instanceof JDBCConnection) {
                SqlResourceCloser.releaseConnection((JDBCConnection)con, cName);
            } else {
                try {
                    con.close();
                    con = null;
                }
                catch (SQLException ex) {
                    SDSLogger.getLogger(JSMCommonCategory.TRACE).debug("DBSchemaValidator: releaseResources() : Exception : " + ex.getMessage());
                }
            }
        }
    }

    public synchronized boolean validateDBSchema(ComponentName componentName, boolean atServiceStart) {
        boolean isDBSchemaValid = true;
        try {
            if (this.isDBSchemaValidationEnabled()) {
                SDSLogger.getLogger(JSMCommonCategory.TRACE).debug("DBSchemaValidator: validateDBSchema() : DB SCHEMA VALIDATION IS ENABLED, ATTEMPTING SCHEMA VALIDATION!  component : " + (Object)((Object)componentName));
                if (componentName != null) {
                    int installedDBVersion = this.getInstalledDBVersion(componentName);
                    SDSLogger.getLogger(JSMCommonCategory.TRACE).debug("DBSchemaValidator: validateDBSchema() :  component : " + (Object)((Object)componentName) + " : INSTALLED DB VERSION: " + installedDBVersion);
                    if (installedDBVersion > 0) {
                        isDBSchemaValid = this.validateAllTheTables(componentName, installedDBVersion);
                    } else {
                        SDSLogger.getLogger(JSMCommonCategory.TRACE).debug("DBSchemaValidator: validateDBSchema() :  component : " + (Object)((Object)componentName) + " : DB SCHEMA VALIDATION FAILED: DB VERSION TABLE DOES NOT EXIST OR DB VERSION CANNOT BE DETERMINED !");
                        isDBSchemaValid = false;
                    }
                    if (isDBSchemaValid) {
                        DBSchemaValidatorUtil.logDBSchemaValidationSuccess(componentName, atServiceStart);
                    } else {
                        DBSchemaValidatorUtil.logDBSchemaValidationFailure(componentName, atServiceStart);
                    }
                    SDSLogger.getLogger(JSMCommonCategory.TRACE).debug("DBSchemaValidation: DBSchemaValidatorUtil: validateDBSchema(): DB SCHEMA VALIDATION DONE !! : " + (Object)((Object)componentName) + " DB SCHEMA VALIDATION STATUS : isDBSchemaValidationSuccessful = " + isDBSchemaValid + " : atServiceStart = " + atServiceStart);
                } else {
                    isDBSchemaValid = true;
                    SDSLogger.getLogger(JSMCommonCategory.TRACE).debug("DBSchemaValidator: validateDBSchema() :  component : " + (Object)((Object)componentName) + " : DB SCHEMA VALIDATION FAILED: THE COMPONENT NAME IS NULL SO DB SCHEMA VALIDATION IS NOT POSSIBLE !");
                }
            } else {
                SDSLogger.getLogger(JSMCommonCategory.TRACE).debug("DBSchemaValidator: validateDBSchema() :  component : " + (Object)((Object)componentName) + " : DB SCHEMA VALIDATION IS DISABLED, THE SCHEMA WILL NOT BE VALIDATED!");
                isDBSchemaValid = true;
            }
        }
        catch (Exception ex) {
            SDSLogger.getLogger(JSMCommonCategory.TRACE).debug("DBSchemaValidator: validateDBSchema() : Exception : " + ex.getMessage());
        }
        return isDBSchemaValid;
    }

    /*
     * Exception decompiling
     */
    public synchronized boolean validateAllTheTables(ComponentName componentName, int installedDBVersion) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public DBSchemaMetadata.Schema getValidationDBSchemaForInstalledDBVersion(ComponentName componentName, int installedDBVersion) {
        DBSchemaMetadata.Schema dbSchema = null;
        try {
            DBSchemaMetadata dbSchemaMetadata = this.getDBSchemaMetadata();
            if (dbSchemaMetadata != null) {
                for (DBSchemaMetadata.Schema schema : dbSchemaMetadata.schema) {
                    if (dbSchema == null && schema.getComponentName() != null && schema.getComponentName().equalsIgnoreCase(componentName.name()) && schema.getDbVersion() <= installedDBVersion) {
                        dbSchema = schema;
                        continue;
                    }
                    if (dbSchema == null || schema.getComponentName() == null || !schema.getComponentName().equalsIgnoreCase(componentName.name()) || schema.getDbVersion() <= dbSchema.getDbVersion() || schema.getDbVersion() > installedDBVersion) continue;
                    dbSchema = schema;
                }
            }
        }
        catch (Exception ex) {
            SDSLogger.getLogger(JSMCommonCategory.TRACE).debug("DBSchemaValidator: getValidationDBSchemaForInstalledDBVersion() : Exception : " + ex.getMessage());
        }
        return dbSchema;
    }

    public synchronized DBSchemaMetadata parseDBSchemaValidationInfoXML() {
        DBSchemaMetadata dbSchemaMetadata = null;
        try {
            if (dbSchemaValidationInfoFile != null && dbSchemaValidationInfoFile.trim().length() != 0) {
                File file = new File(dbSchemaValidationInfoFile);
                JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{DBSchemaMetadata.class});
                Unmarshaller jaxbUnmarshaller = jaxbContext.createUnmarshaller();
                dbSchemaMetadata = (DBSchemaMetadata)jaxbUnmarshaller.unmarshal(file);
            }
        }
        catch (JAXBException ex) {
            SDSLogger.getLogger(JSMCommonCategory.TRACE).debug("DBSchemaValidator: parseDBSchemaValidationInfoXML() : JAXBException : " + ex.getMessage());
        }
        catch (Exception ex) {
            SDSLogger.getLogger(JSMCommonCategory.TRACE).debug("DBSchemaValidator: parseDBSchemaValidationInfoXML() : Exception : " + ex.getMessage());
        }
        return dbSchemaMetadata;
    }

    public boolean isDBSchemaValidationEnabled() {
        boolean result = true;
        try {
            result = this.getPropertyValue("emf.dbSchema.validation.enabled", result);
        }
        catch (Throwable t) {
            SDSLogger.getLogger(JSMCommonCategory.TRACE).log(SDSLevel.WARN, t);
            SDSLogger.getLogger(JSMCommonCategory.TRACE).debug("DBSchemaValidator: isDBSchemaValidationEnabled() : Throwable : " + t.getMessage());
        }
        return result;
    }

    private boolean getPropertyValue(String propertyName, boolean defaultValue) {
        boolean propertyValue = defaultValue;
        try {
            if (propertyName != null) {
                String property = CRNProperties.getInstance().getProperty(propertyName);
                propertyValue = property != null ? Boolean.valueOf(property).booleanValue() : this.getPropertyValueFromXMLMetadatFile(propertyName, defaultValue);
            }
        }
        catch (PropertiesException ex) {
            SDSLogger.getLogger(JSMCommonCategory.TRACE).log(SDSLevel.WARN, ex);
        }
        catch (Throwable t) {
            SDSLogger.getLogger(JSMCommonCategory.TRACE).log(SDSLevel.WARN, t);
        }
        return propertyValue;
    }

    public static enum ComponentName {
        NC,
        HTS,
        ANN;

    }
}

