/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.jsmcommon.dbschemavalidator;

import com.cognos.jsmcommon.logging.SDSLevel;
import com.cognos.jsmcommon.logging.SDSLogger;
import com.cognos.jsmcommon.property.CRNProperties;
import com.cognos.jsmcommon.property.PropertiesException;
import com.cognos.jsmcommon.util.JSMCommonCategory;
import com.ibm.cognos.jsmcommon.dbschemavalidator.DBSchemaValidator;
import com.ibm.cognos.jsmcommon.dbschemavalidator.DBSchemaValidatorTimerTask;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;

public class DBSchemaValidatorAtIntervals {
    private static final long RUN_INTERVAL = 604800000L;
    private static DBSchemaValidatorAtIntervals m_dbSchemaValidatorAtIntervals = null;
    Timer timer = null;
    List<DBSchemaValidator.ComponentName> dbSchemaValidationStartedServiceList = null;

    private DBSchemaValidatorAtIntervals() {
        try {
            this.timer = new Timer();
            this.dbSchemaValidationStartedServiceList = Collections.synchronizedList(new ArrayList());
        }
        catch (Exception ex) {
            SDSLogger.getLogger(JSMCommonCategory.TRACE).debug("DBSchemaValidatorAtIntervals: DBSchemaValidatorAtIntervals: error in constructor : Exception : " + ex.getMessage());
        }
    }

    public static DBSchemaValidatorAtIntervals getInstance() {
        if (m_dbSchemaValidatorAtIntervals == null) {
            m_dbSchemaValidatorAtIntervals = new DBSchemaValidatorAtIntervals();
        }
        return m_dbSchemaValidatorAtIntervals;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void startDBSchemaValidationAtIntervals(DBSchemaValidator.ComponentName cName) {
        try {
            if (this.dbSchemaValidationStartedServiceList == null) {
                this.dbSchemaValidationStartedServiceList = Collections.synchronizedList(new ArrayList());
            }
            List<DBSchemaValidator.ComponentName> list = this.dbSchemaValidationStartedServiceList;
            synchronized (list) {
                if (this.dbSchemaValidationStartedServiceList != null && !this.dbSchemaValidationStartedServiceList.contains((Object)cName)) {
                    Date date = DBSchemaValidatorAtIntervals.getDBSchemaValidatorFirstRunDateTime();
                    if (date == null) {
                        date = new Date();
                    }
                    if (this.timer == null) {
                        this.timer = new Timer();
                    }
                    new Timer("DBSchemaValidator-" + (Object)((Object)cName)).scheduleAtFixedRate((TimerTask)new DBSchemaValidatorTimerTask(cName), date, DBSchemaValidatorAtIntervals.getRunInterval());
                    this.dbSchemaValidationStartedServiceList.add(cName);
                }
            }
        }
        catch (Exception ex) {
            SDSLogger.getLogger(JSMCommonCategory.TRACE).debug("DBSchemaValidatorAtIntervals: startDBSchemaValidationAtIntervals() : Problem starting validator for : " + (Object)((Object)cName) + " : Exception : " + ex.getMessage());
        }
    }

    public static long getRunInterval() {
        long propertyValue = 604800000L;
        try {
            String property = CRNProperties.getInstance().getProperty("emf.dbSchema.validation.run.interval");
            if (property != null) {
                propertyValue = Long.valueOf(property) * 60000L;
            }
        }
        catch (PropertiesException ex) {
            propertyValue = 604800000L;
            SDSLogger.getLogger(JSMCommonCategory.TRACE).log(SDSLevel.WARN, ex);
            SDSLogger.getLogger(JSMCommonCategory.TRACE).debug("DBSchemaValidatorAtIntervals: getRunInterval() : Exception : " + ex.getMessage());
        }
        catch (Throwable t) {
            propertyValue = 604800000L;
            SDSLogger.getLogger(JSMCommonCategory.TRACE).log(SDSLevel.WARN, t);
            SDSLogger.getLogger(JSMCommonCategory.TRACE).debug("DBSchemaValidatorAtIntervals: getRunInterval() : Throwable Exception : " + t.getMessage());
        }
        return propertyValue;
    }

    public static int getDBSchemaValidationFirstRunHourOfDay() {
        int propertyValue = -1;
        try {
            String property = CRNProperties.getInstance().getProperty("emf.dbSchema.validation.first.run.hour.of.day");
            if (property != null) {
                propertyValue = Integer.valueOf(property);
            }
        }
        catch (PropertiesException ex) {
            SDSLogger.getLogger(JSMCommonCategory.TRACE).log(SDSLevel.WARN, ex);
            SDSLogger.getLogger(JSMCommonCategory.TRACE).debug("DBSchemaValidatorAtIntervals: getDBSchemaValidationFirstRunHourOfDay() : Exception : " + ex.getMessage());
        }
        catch (Throwable t) {
            SDSLogger.getLogger(JSMCommonCategory.TRACE).log(SDSLevel.WARN, t);
            SDSLogger.getLogger(JSMCommonCategory.TRACE).debug("DBSchemaValidatorAtIntervals: getDBSchemaValidationFirstRunHourOfDay() : Throwable Exception : " + t.getMessage());
        }
        return propertyValue;
    }

    public synchronized void stop() {
        if (this.timer != null) {
            this.timer.cancel();
        }
    }

    private static Date getDBSchemaValidatorFirstRunDateTime() {
        Date date = null;
        try {
            int hourOfDay = DBSchemaValidatorAtIntervals.getDBSchemaValidationFirstRunHourOfDay();
            if (0 <= hourOfDay && hourOfDay <= 23) {
                GregorianCalendar cal = new GregorianCalendar();
                cal.set(11, hourOfDay);
                cal.set(12, 0);
                cal.set(13, 0);
                cal.set(14, 0);
                ((Calendar)cal).add(5, 1);
                date = cal.getTime();
            } else {
                date = new Date();
            }
        }
        catch (Exception ex) {
            SDSLogger.getLogger(JSMCommonCategory.TRACE).debug("DBSchemaValidatorAtIntervals: getDBSchemaValidatorFirstRunDateTime() : Exception : " + ex.getMessage());
        }
        return date;
    }
}

