/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.jsmcommon.dbschemavalidator;

import com.cognos.jsmcommon.logging.SDSLevel;
import com.cognos.jsmcommon.logging.SDSLogger;
import com.cognos.jsmcommon.property.CRNProperties;
import com.cognos.jsmcommon.property.PropertiesException;
import com.cognos.jsmcommon.util.JSMCommonCategory;
import com.ibm.cognos.jsmcommon.dbschemavalidator.DBSchemaValidator;
import com.ibm.cognos.jsmcommon.dbschemavalidator.DBSchemaValidatorUtil;
import java.util.TimerTask;

class DBSchemaValidatorTimerTask
extends TimerTask {
    DBSchemaValidator.ComponentName cName = null;

    public DBSchemaValidatorTimerTask(DBSchemaValidator.ComponentName cName) {
        this.cName = cName;
    }

    @Override
    public void run() {
        try {
            if (this.isDBSchemaValidationAtRegularIntervalsEnabled()) {
                SDSLogger.getLogger(JSMCommonCategory.TRACE).debug("DBSchemaValidatorTimerTask: run() : Validating DB Schema!");
                DBSchemaValidatorUtil.validateDBSchema(this.cName, false);
            } else {
                SDSLogger.getLogger(JSMCommonCategory.TRACE).debug("DBSchemaValidatorTimerTask: run() : DB Schema Validation at regular interval is not enabled!");
            }
        }
        catch (Exception ex) {
            SDSLogger.getLogger(JSMCommonCategory.TRACE).debug("DBSchemaValidatorTimerTask: run() : Exception : " + ex.getMessage());
        }
    }

    private boolean isDBSchemaValidationAtRegularIntervalsEnabled() {
        boolean propertyValue = false;
        try {
            String property = CRNProperties.getInstance().getProperty("emf.dbSchema.validation.at.intervals.enabled");
            if (property != null) {
                propertyValue = Boolean.valueOf(property);
            }
        }
        catch (PropertiesException ex) {
            SDSLogger.getLogger(JSMCommonCategory.TRACE).log(SDSLevel.WARN, ex);
        }
        catch (Throwable t) {
            SDSLogger.getLogger(JSMCommonCategory.TRACE).log(SDSLevel.WARN, t);
        }
        return propertyValue;
    }
}

