/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.jsmcommon.dbschemavalidator;

import com.cognos.jsmcommon.logging.SDSLevel;
import com.cognos.jsmcommon.logging.SDSLogger;
import com.cognos.jsmcommon.util.AuditProperties;
import com.cognos.jsmcommon.util.JSMCommonCategory;
import com.ibm.cognos.jsmcommon.dbschemavalidator.DBSchemaValidator;

public class DBSchemaValidatorUtil {
    public static boolean validateDBSchema(DBSchemaValidator.ComponentName cName, boolean atServiceStart) {
        boolean isDBSchemaValidationSuccessful = true;
        try {
            if (cName != null) {
                DBSchemaValidator dbSchemaValidator = new DBSchemaValidator();
                isDBSchemaValidationSuccessful = dbSchemaValidator.validateDBSchema(cName, atServiceStart);
                SDSLogger.getLogger(JSMCommonCategory.TRACE).debug("DBSchemaValidation: DBSchemaValidatorUtil: validateDBSchema(): DB SCHEMA VALIDATION CALLED FOR COMPONENT : " + (Object)((Object)cName) + " : atServiceStart = " + atServiceStart);
            } else {
                isDBSchemaValidationSuccessful = true;
                SDSLogger.getLogger(JSMCommonCategory.TRACE).debug("DBSchemaValidation: DBSchemaValidatorUtil: validateDBSchema(): DB SCHEMA VALIDATION FAILED: THE COMPONENT NAME IS NULL, SO DB SCHEMA VALIDATION IS NOT POSSIBLE !");
            }
        }
        catch (Exception ex) {
            SDSLogger.getLogger(JSMCommonCategory.TRACE).debug("DBSchemaValidation: DBSchemaValidatorUtil: validateDBSchema(): Exception : " + ex.getMessage());
        }
        catch (Throwable t) {
            SDSLogger.getLogger(JSMCommonCategory.TRACE).debug("DBSchemaValidation: DBSchemaValidatorUtil: validateDBSchema(): Throwable Exception : " + t.getMessage());
        }
        return isDBSchemaValidationSuccessful;
    }

    public static void logDBSchemaValidationFailure(DBSchemaValidator.ComponentName cName, boolean atServiceStart) {
        String operation = "Run";
        if (atServiceStart) {
            operation = "StartService";
        }
        DBSchemaValidatorUtil.log(DBSchemaValidatorUtil.getServiceName(cName), DBSchemaValidatorUtil.getValidationFailureMessage(cName), operation);
    }

    public static void logDBSchemaValidationSuccess(DBSchemaValidator.ComponentName cName, boolean atServiceStart) {
        String operation = "Run";
        if (atServiceStart) {
            operation = "StartService";
        }
        DBSchemaValidatorUtil.log(DBSchemaValidatorUtil.getServiceName(cName), DBSchemaValidatorUtil.getValidationSuccessMessage(cName), operation);
    }

    public static void log(String service, String msg, String operation) {
        if (operation == null) {
            operation = "Run";
        }
        AuditProperties props = new AuditProperties(operation, msg, service, msg);
        SDSLogger.getLogger(JSMCommonCategory.AUDIT).log(SDSLevel.FATAL, props);
    }

    public static String getServiceName(DBSchemaValidator.ComponentName cName) {
        String serviceName = "EventService";
        try {
            if (cName != null && DBSchemaValidator.ComponentName.NC.equals((Object)cName)) {
                serviceName = "EventService";
            } else if (cName != null && DBSchemaValidator.ComponentName.HTS.equals((Object)cName)) {
                serviceName = "HumanTaskService";
            } else if (cName != null && DBSchemaValidator.ComponentName.ANN.equals((Object)cName)) {
                serviceName = "AnnotationService";
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return serviceName;
    }

    private static String getValidationSuccessMessage(DBSchemaValidator.ComponentName cName) {
        String message = "DB Validation successful.";
        if (cName != null) {
            message = (Object)((Object)cName) + " " + message;
        }
        return message;
    }

    private static String getValidationFailureMessage(DBSchemaValidator.ComponentName cName) {
        String message = "DB Validation failed.";
        if (cName != null) {
            message = (Object)((Object)cName) + " " + message;
            if (cName.equals((Object)DBSchemaValidator.ComponentName.NC)) {
                message = message + " Some of the EMF services (Monitor Service, Delivery Serivice, Agent Service, Job Service, etc may not work properly.";
            } else if (cName.equals((Object)DBSchemaValidator.ComponentName.HTS)) {
                message = message + " Human Task Service may not work properly.";
            } else if (cName.equals((Object)DBSchemaValidator.ComponentName.ANN)) {
                message = message + " Annotation Service may not work properly.";
            }
        }
        return message;
    }
}

