/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.mapviewer;

import java.awt.geom.Rectangle2D;
import java.util.Set;
import org.jdesktop.swingx.mapviewer.GeoPosition;

public class GeoBounds {
    private Rectangle2D[] rects;

    public GeoBounds(double minLat, double minLng, double maxLat, double maxLng) {
        this.setRect(minLat, minLng, maxLat, maxLng);
    }

    public GeoBounds(Set<GeoPosition> geoPositions) {
        if (geoPositions == null || geoPositions.size() < 2) {
            throw new IllegalArgumentException("The attribute 'geoPositions' cannot be null and must have 2 or more elements.");
        }
        double minLat = 2.147483647E9;
        double minLng = 2.147483647E9;
        double maxLat = -2.147483648E9;
        double maxLng = -2.147483648E9;
        for (GeoPosition position : geoPositions) {
            minLat = Math.min(minLat, position.getLatitude());
            minLng = Math.min(minLng, position.getLongitude());
            maxLat = Math.max(maxLat, position.getLatitude());
            maxLng = Math.max(maxLng, position.getLongitude());
        }
        this.setRect(minLat, minLng, maxLat, maxLng);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void setRect(double minLat, double minLng, double maxLat, double maxLng) {
        if (!(minLat < maxLat)) {
            throw new IllegalArgumentException("GeoBounds is not valid - minLat must be less that maxLat.");
        }
        if (minLng < maxLng) {
            this.rects = new Rectangle2D[]{new Rectangle2D.Double(minLng, minLat, maxLng - minLng, maxLat - minLat)};
            return;
        }
        if (minLng > 0.0 && minLng < 180.0 && maxLng < 0.0) {
            this.rects = new Rectangle2D[]{new Rectangle2D.Double(minLng, minLat, 180.0 - minLng, maxLat - minLat), new Rectangle2D.Double(-180.0, minLat, maxLng + 180.0, maxLat - minLat)};
            return;
        }
        this.rects = new Rectangle2D[]{new Rectangle2D.Double(minLng, minLat, maxLng - minLng, maxLat - minLat)};
        throw new IllegalArgumentException("GeoBounds is not valid - minLng must be less that maxLng or minLng must be greater than 0 and maxLng must be less than 0.");
    }

    public boolean intersects(GeoBounds other) {
        boolean rv = false;
        Rectangle2D[] rectangle2DArray = this.rects;
        int n = this.rects.length;
        int n2 = 0;
        while (n2 < n) {
            Rectangle2D r1 = rectangle2DArray[n2];
            Rectangle2D[] rectangle2DArray2 = other.rects;
            int n3 = other.rects.length;
            int n4 = 0;
            while (n4 < n3) {
                Rectangle2D r2 = rectangle2DArray2[n4];
                rv = r1.intersects(r2);
                if (rv) break;
                ++n4;
            }
            if (rv) break;
            ++n2;
        }
        return rv;
    }

    public GeoPosition getNorthWest() {
        return new GeoPosition(this.rects[0].getX(), this.rects[0].getMaxY());
    }

    public GeoPosition getSouthEast() {
        Rectangle2D r = this.rects[0];
        if (this.rects.length > 1) {
            r = this.rects[1];
        }
        return new GeoPosition(r.getMaxX(), r.getY());
    }
}

