/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.logserver;

import com.cognos.logserver.LogServerIndicationQueue;
import com.cognos.pogo.monitoring.RequestReporter;

abstract class LogAbstractServer
extends Thread {
    protected static final int TIMEOUT = 2000;
    protected LogServerIndicationQueue m_queue;
    protected int m_port;
    protected boolean m_serviceRunning = true;

    LogAbstractServer() {
    }

    synchronized void setReporter(RequestReporter reporter) {
        if (this.m_queue != null) {
            this.m_queue.m_reporter = reporter;
        }
    }

    synchronized void activateQueue() {
        this.m_queue.activate();
    }

    synchronized void enqueue(byte[] indication) {
        this.m_queue.enqueue(indication);
    }

    synchronized void suspendQueue() {
        this.m_queue.suspend();
    }

    @Override
    public abstract void run();

    abstract void shutdown();

    abstract String getProtocol();

    public boolean isServiceRunning() {
        return this.m_serviceRunning;
    }
}

