/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.logserver;

import com.cognos.accman.jcam.crypto.CAMFactory;
import com.cognos.indications.LogIPFConfigure;
import com.cognos.indications.LogIPFLog;
import com.cognos.logserver.LogAbstractServer;
import com.cognos.logserver.LogServerIndicationQueue;
import com.cognos.logserver.LogServerMessage;
import com.cognos.logserver.LogTCPSocket;
import java.io.InterruptedIOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.util.LinkedList;

class LogServerConnection
extends LogAbstractServer {
    private boolean m_active = false;
    private LinkedList m_connections = new LinkedList();
    private ServerSocket m_serverSocket = null;
    private boolean m_flush = false;
    private CAMFactory m_cf = null;
    private static final int SOCKET_INFINITE_TIMEOUT = 0;

    LogServerConnection(int port, int workerThreads) {
        this.m_port = port;
        this.m_queue = new LogServerIndicationQueue(workerThreads);
        this.m_queue.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.m_serverSocket = null;
        try {
            if (LogIPFConfigure.enableSSL()) {
                this.m_serverSocket = this.getCAMFactory().createServerSocket(this.m_port, true);
                LogIPFLog.debug((String)"TCP Secure Server Socket created");
            } else {
                this.m_serverSocket = new ServerSocket(this.m_port);
                LogIPFLog.debug((String)"TCP Server Socket created");
            }
            if (null == this.m_serverSocket) {
                LogServerMessage.logError("StopService", LogIPFConfigure.getServerPort(), (short)2, "Null Server socket");
                return;
            }
            this.m_serverSocket.setSoTimeout(2000);
            LogServerConnection logServerConnection = this;
            synchronized (logServerConnection) {
                this.notifyAll();
            }
            this.m_active = true;
        }
        catch (Exception e) {
            this.m_active = false;
            LogServerMessage.logError("StopService", LogIPFConfigure.getServerPort(), (short)5, e.getMessage());
        }
        while (this.m_active) {
            try {
                Socket socket = this.m_serverSocket.accept();
                socket.setSoTimeout(0);
                LogTCPSocket t = new LogTCPSocket(socket, this.m_queue);
                this.m_connections.add(t);
                t.start();
            }
            catch (InterruptedIOException e) {
                this.m_queue.flush();
            }
            catch (SocketException e) {
                this.m_active = false;
            }
            catch (Exception e) {
                this.m_active = false;
                LogIPFLog.error((String)"LogServerConnection.run caught exception: ", (Throwable)e);
            }
        }
        if (this.m_queue != null) {
            if (this.m_flush) {
                this.m_queue.flush();
            }
            this.m_queue.shutdown();
        }
    }

    @Override
    synchronized void shutdown() {
        try {
            this.m_active = false;
            this.m_serverSocket.close();
        }
        catch (Exception e) {
            LogIPFLog.error((String)"LogServerConnection.shutdown caught exception: ", (Throwable)e);
        }
        this.m_flush = true;
        while (this.m_connections.size() > 0) {
            LogTCPSocket t = (LogTCPSocket)this.m_connections.removeFirst();
            t.halt();
            try {
                t.join();
            }
            catch (InterruptedException e) {
                LogIPFLog.error((String)"LogServerConnection.shutdown caught exception: ", (Throwable)e);
            }
        }
    }

    private synchronized CAMFactory getCAMFactory() {
        if (null == this.m_cf) {
            this.m_cf = new CAMFactory();
            try {
                this.m_cf.initialize("<initializeDocument><serviceID>IPF</serviceID></initializeDocument>".getBytes());
            }
            catch (Exception e) {
                LogServerMessage.logError("StopService", LogIPFConfigure.getServerPort(), (short)1, e.getMessage());
            }
        }
        return this.m_cf;
    }

    @Override
    String getProtocol() {
        return "TCP";
    }
}

