/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.logserver;

import com.cognos.indications.LogIPFLog;
import com.cognos.indications.LogIndication;
import com.cognos.logserver.LogServerIndicationQueue;
import com.cognos.logserver.ServerIndicationLogger;
import java.io.ByteArrayInputStream;
import java.io.ObjectInputStream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ObjectMessage;

class LogServerIndicationProcessor
implements Runnable {
    private final LogServerIndicationQueue m_queue;

    LogServerIndicationProcessor(LogServerIndicationQueue queue) {
        this.m_queue = queue;
    }

    @Override
    public void run() {
        Thread.currentThread().setPriority(7);
        Logger auditLogger = LogManager.getLogger((String)"server.Audit");
        byte[] indication = this.m_queue.dequeue();
        while (indication != null) {
            try (ByteArrayInputStream bis = new ByteArrayInputStream(indication, 0, indication.length);
                 ObjectInputStream ois = new ObjectInputStream(bis);){
                if (this.m_queue.m_reporter != null) {
                    this.m_queue.m_reporter.incrementInitialRequests("logService");
                }
                long startTime = System.currentTimeMillis();
                String name = ois.readUTF();
                Object obj = ois.readObject();
                ois.close();
                LogIndication ind = this.toLogIndication(obj);
                if (ind != null) {
                    ServerIndicationLogger serverIndicationLog = ind.getLevel() == 50000 ? new ServerIndicationLogger("startup." + name) : new ServerIndicationLogger(name);
                    serverIndicationLog.log(ind.getLevel(), ind);
                    if (name.startsWith("Audit") || name.startsWith("server.Audit")) {
                        this.logIndication(auditLogger, ind);
                    }
                    long endTime = System.currentTimeMillis();
                    if (this.m_queue.m_reporter != null) {
                        this.m_queue.m_reporter.reportSuccess(endTime - startTime);
                    }
                }
            }
            catch (Exception x) {
                LogIPFLog.error((String)"LogServerIndicationProcessor caught exception: ", (Throwable)x);
            }
            catch (OutOfMemoryError memError) {
                System.gc();
                LogIPFLog.debug((String)"OutOfMemoryError caught.  Garbage collector has been called to free up memory.");
            }
            indication = this.m_queue.dequeue();
        }
    }

    private void logIndication(Logger auditLogger, LogIndication indication) {
        switch (indication.getLevel()) {
            case 50000: {
                auditLogger.fatal((Object)indication);
                break;
            }
            case 40000: {
                auditLogger.error((Object)indication);
                break;
            }
            case 30000: {
                auditLogger.warn((Object)indication);
                break;
            }
            case 20000: {
                auditLogger.info((Object)indication);
                break;
            }
            case 10000: {
                auditLogger.fatal((Object)indication);
            }
        }
    }

    private LogIndication toLogIndication(Object obj) {
        Object[] params;
        LogIndication ind = null;
        if (obj instanceof LogIndication) {
            ind = (LogIndication)obj;
        } else if (obj instanceof ObjectMessage && (params = ((ObjectMessage)obj).getParameters()) != null && params.length > 0 && params[0] instanceof LogIndication) {
            ind = (LogIndication)params[0];
        }
        return ind;
    }
}

