/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.logserver;

import com.cognos.indications.LogIPFLog;
import com.cognos.logserver.LogServerIndicationProcessor;
import com.cognos.pogo.monitoring.RequestReporter;
import java.util.LinkedList;

class LogServerIndicationQueue {
    private int m_workerThreads;
    private Object sequencer = new Object();
    private boolean queueActive = true;
    private boolean operational = true;
    private LinkedList<Thread> processors = new LinkedList();
    private LinkedList<byte[]> indications = new LinkedList();
    private static final int MAXIMUM_WORKER_THREADS = 20;
    private static final int MINIMUM_WORKER_THREADS = 1;
    protected RequestReporter m_reporter = null;

    LogServerIndicationQueue(int workerThreads) {
        this.m_workerThreads = 20 < workerThreads ? 20 : (1 > workerThreads ? 1 : workerThreads);
    }

    void start() {
        for (int i = 0; i < this.m_workerThreads; ++i) {
            Thread processor = new Thread(new LogServerIndicationProcessor(this));
            processor.setDaemon(true);
            this.processors.add(processor);
            processor.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void enqueue(byte[] indication) {
        if (this.operational) {
            LinkedList<byte[]> linkedList = this.indications;
            synchronized (linkedList) {
                this.indications.add(indication);
                if (this.indications.size() > this.m_workerThreads) {
                    try {
                        this.indications.notify();
                    }
                    catch (Exception e) {
                        LogIPFLog.error((String)"LogServerIndicationQueue.enqueue caught exception: ", (Throwable)e);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    byte[] dequeue() {
        Object object = this.sequencer;
        synchronized (object) {
            while (true) {
                LinkedList<byte[]> linkedList = this.indications;
                synchronized (linkedList) {
                    if (this.indications.size() == 0 && !this.operational) {
                        return null;
                    }
                    if (this.queueActive && this.indications.size() > 0) {
                        return this.indications.removeFirst();
                    }
                    try {
                        this.indications.wait();
                    }
                    catch (Exception e) {
                        LogIPFLog.error((String)"LogServerIndicationQueue.dequeue caught exception: ", (Throwable)e);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void flush() {
        LinkedList<byte[]> linkedList = this.indications;
        synchronized (linkedList) {
            if (this.indications.size() > 0) {
                this.indications.notify();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void suspend() {
        LogServerIndicationQueue logServerIndicationQueue = this;
        synchronized (logServerIndicationQueue) {
            this.queueActive = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void activate() {
        LogServerIndicationQueue logServerIndicationQueue = this;
        synchronized (logServerIndicationQueue) {
            this.queueActive = true;
            this.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void shutdown() {
        LogServerIndicationQueue logServerIndicationQueue = this;
        synchronized (logServerIndicationQueue) {
            this.operational = false;
            this.notify();
        }
        for (int i = 0; i < this.m_workerThreads; ++i) {
            LinkedList<byte[]> linkedList = this.indications;
            synchronized (linkedList) {
                this.indications.notify();
            }
            try {
                Thread processor = this.processors.removeFirst();
                processor.join();
                continue;
            }
            catch (Exception e) {
                LogIPFLog.error((String)"LogServerIndicationQueue.shutdown caught exception: ", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void clear() {
        LinkedList<byte[]> linkedList = this.indications;
        synchronized (linkedList) {
            try {
                this.indications.clear();
            }
            catch (Exception e) {
                LogIPFLog.error((String)"LogServerIndicationQueue.clear caught exception: ", (Throwable)e);
            }
        }
    }
}

