/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.logserver;

import com.cognos.indications.LogAuditAccessIndication;
import com.cognos.indications.LogIPFControl;
import com.cognos.indications.LogIPFLog;
import com.cognos.indications.LogTypedLogger;
import com.cognos.logserver.LogAbstractServer;
import com.cognos.logserver.LogServerIndicationQueue;
import com.cognos.logserver.Version;
import java.io.InterruptedIOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.SocketException;

class LogServerMessage
extends LogAbstractServer {
    private DatagramSocket m_ds;
    private boolean m_run = true;
    private boolean m_flush;
    private static LogTypedLogger m_serverLogger = null;

    LogServerMessage(int port, int workerThreads) {
        this.setPriority(10);
        this.m_port = port;
        this.m_queue = new LogServerIndicationQueue(workerThreads);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        byte[] buffer = new byte[65536];
        DatagramPacket dp = null;
        try {
            this.m_ds = new DatagramSocket(this.m_port);
            this.m_ds.setSoTimeout(2000);
            this.m_ds.setReceiveBufferSize(65536);
            this.m_ds.setSendBufferSize(65536);
            this.m_queue.start();
        }
        catch (SocketException e1) {
            LogServerMessage.logError("StartService", this.m_port, (short)2, e1.getMessage());
            this.m_run = false;
            this.m_serviceRunning = false;
        }
        catch (Exception e) {
            LogServerMessage.logError("StartService", this.m_port, (short)3, e.getMessage());
            this.m_run = false;
            this.m_serviceRunning = false;
        }
        LogServerMessage e = this;
        synchronized (e) {
            this.notifyAll();
        }
        while (this.m_run) {
            try {
                dp = new DatagramPacket(buffer, buffer.length);
                this.m_ds.receive(dp);
                byte[] indication = new byte[dp.getLength()];
                System.arraycopy(buffer, 0, indication, 0, dp.getLength());
                this.m_queue.enqueue(indication);
            }
            catch (InterruptedIOException e2) {
                this.m_queue.flush();
            }
            catch (Exception e3) {
                if (this.m_run) {
                    LogIPFLog.error((String)"LogServer stopping because of Exception ", (Throwable)e3);
                }
                this.m_run = false;
                this.m_serviceRunning = false;
            }
            catch (OutOfMemoryError memError) {
                System.gc();
                LogIPFLog.debug((String)"OutOfMemoryException caught.  Garbage collector has been called to free up memory.");
            }
            catch (Error e4) {
                LogIPFLog.error((String)"LogServerMessage - JVM error ", (Throwable)e4);
                LogIPFLog.error((String)"LogServer stopping");
                this.m_run = false;
                this.m_serviceRunning = false;
            }
        }
        if (this.m_queue != null) {
            if (this.m_flush) {
                this.m_queue.flush();
            }
            this.m_queue.shutdown();
        }
        if (this.m_ds != null) {
            this.m_ds.close();
        }
    }

    protected static void logError(String opType, int port, short errCode, String errStr) {
        LogIPFLog.error((String)errStr);
        if (null == m_serverLogger) {
            m_serverLogger = LogTypedLogger.getInstance((String)"server.Audit.IPF", LogAuditAccessIndication.class);
        }
        if (m_serverLogger != null) {
            StringBuffer buffer = new StringBuffer(160);
            buffer.append("<parameters><item name=\"Port\"><![CDATA[");
            buffer.append(port);
            buffer.append("]]></item><item name=\"Error\"><![CDATA[");
            buffer.append(errStr);
            buffer.append("]]></item></parameters>");
            LogAuditAccessIndication errIndication = new LogAuditAccessIndication("LOGSV", Version.getMajorBuild());
            errIndication.setLevel(50000);
            errIndication.setOperation(opType);
            errIndication.setLogData(buffer.toString());
            errIndication.setObjectPath("");
            errIndication.setObjectType("LogService");
            errIndication.setStatus("Failed");
            errIndication.setErrorMessage(LogIPFControl.getErrMsg((short)errCode));
            m_serverLogger.log((Object)errIndication);
        }
    }

    @Override
    void shutdown() {
        this.m_run = false;
        this.m_ds.close();
        this.m_ds = null;
        this.m_flush = true;
    }

    @Override
    String getProtocol() {
        return "UDP";
    }
}

