/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.logserver;

import com.cognos.cclcfgapi.ICCLConfiguration;
import com.cognos.indications.LogAuditAccessIndication;
import com.cognos.indications.LogIPFConfigure;
import com.cognos.indications.LogIPFControl;
import com.cognos.indications.LogIPFLog;
import com.cognos.indications.LogTypedLogger;
import com.cognos.logserver.LogAbstractServer;
import com.cognos.logserver.LogServerConnection;
import com.cognos.logserver.LogServerMessage;
import com.cognos.logserver.Version;
import com.cognos.pogo.monitoring.RequestReporter;
import com.cognos.pogo.monitoring.ServiceStatus;
import com.cognos.pogo.pdk.Configuration;
import com.cognos.pogo.pdk.DefaultService;

public class LogService
extends DefaultService {
    private static final String SERVER_AUDIT_IPF_LOGGER = "server.Audit.IPF";
    private static final LogTypedLogger serverLogger = LogTypedLogger.getLogger((String)"server.Audit.IPF");
    protected static final String COMPONENT_SHORT_NAME = "LOGSV";
    protected int m_port;
    protected int m_workerThreads;
    protected boolean m_tcpServer;
    protected boolean m_secureMode;
    protected LogAbstractServer m_server;
    protected RequestReporter m_reporter;
    protected String m_serviceStatus = ServiceStatus.UNKNOWN;

    public void setReporter(RequestReporter reporter) {
        this.m_reporter = reporter;
        if (this.m_server != null) {
            this.m_server.setReporter(this.m_reporter);
        }
    }

    public void configure(Configuration configuration) {
        this.configure(configuration.getICCLConfiguration());
    }

    public void configure(ICCLConfiguration configuration) {
        try {
            LogIPFConfigure.serverInit((ICCLConfiguration)configuration);
        }
        catch (Exception e) {
            LogServerMessage.logError("StartService", LogIPFConfigure.getServerPort(), (short)4, e.getMessage());
        }
        this.m_port = LogIPFConfigure.getServerPort();
        this.m_workerThreads = LogIPFConfigure.getServerWorkerThreads();
        if (LogIPFConfigure.enableTCP()) {
            this.m_tcpServer = true;
            this.m_secureMode = LogIPFConfigure.enableSSL();
        }
        if (LogIPFConfigure.isDBAppenderDefined() && null != serverLogger) {
            String status = LogIPFConfigure.getDBInitializationStatus();
            StringBuffer buffer = new StringBuffer(160);
            buffer.append("<parameters><item name=\"DB URL\"><![CDATA[");
            buffer.append(LogIPFConfigure.getDBURL());
            buffer.append("]]></item>");
            LogAuditAccessIndication dbStatusIndication = new LogAuditAccessIndication(COMPONENT_SHORT_NAME, Version.getMajorBuild());
            dbStatusIndication.setLevel(50000);
            dbStatusIndication.setOperation("StartService");
            dbStatusIndication.setObjectType("LogService");
            dbStatusIndication.setObjectPath("");
            if (status.equalsIgnoreCase("Failed")) {
                dbStatusIndication.setErrorMessage(LogIPFControl.getErrMsg((short)6));
                buffer.append("<item name=\"DB Error\"><![CDATA[");
                buffer.append(LogIPFConfigure.getDBErrorMessage());
                buffer.append("]]></item></parameters>");
            } else {
                buffer.append("<item name=\"Audit Logging Tables\"><![CDATA[");
                buffer.append("COGIPF_ACTION, COGIPF_NATIVEQUERY, COGIPF_PARAMETER, COGIPF_RUNJOB, COGIPF_RUNJOBSTEP, COGIPF_RUNREPORT, COGIPF_USERLOGON, COGIPF_VIEWREPORT, COGIPF_SYSPROPS");
                buffer.append("]]></item></parameters>");
            }
            dbStatusIndication.setStatus(status);
            dbStatusIndication.setLogData(buffer.toString());
            serverLogger.log((Object)dbStatusIndication);
        }
    }

    public void initialize() {
        this.m_server = this.m_tcpServer ? new LogServerConnection(this.m_port, this.m_workerThreads) : new LogServerMessage(this.m_port, this.m_workerThreads);
        this.m_server.setDaemon(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        this.m_serviceStatus = "starting";
        if (null != this.m_reporter) {
            this.m_reporter.setServiceStatus(this.m_serviceStatus);
        }
        LogAbstractServer logAbstractServer = this.m_server;
        synchronized (logAbstractServer) {
            this.m_server.start();
            try {
                this.m_server.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this.m_serviceStatus = false == this.m_server.isServiceRunning() ? "failed" : "running";
        if (null != this.m_reporter) {
            this.m_reporter.setServiceStatus(this.m_serviceStatus);
        }
        if (null != serverLogger) {
            String errMsg;
            String status;
            if (this.m_server.isServiceRunning()) {
                status = "Success";
                errMsg = "";
            } else {
                status = "Failed";
                errMsg = "";
            }
            StringBuffer buffer = new StringBuffer(160);
            buffer.append("<parameters><item name=\"Port\"><![CDATA[");
            buffer.append(this.m_port);
            buffer.append("]]></item><item name=\"Mode\"><![CDATA[");
            buffer.append(this.m_server.getProtocol());
            buffer.append("]]></item><item name=\"Secure\"><![CDATA[");
            buffer.append(this.m_secureMode ? "TRUE" : "FALSE");
            buffer.append("]]></item></parameters>");
            LogAuditAccessIndication startIndication = new LogAuditAccessIndication(COMPONENT_SHORT_NAME, Version.getMajorBuild());
            startIndication.setLevel(50000);
            startIndication.setOperation("StartService");
            startIndication.setObjectType("LogService");
            startIndication.setObjectPath("");
            startIndication.setStatus(status);
            startIndication.setErrorMessage(errMsg);
            startIndication.setLogData(buffer.toString());
            serverLogger.log((Object)startIndication);
        }
    }

    public void suspend(boolean immediate) {
        this.m_serviceStatus = "stopping";
        if (null != this.m_reporter) {
            this.m_reporter.setServiceStatus(this.m_serviceStatus);
        }
        if (immediate || !immediate) {
            this.m_server.suspendQueue();
        }
        this.m_serviceStatus = "suspended";
        if (null != this.m_reporter) {
            this.m_reporter.setServiceStatus(this.m_serviceStatus);
        }
    }

    public void resume() {
        this.m_serviceStatus = "starting";
        if (null != this.m_reporter) {
            this.m_reporter.setServiceStatus(this.m_serviceStatus);
        }
        this.m_server.activateQueue();
        this.m_serviceStatus = "running";
        if (null != this.m_reporter) {
            this.m_reporter.setServiceStatus(this.m_serviceStatus);
        }
    }

    public void stop() {
        this.m_serviceStatus = "stopping";
        if (null != this.m_reporter) {
            this.m_reporter.setServiceStatus(this.m_serviceStatus);
        }
        this.m_server.shutdown();
        try {
            this.m_server.join();
        }
        catch (InterruptedException e) {
            LogIPFLog.debug((String)"LogServer main thread interrupted during join.");
        }
        this.m_serviceStatus = "suspended";
        if (null != this.m_reporter) {
            this.m_reporter.setServiceStatus(this.m_serviceStatus);
        }
        if (serverLogger != null) {
            StringBuffer buffer = new StringBuffer(160);
            buffer.append("<parameters><item name=\"Port\"><![CDATA[");
            buffer.append(this.m_port);
            buffer.append("]]></item><item name=\"Mode\"><![CDATA[");
            buffer.append(this.m_server.getProtocol());
            buffer.append("]]></item><item name=\"Secure\"><![CDATA[");
            buffer.append(this.m_secureMode ? "TRUE" : "FALSE");
            buffer.append("]]></item></parameters>");
            LogAuditAccessIndication stopIndication = new LogAuditAccessIndication(COMPONENT_SHORT_NAME, Version.getMajorBuild());
            stopIndication.setLevel(50000);
            stopIndication.setOperation("StopService");
            stopIndication.setLogData(buffer.toString());
            stopIndication.setObjectPath("");
            stopIndication.setObjectType("LogService");
            stopIndication.setStatus("Success");
            stopIndication.setErrorMessage("");
            serverLogger.log((Object)stopIndication);
        }
        this.m_server = null;
        try {
            Thread.sleep(1000L);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void dispose() {
    }

    public void log(byte[] indication) {
        this.m_server.enqueue(indication);
    }

    String getServiceStatus() {
        return this.m_serviceStatus;
    }
}

