/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.logserver;

import com.cognos.indications.LogIPFLog;
import com.cognos.logserver.LogService;
import com.cognos.pogo.monitoring.RequestReporter;
import com.cognos.pogo.monitoring.SimpleRequestReportingHandler;
import com.cognos.pogo.pdk.BasicHandler;
import com.cognos.pogo.pdk.Configuration;
import com.cognos.pogo.pdk.Handler;
import com.cognos.pogo.pdk.MessageContext;
import com.cognos.pogo.pdk.PogoEngine;
import com.cognos.pogo.pdk.PogoException;
import org.apache.log.Hierarchy;
import org.apache.log.Logger;

public class LogServiceHandler
extends BasicHandler {
    private static final Logger cat = Hierarchy.getDefaultHierarchy().getLoggerFor(LogService.class.getName());
    protected LogService m_service = null;
    protected PogoEngine m_engine = null;
    protected RequestReporter m_reporter = null;

    public LogServiceHandler() {
        super(cat);
    }

    public void configure(Configuration configuration) {
    }

    public void reconfigure(Configuration configuration) {
        if (this.m_reporter != null) {
            return;
        }
        try {
            Handler h = this.m_engine.getHandlerPool().find("logServiceReporter.logServiceReporter");
            if (h != null && h instanceof SimpleRequestReportingHandler) {
                SimpleRequestReportingHandler srrh = (SimpleRequestReportingHandler)h;
                this.m_reporter = srrh.getRequestReporter();
                this.m_service.setReporter(this.m_reporter);
                this.m_reporter.setServiceStatus(this.m_service.getServiceStatus());
            }
        }
        catch (Exception x) {
            LogIPFLog.error((String)"LogServiceHandler.reconfigure caught exception: ", (Throwable)x);
        }
    }

    public void initialize() {
    }

    public void start() {
    }

    public void suspend(boolean immediate) {
        this.m_service.suspend(immediate);
    }

    public void resume() {
        this.m_service.resume();
    }

    public void stop() {
        this.m_service.stop();
    }

    public void dispose() {
        this.m_service.dispose();
    }

    public void log(byte[] indication) {
        this.m_service.log(indication);
    }

    public void compose_impl(PogoEngine engine) throws PogoException {
        this.m_engine = engine;
        this.m_service = (LogService)((Object)this.m_engine.getContextAttribute("com.cognos.logserver.LogService"));
    }

    public void invokeImpl(MessageContext mc) throws PogoException {
    }
}

