/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.logserver;

import com.cognos.indications.LogIPFConfigure;
import com.cognos.indications.LogIPFLog;
import com.cognos.indications.LogIndication;
import com.cognos.logserver.LogServerIndicationQueue;
import com.cognos.logserver.LogServerMessage;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.InterruptedIOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.Socket;

class LogTCPSocket
extends Thread {
    private final Socket m_socket;
    private ObjectInputStream m_ois;
    private boolean m_active;
    private LogServerIndicationQueue m_queue;

    LogTCPSocket(Socket socket, LogServerIndicationQueue queue) {
        this.m_socket = socket;
        this.m_queue = queue;
        try {
            this.m_socket.setSoLinger(true, 65000);
            this.m_active = true;
        }
        catch (Exception e) {
            LogServerMessage.logError("StartService", LogIPFConfigure.getServerPort(), (short)2, e.getMessage());
            this.m_active = false;
        }
    }

    @Override
    public void run() {
        try (ObjectInputStream ois = new ObjectInputStream(new BufferedInputStream(this.m_socket.getInputStream()));){
            this.m_ois = ois;
            this.readIndications();
        }
        catch (Exception e) {
            LogServerMessage.logError("StartService", LogIPFConfigure.getServerPort(), (short)2, e.getMessage());
        }
    }

    private void readIndications() {
        while (this.m_active) {
            try {
                String name = this.m_ois.readUTF();
                LogIndication ind = (LogIndication)this.m_ois.readObject();
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                bos.reset();
                ObjectOutputStream oos = new ObjectOutputStream(bos);
                oos.writeUTF(name);
                oos.writeObject(ind);
                oos.close();
                byte[] indication = bos.toByteArray();
                this.m_queue.enqueue(indication);
            }
            catch (InterruptedIOException e) {
                this.m_active = false;
            }
            catch (EOFException e) {
                LogIPFLog.debug((String)"EOFException caught in TCPSocket handler.", (Throwable)e);
                this.m_active = false;
            }
            catch (Exception e) {
                if (this.m_active) {
                    LogServerMessage.logError("StopService", LogIPFConfigure.getServerPort(), (short)2, e.getMessage());
                }
                this.m_active = false;
            }
        }
    }

    synchronized void halt() {
        this.m_active = false;
        try {
            this.m_ois.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

