/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.logserver;

import com.cognos.indications.LogIndication;
import com.cognos.indications.convert.LogConvertUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.slf4j.spi.MDCAdapter;

class ServerIndicationLogger {
    private Logger theLogger = null;
    public static final String MDC_LOGLEVEL = "logLevel";
    public static final String MDC_LOGGERNAME = "loggerName";
    public static final String MDC_THREADID = "threadId";
    public static final String MDC_ROOTID = "rootId";
    public static final String MDC_PARENTID = "parentId";
    public static final String MDC_CURRENTID = "currentId";
    public static final String MDC_CAM_PASSPORT = "sessionId";
    public static final String MDC_CLIENTADDRESS = "clientAddress";
    public static final String MDC_CLIENTPORT = "clientPort";
    public static final String MDC_SERVICENAME = "serviceName";
    public static final String MDC_REQUESTNAME = "requestName";
    public static final String MDC_LOGSESSION = "logSESSION";
    public static final String MDC_LOGSESSIONID = "logSESSIONID";
    public static final String MDC_PROCESSID = "processId";
    public static final String MDC_LOGMESSAGE = "logMessage";
    public static final String MDC_DELIMITER = "_";
    public static final String SESSIONID_START_DELIMITER = "_{_";
    public static final String SESSIONID_END_DELIMITER = "_}_";
    public static final int SESSIONID_START_DELIMITER_LENGTH = "_{_".length();

    public ServerIndicationLogger(String name, Class<?> base) {
        this.theLogger = LoggerFactory.getLogger((String)name);
    }

    public ServerIndicationLogger(String name) {
        this.theLogger = LoggerFactory.getLogger((String)name);
    }

    public void trace(Object message) {
        MDCAdapter mdc = MDC.getMDCAdapter();
        ServerIndicationLogger.setupContext(mdc, message);
        this.theLogger.trace(LogConvertUtils.extractMessage((Object)message));
        ServerIndicationLogger.clearContext(mdc);
    }

    public void trace(Object message, Throwable t) {
        MDCAdapter mdc = MDC.getMDCAdapter();
        ServerIndicationLogger.setupContext(mdc, message);
        this.theLogger.trace(LogConvertUtils.extractMessage((Object)message), t);
        ServerIndicationLogger.clearContext(mdc);
    }

    public void debug(Object message) {
        MDCAdapter mdc = MDC.getMDCAdapter();
        ServerIndicationLogger.setupContext(mdc, message);
        this.theLogger.debug(LogConvertUtils.extractMessage((Object)message));
        ServerIndicationLogger.clearContext(mdc);
    }

    public void debug(Object message, Throwable t) {
        MDCAdapter mdc = MDC.getMDCAdapter();
        ServerIndicationLogger.setupContext(mdc, message);
        this.theLogger.debug(LogConvertUtils.extractMessage((Object)message), t);
        ServerIndicationLogger.clearContext(mdc);
    }

    public void error(Object message) {
        MDCAdapter mdc = MDC.getMDCAdapter();
        ServerIndicationLogger.setupContext(mdc, message);
        this.theLogger.error(LogConvertUtils.extractMessage((Object)message));
        ServerIndicationLogger.clearContext(mdc);
    }

    public void error(Object message, Throwable t) {
        MDCAdapter mdc = MDC.getMDCAdapter();
        ServerIndicationLogger.setupContext(mdc, message);
        this.theLogger.error(LogConvertUtils.extractMessage((Object)message), t);
        ServerIndicationLogger.clearContext(mdc);
    }

    public void info(Object message) {
        MDCAdapter mdc = MDC.getMDCAdapter();
        ServerIndicationLogger.setupContext(mdc, message);
        this.theLogger.info(LogConvertUtils.extractMessage((Object)message));
        ServerIndicationLogger.clearContext(mdc);
    }

    public void info(Object message, Throwable t) {
        MDCAdapter mdc = MDC.getMDCAdapter();
        ServerIndicationLogger.setupContext(mdc, message);
        this.theLogger.info(LogConvertUtils.extractMessage((Object)message), t);
        ServerIndicationLogger.clearContext(mdc);
    }

    public void warn(Object message) {
        MDCAdapter mdc = MDC.getMDCAdapter();
        ServerIndicationLogger.setupContext(mdc, message);
        this.theLogger.warn(LogConvertUtils.extractMessage((Object)message));
        ServerIndicationLogger.clearContext(mdc);
    }

    public void warn(Object message, Throwable t) {
        MDCAdapter mdc = MDC.getMDCAdapter();
        ServerIndicationLogger.setupContext(mdc, message);
        this.theLogger.warn(LogConvertUtils.extractMessage((Object)message), t);
        ServerIndicationLogger.clearContext(mdc);
    }

    public void fatal(Throwable t) {
        MDCAdapter mdc = MDC.getMDCAdapter();
        ServerIndicationLogger.setupContext(mdc, t);
        this.theLogger.error("", t);
        ServerIndicationLogger.clearContext(mdc);
    }

    public void fatalAsInfo(Object message) {
        MDCAdapter mdc = MDC.getMDCAdapter();
        ServerIndicationLogger.setupContext(mdc, message);
        this.theLogger.info(LogConvertUtils.extractMessage((Object)message));
        ServerIndicationLogger.clearContext(mdc);
    }

    public void log(int level, Object message) {
        switch (level) {
            case 10000: {
                this.debug(message);
                break;
            }
            case 20000: {
                this.info(message);
                break;
            }
            case 30000: {
                this.warn(message);
                break;
            }
            case 50000: {
                this.fatalAsInfo(message);
                break;
            }
            case 40000: {
                this.error(message);
            }
        }
    }

    public void log(int level, Object message, Throwable t) {
        switch (level) {
            case 10000: {
                this.debug(message, t);
                break;
            }
            case 20000: {
                this.info(message, t);
                break;
            }
            case 30000: {
                this.warn(message, t);
                break;
            }
            case 40000: 
            case 50000: {
                this.error(message, t);
            }
        }
    }

    public static String convertLevel(LogIndication ind) {
        String strLevel;
        int level = ind.getLevel();
        switch (level) {
            case 40000: 
            case 50000: {
                strLevel = "ERROR";
                break;
            }
            case 30000: {
                strLevel = "WARN";
                break;
            }
            case 20000: {
                strLevel = "INFO";
                break;
            }
            case 10000: {
                strLevel = "DEBUG";
                break;
            }
            default: {
                strLevel = "DEBUG";
            }
        }
        return strLevel;
    }

    public static void setupContext(MDCAdapter mdc, Object message) {
        LogIndication ind = (LogIndication)message;
        mdc.put(MDC_LOGLEVEL, ServerIndicationLogger.convertLevel(ind));
        String loggername = ind.getLoggerName();
        if (loggername.startsWith("session.") || loggername.startsWith("startup.")) {
            mdc.put(MDC_LOGGERNAME, loggername.substring(8, loggername.length()));
        } else {
            mdc.put(MDC_LOGGERNAME, loggername);
        }
        mdc.put(MDC_THREADID, ind.getThreadID());
        String sessionid = ind.getSessionID();
        if (sessionid != null) {
            if (sessionid.startsWith("f:1:")) {
                int start = sessionid.indexOf(SESSIONID_START_DELIMITER);
                if (start == -1) {
                    mdc.put(MDC_CAM_PASSPORT, sessionid.substring(4));
                } else {
                    mdc.put(MDC_CAM_PASSPORT, sessionid.substring(4, start - 1));
                    int end = sessionid.indexOf(SESSIONID_END_DELIMITER);
                    if (end > start + SESSIONID_START_DELIMITER_LENGTH) {
                        mdc.put(MDC_LOGSESSIONID, sessionid.substring(start + SESSIONID_START_DELIMITER_LENGTH, end));
                        mdc.put(MDC_LOGSESSION, "enabled");
                    }
                }
            } else if (sessionid.startsWith("f:0:")) {
                mdc.put(MDC_CAM_PASSPORT, sessionid.substring(4));
            } else {
                mdc.put(MDC_CAM_PASSPORT, sessionid);
            }
        } else {
            mdc.put(MDC_CAM_PASSPORT, "NA");
        }
        mdc.put(MDC_CLIENTADDRESS, ind.getIPAddrStr());
        mdc.put(MDC_CLIENTPORT, Integer.toString(ind.getPort()));
        mdc.put(MDC_SERVICENAME, ind.getComponentID());
        mdc.put(MDC_REQUESTNAME, ServerIndicationLogger.makeRequestName(MDC_DELIMITER, message));
        mdc.put(MDC_ROOTID, ind.getRequestID());
        mdc.put(MDC_PARENTID, "");
        mdc.put(MDC_CURRENTID, ind.getSubRequestID());
        mdc.put(MDC_PROCESSID, Integer.toString(ind.getProcID()));
        mdc.put(MDC_LOGMESSAGE, LogConvertUtils.extractMessage((Object)message));
    }

    public static void clearContext(MDCAdapter mdc) {
        mdc.clear();
    }

    public static String makeRequestName(String delim, Object message) {
        LogIndication ind = (LogIndication)message;
        return ind.getRequestID() + delim + ind.getSubRequestID() + delim + ind.getStepID();
    }
}

