/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.logserver.test;

import com.cognos.cclcfgapi.CCLConfigurationException;
import com.cognos.cclcfgapi.CCLConfigurationFactory;
import com.cognos.cclcfgapi.ICCLConfiguration;
import com.cognos.indications.LogIPFConfigure;
import com.cognos.logserver.LogService;
import java.io.IOException;

public class LogServiceTester
extends LogIPFConfigure {
    public static void showHelp() {
        System.out.println("Commands:");
        System.out.println("help\tDisplays this screen.\n");
        System.out.println("suspend\tThe Log Server stops accepting indications but will finish processing");
        System.out.println("\t\tthe queued indications.\n");
        System.out.println("resume\tThe Log Server will start accepting indications again.\n");
        System.out.println("stop\tThe Log Server stops accepting indications and once it finishes");
        System.out.println("\t\tprocessing the queued indications, it shuts down.\n");
    }

    public static void main(String[] args) {
        System.out.println("Cognos ReportNet Log Server Tester\n");
        if (0 == args.length) {
            // empty if block
        }
        LogService service = new LogService();
        ICCLConfiguration config = CCLConfigurationFactory.getInstance();
        try {
            config.init();
        }
        catch (CCLConfigurationException ccle) {
            System.err.println("ERROR: Problem encountered when initializing the configuration.");
            System.err.println(ccle.getMessage());
            ccle.printStackTrace(System.err);
        }
        LogIPFConfigure.useEncryption = false;
        service.configure(config);
        service.initialize();
        service.start();
        System.out.println("Log Service started.");
        System.out.print("> ");
        boolean suspended = false;
        byte[] command = new byte[16];
        while (true) {
            try {
                System.in.read(command);
                String commandString = new String(command).toLowerCase();
                if (commandString.startsWith("st")) {
                    System.out.println();
                    break;
                }
                if (commandString.startsWith("su")) {
                    if (!suspended) {
                        service.suspend(true);
                        System.out.println("Log Service suspended.\n");
                        suspended = true;
                    }
                } else if (commandString.startsWith("r")) {
                    if (suspended) {
                        service.resume();
                        System.out.println("Log Service resumed.\n");
                        suspended = false;
                    }
                } else if (commandString.startsWith("h")) {
                    LogServiceTester.showHelp();
                }
            }
            catch (IOException ioe) {
                System.err.println("ERROR: Problem encountered while reading command.  Log Service Tester is terminating.");
                System.err.println(ioe.getMessage());
                ioe.printStackTrace(System.err);
                System.exit(1);
            }
            System.out.print("> ");
        }
        service.stop();
        System.out.println("Log Service stopped.");
        System.exit(0);
    }
}

