/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.metadataService.bibusHandler;

import com.cognos.developer.schemas.bibus._3.AsynchReplyStatusEnum;
import com.cognos.metadataService.bibusHandler.soaphelpers.AsyncResponseHelper;
import com.cognos.metadataService.bibusHandler.soaphelpers.RequestOptions;
import com.cognos.metadataService.command.Command;
import com.cognos.metadataService.command.CommandFactory;
import com.cognos.metadataService.command.CommandFixtures;
import com.cognos.metadataService.command.CommandKey;
import com.cognos.metadataService.command.lineage.adapters.request.DataTypeAquisition;
import com.cognos.metadataService.util.errors.MDSRVErrorCode;
import com.cognos.metadataService.util.errors.MDSRVErrorType;
import com.cognos.metadataService.util.errors.MDSRVException;
import com.cognos.metadataService.util.errors.QFFault;
import com.cognos.metadataService.util.logging.MDSRVLogUtil;
import com.cognos.metadataService.util.logging.ServicePerfMarker;
import com.cognos.mfw4j.utilities.QFException;
import com.cognos.pogo.async.AsyncContext;
import com.cognos.pogo.async.AsyncServiceBase;
import com.cognos.pogo.async.AsyncState;
import com.cognos.pogo.async.service.AsyncBIBusXMLHelper;
import com.cognos.pogo.http.mime.MIMEPartParser;
import com.cognos.pogo.http.mime.MimeParseInputStream;
import com.cognos.pogo.impl.MessageContextImpl;
import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.pogo.pdk.Fault;
import com.cognos.pogo.pdk.MessageContext;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.dom4j.Element;

public class MDSRVAsyncService
extends AsyncServiceBase {
    private int m_secondaryThreshold = 1;
    private boolean m_alwaysIncludePrimaryRequest = false;
    HashMap<CommandFixtures, Object> m_serviceParams;
    CommandFactory m_commandFactory;
    Command m_command = null;
    String m_cleanListName;
    BIBusEnvelope m_commandResponseEnv = null;
    public MDSRVLogUtil m_logUtil = MDSRVLogUtil.getLogUtilInstance();

    MDSRVAsyncService(CommandFactory commandFactory, HashMap<CommandFixtures, Object> serviceParams, int threshold, String cleanListName) {
        this.m_commandFactory = commandFactory;
        this.m_serviceParams = serviceParams;
        this.m_cleanListName = cleanListName;
        if (this.m_logUtil.isTraceInformativeEnabled()) {
            this.m_logUtil.traceInformative("MDSRVAsyncService.constructor, threshold: " + threshold);
        }
        this.setAsyncThreshold(threshold);
    }

    public void invoke(AsyncContext ac) {
        ServicePerfMarker sp = new ServicePerfMarker(((Object)((Object)this)).getClass().getName() + ".invoke", "BEGIN");
        MessageContext mc = ac.getMessageContext();
        BIBusEnvelope requestEnvelope = (BIBusEnvelope)mc.getProperty("request.envelope");
        this.m_logUtil.startMDSRVRequest(requestEnvelope);
        MDSRVAsyncService.validateRequestConversationContext(mc, requestEnvelope);
        try {
            CommandKey commandKey = new CommandKey(mc);
            this.m_command = this.m_commandFactory.getCommand(commandKey.getCommandElem(), this.m_serviceParams);
            if (this.m_command == null) {
                throw new MDSRVException(MDSRVErrorType.CLIENT, MDSRVErrorCode.MSR_MSR_CommandNotFound);
            }
            AsyncBIBusXMLHelper asyncBIBusXMLHelper = new AsyncBIBusXMLHelper();
            asyncBIBusXMLHelper.cachePrimaryRequestInfo(requestEnvelope, this.m_alwaysIncludePrimaryRequest);
            mc.setProperty("xmlhelper", (Object)asyncBIBusXMLHelper);
            this.m_command.invokeRequest(mc);
            this.m_commandResponseEnv = (BIBusEnvelope)mc.getProperty("response.envelope");
        }
        catch (QFException qfException) {
            String errorMsg;
            boolean processed = false;
            CommandKey commandKey = new CommandKey(mc);
            Element requestElem = commandKey.getCommandElem();
            if ("lineageRequest".equals(requestElem.getName()) && (errorMsg = qfException.getDOM().asXML()).indexOf("<faultcode>CQE-804") != -1) {
                String passport = commandKey.getRequest().getPassportID();
                String searchPath = null;
                Iterator requestChildElemIter = commandKey.getCommandElem().elementIterator();
                while (requestChildElemIter.hasNext()) {
                    Iterator it;
                    List cnt;
                    Element requestChildElem = (Element)requestChildElemIter.next();
                    String elemName = requestChildElem.getName();
                    if (!elemName.equals("connection") || (cnt = requestChildElem.content()) == null || !(it = cnt.iterator()).hasNext()) continue;
                    Element param = (Element)it.next();
                    searchPath = param.getText();
                    break;
                }
                if (!searchPath.isEmpty()) {
                    DataTypeAquisition dta = new DataTypeAquisition(searchPath, passport);
                    dta.testQueryModelDataSources();
                    if (dta.hasMixedDatasources()) {
                        MDSRVException mdsrvExc = new MDSRVException(MDSRVErrorType.CLIENT, MDSRVErrorCode.MSR_LIN_NoROLAPLineage, "objectQuery");
                        this.m_logUtil.runtimeError(mdsrvExc, requestEnvelope);
                        this.m_command.release();
                        Fault fault = mdsrvExc.getFault();
                        mc.setFault(fault);
                        processed = true;
                    }
                }
            }
            if (!processed) {
                this.m_logUtil.promptException(qfException, requestEnvelope);
                this.m_command.release();
                mc.setFault((Fault)new QFFault(qfException));
            }
        }
        catch (MDSRVException mdsrvExc) {
            this.m_logUtil.runtimeError(mdsrvExc, requestEnvelope);
            this.m_command.release();
            Fault fault = mdsrvExc.getFault();
            mc.setFault(fault);
        }
        catch (Exception ex) {
            this.m_logUtil.runtimeError(ex, requestEnvelope);
            this.m_command.release();
            Fault fault = new Fault(MDSRVException.determineMessageCode(ex), ex);
            mc.setFault(fault);
        }
        catch (Throwable th) {
            this.m_logUtil.runtimeError(th, requestEnvelope);
            this.m_command.release();
            Fault fault = new Fault(MDSRVException.determineMessageCode(th));
            mc.setFault(fault);
        }
        this.m_command.release();
        sp.endPerf();
        this.m_logUtil.endMDSRVRequest(this.m_commandResponseEnv);
    }

    public void waitReceived(MessageContext mc, AsyncContext ac) {
        if (this.m_logUtil.isMethodTraceEnabled()) {
            this.m_logUtil.methodStart("MDSRVAsyncService.waitReceived ");
        }
        this.m_alwaysIncludePrimaryRequest = MDSRVAsyncService.getAlwaysIncludePrimaryRequestOption(this.m_alwaysIncludePrimaryRequest, mc);
        RequestOptions requestOptions = new RequestOptions(mc);
        int tempST = requestOptions.getIntValue("secondaryWaitThreshold");
        if (tempST >= 0 && this.m_logUtil.isTraceInformativeEnabled()) {
            this.m_logUtil.traceInformative("MDSRVAsyncService.waitReceived  request contained secondary threshold = " + tempST);
        }
        if (this.m_logUtil.isMethodTraceEnabled()) {
            this.m_logUtil.methodEnd("MDSRVAsyncService.waitReceived  setting async threshold to secondaryThreshold = " + this.m_secondaryThreshold);
        }
        this.setAsyncThreshold(this.m_secondaryThreshold);
    }

    public void workingImpl(MessageContext mc, AsyncContext ac) {
        if (this.m_logUtil.isMethodTraceEnabled()) {
            this.m_logUtil.methodStart("MDSRVAsyncService.workingImpl ");
        }
        AsyncResponseHelper asyncResponseHelper = new AsyncResponseHelper();
        asyncResponseHelper.writeResponse(mc, AsynchReplyStatusEnum.working, null, null);
        if (this.m_logUtil.isMethodTraceEnabled()) {
            this.m_logUtil.methodEnd("MDSRVAsyncService.workingImpl ");
        }
    }

    public void stillWorkingImpl(MessageContext mc, AsyncContext ac) {
        if (this.m_logUtil.isMethodTraceEnabled()) {
            this.m_logUtil.methodStart("MDSRVAsyncService.stillWorkingImpl ");
        }
        AsyncResponseHelper asyncResponseHelper = new AsyncResponseHelper();
        asyncResponseHelper.writeResponse(mc, AsynchReplyStatusEnum.stillWorking, null, null);
        if (this.m_logUtil.isMethodTraceEnabled()) {
            this.m_logUtil.methodEnd("MDSRVAsyncService.stillWorkingImpl ");
        }
    }

    protected void cancelImpl(MessageContext mc, AsyncContext ac) {
        if (this.m_logUtil.isMethodTraceEnabled()) {
            this.m_logUtil.methodStart("MDSRVAsyncService.cancelImpl ");
        }
        if (this.m_command != null) {
            this.m_command.cancelRequest(mc, ac);
        }
        if (this.m_logUtil.isMethodTraceEnabled()) {
            this.m_logUtil.methodEnd("MDSRVAsyncService.cancelImpl ");
        }
    }

    public void abandonImpl(AsyncContext ac) {
        if (this.m_logUtil.isMethodTraceEnabled()) {
            this.m_logUtil.methodStart("MDSRVAsyncService.abandonImpl ");
        }
        if (this.m_command != null) {
            this.m_command.abandonRequest(ac.getMessageContext(), ac);
        }
        if (this.m_logUtil.isMethodTraceEnabled()) {
            this.m_logUtil.methodEnd("MDSRVAsyncService.abandonImpl ");
        }
    }

    public void releaseImpl(MessageContext mc) {
        if (this.m_logUtil.isMethodTraceEnabled()) {
            this.m_logUtil.methodStart("MDSRVAsyncService.releaseImpl ");
        }
        this.m_command.releaseRequest(mc);
    }

    public void responseReadyImpl(MessageContext mc, AsyncContext ac) {
        if (this.m_logUtil.isMethodTraceEnabled()) {
            this.m_logUtil.methodStart("MDSRVAsyncService.responseReadyImpl ");
        }
        this.replyNow(mc, ac);
        if (this.m_logUtil.isMethodTraceEnabled()) {
            this.m_logUtil.methodEnd("MDSRVAsyncService.responseReadyImpl ");
        }
    }

    public void getOutputImpl(MessageContext mcGetOutput, AsyncContext ac) {
        if (this.m_logUtil.isMethodTraceEnabled()) {
            this.m_logUtil.methodStart("MDSRVAsyncService.getOutputImpl ");
        }
        BIBusEnvelope respEnv = (BIBusEnvelope)ac.getMessageContext().getProperty("response.envelope");
        Element eMyMethodResponse = respEnv.getBody().element("myMethodResponse");
        eMyMethodResponse.detach();
        respEnv.setConversationContextStatus(AsynchReplyStatusEnum.complete.getValue());
        if (this.m_logUtil.isMethodTraceEnabled()) {
            this.m_logUtil.methodEnd("MDSRVAsyncService.getOutputImpl ");
        }
    }

    private ArrayList<InputStream> getAttachments(MessageContext mc) {
        MIMEPartParser itOldList = (MIMEPartParser)mc.getProperty("response.attachments");
        ArrayList<InputStream> newList = new ArrayList<InputStream>();
        MimeParseInputStream stream = null;
        while (itOldList != null && itOldList.hasNext()) {
            stream = (MimeParseInputStream)itOldList.next();
            newList.add(MDSRVAsyncService.copyInputStream((InputStream)stream));
        }
        return newList;
    }

    public static InputStream copyInputStream(InputStream in) {
        try {
            BufferedInputStream buffIS = new BufferedInputStream(in);
            ByteArrayOutputStream byteOS = new ByteArrayOutputStream();
            int result = buffIS.read();
            while (result != -1) {
                byte b = (byte)result;
                byteOS.write(b);
                result = buffIS.read();
            }
            byteOS.flush();
            ByteArrayInputStream byteIS = new ByteArrayInputStream(byteOS.toByteArray());
            return byteIS;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public void replyNow(MessageContext mc, AsyncContext ac) {
        if (this.m_logUtil.isMethodTraceEnabled()) {
            this.m_logUtil.methodStart("MDSRVAsyncService.replyNow ");
        }
        ((MessageContextImpl)mc).collectResponse((MessageContextImpl)ac.getMessageContext());
        mc.setProperty("response.envelope", ((MessageContextImpl)ac.getMessageContext()).getProperty("response.envelope"));
        BIBusEnvelope reqEnv = (BIBusEnvelope)mc.getProperty("request.envelope");
        reqEnv.setConversationContextStatus(AsynchReplyStatusEnum.complete.toString());
        ArrayList<InputStream> attachmentList = this.getAttachments(mc);
        AsyncResponseHelper responseHelper = new AsyncResponseHelper();
        responseHelper.writeResponse(mc, AsynchReplyStatusEnum.complete, null, null);
        if (this.m_commandResponseEnv != null && ac.getState().equals(AsyncState.OUTPUTREADY)) {
            responseHelper.writeResponse(mc, AsynchReplyStatusEnum.complete, this.m_commandResponseEnv, attachmentList);
        }
        if (this.m_logUtil.isMethodTraceEnabled()) {
            this.m_logUtil.traceInformative(mc.toString());
            this.m_logUtil.methodEnd("MDSRVAsyncService.replyNow ");
        }
    }

    public static boolean getAlwaysIncludePrimaryRequestOption(boolean defaultValue, MessageContext mc) {
        boolean boolOptionValue = defaultValue;
        RequestOptions requestOptions = new RequestOptions(mc);
        String optionValue = requestOptions.getStringValue("alwaysIncludePrimaryRequest");
        if (optionValue != null) {
            try {
                boolOptionValue = Boolean.valueOf(optionValue);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return boolOptionValue;
    }

    static void validateRequestConversationContext(MessageContext mc, BIBusEnvelope request) {
        String action = (String)mc.getProperty("request.soapaction");
        if (request.getConversationContextProcessID() == -1 && (action.endsWith(".control") || action.endsWith(".absolute"))) {
            throw new MDSRVException(MDSRVErrorType.CLIENT, MDSRVErrorCode.MSR_API_MissingParameter, "conversationContextProcessID");
        }
    }

    public void setAlwaysIncludePrimaryRequest(boolean alwaysIncludePrimaryRequest) {
        this.m_alwaysIncludePrimaryRequest = alwaysIncludePrimaryRequest;
    }

    public void closeContext() {
        super.closeContext();
    }
}

