/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.metadataService.bibusHandler;

import com.cognos.metadataService.bibusHandler.MDSRVAsyncService;
import com.cognos.metadataService.bibusHandler.mdprovider.MDProviderComponentFactory;
import com.cognos.metadataService.bibusHandler.mdprovider.MDProviderProcessManager;
import com.cognos.metadataService.bibusHandler.mdprovider.MDProviderProgressRequests;
import com.cognos.metadataService.bibusHandler.mdprovider.MDProviderRequestInvoker;
import com.cognos.metadataService.bibusHandler.soaphelpers.RequestOptions;
import com.cognos.metadataService.command.Command;
import com.cognos.metadataService.command.CommandFactory;
import com.cognos.metadataService.command.CommandFixtures;
import com.cognos.metadataService.command.CommandKey;
import com.cognos.metadataService.util.errors.MDSRVErrorCode;
import com.cognos.metadataService.util.errors.MDSRVErrorType;
import com.cognos.metadataService.util.errors.MDSRVException;
import com.cognos.metadataService.util.logging.MDSRVLogUtil;
import com.cognos.metadataService.util.logging.ServicePerfMarker;
import com.cognos.p2pd.util.PropertyInserter;
import com.cognos.pogo.async.AsyncService;
import com.cognos.pogo.async.Asyncable;
import com.cognos.pogo.impl.DispatcherStrings;
import com.cognos.pogo.monitoring.QueueableRequestReportingHandler;
import com.cognos.pogo.monitoring.RequestReporter;
import com.cognos.pogo.monitoring.jmx.report.InteractiveReportExecutingRequests;
import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.pogo.pdk.BasicHandler;
import com.cognos.pogo.pdk.Cleanable;
import com.cognos.pogo.pdk.Configuration;
import com.cognos.pogo.pdk.Fault;
import com.cognos.pogo.pdk.MessageContext;
import com.cognos.pogo.pdk.PogoEngine;
import com.cognos.pogo.pdk.PogoException;
import com.cognos.pogo.reportservice.IRSHandler;
import com.cognos.pogo.reportservice.ProcessManager;
import com.cognos.pogo.reportservice.ReportServerInProgressRequests;
import com.cognos.pogo.reportservice.ReportServerQueue;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log.Hierarchy;
import org.apache.log.Logger;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.QName;

public class MDSRVHandler
extends BasicHandler
implements IRSHandler,
Asyncable {
    private static final String MDSRVHANDLER_INITIALIZE = "MDSRVHandler.initialize: ";
    static final QName BUS_conversation = DocumentHelper.createQName((String)"conversation", (Namespace)BIBusEnvelope.NS_BUS);
    private static final String INTERACTIVE_PROCESS_USE_LIMIT = "DISP.InteractiveProcessUseLimit";
    protected static final int DEFAULT_NOTIFICATION_INTERVAL = 60000;
    private Logger m_logger4Disp = Hierarchy.getDefaultHierarchy().getLoggerFor(MDSRVHandler.class.getName());
    private MDSRVLogUtil m_logger = MDSRVLogUtil.getLogUtilInstance();
    protected int m_notificationTimeInterval = 60000;
    private boolean m_usessl;
    private long m_requestExpirationTime = 30000L;
    private CommandFactory m_commandFactory;
    private MDProviderComponentFactory m_componentFactory = null;
    public Configuration m_configuration;
    protected MDProviderProcessManager m_processManager = null;
    ReportServerQueue m_mdsrvQueue;
    MDProviderProgressRequests m_inProgressRequests;
    private InteractiveReportExecutingRequests m_executingRequests;
    private MDProviderRequestInvoker m_requestInvoker = null;
    private QueueableRequestReportingHandler m_queueableReportingHandler;
    public String m_cleanListName;
    private String m_errorMessageCodePrefix = "MDSRVHandler.";
    private HashMap<CommandFixtures, Object> m_commandServiceParams = new HashMap();

    public MDSRVHandler() {
        this(Hierarchy.getDefaultHierarchy().getLoggerFor(MDSRVHandler.class.getName()));
    }

    public MDSRVHandler(Logger aLogger) {
        super(Hierarchy.getDefaultHierarchy().getLoggerFor(MDSRVHandler.class.getName()));
        this.m_commandFactory = new CommandFactory();
    }

    public void initialize() {
        this.m_logger.methodStart(MDSRVHANDLER_INITIALIZE);
        if (this.m_processManager != null) {
            this.m_processManager.setRequestReporter(this.m_queueableReportingHandler.getQueueableRequestReporter());
        }
    }

    public void compose_impl(PogoEngine engine) throws PogoException {
        String thisMethod = "MDSRVHandler.compose_impl ";
        try {
            this.m_logger.logEnv();
            this.m_requestInvoker.setCnRequestInfo(this.getRequiredAttribute(this.m_logger4Disp, "cnRequestInfo"));
            this.m_mdsrvQueue = this.m_componentFactory.newReportServerQueue();
            this.m_inProgressRequests = (MDProviderProgressRequests)this.m_componentFactory.newReportServerInProgressRequests();
            this.m_cleanListName = this.getRequiredAttribute(this.m_logger4Disp, "cn_cleanup_list");
            this.m_usessl = PropertyInserter.getProperty((String)"internalDispatcher.protocol").equalsIgnoreCase("https");
            if ("true".equals(this.getRequiredAttribute(this.m_logger4Disp, "preventSSL"))) {
                this.m_usessl = false;
            }
            String OS = System.getProperty("os.name").toLowerCase();
            String arch = System.getProperty("os.arch").toLowerCase();
            if (OS.equals("linux") && arch.equals("ppc64le")) {
                return;
            }
            Element targetElement = this.getConfig().element("target");
            List childProcCmdList = targetElement.elements("child-proc-cmd");
            List elements = targetElement.elements("init-param");
            Map<String, String> initParamsMap = MDSRVHandler.getInitParams(elements);
            String[] args = this.getProcessArguments(childProcCmdList, initParamsMap);
            int reportServerPort = Integer.parseInt(initParamsMap.get("report_server_port"));
            String reportServerHost = "localhost";
            if (reportServerPort > 0) {
                reportServerHost = initParamsMap.get("report_server_host");
            }
            String procManThreadName = this.getName() + "-MDSRVProcessManager";
            this.m_processManager = (MDProviderProcessManager)this.m_componentFactory.newProcessManager(procManThreadName, this.m_mdsrvQueue, args, targetElement, reportServerHost, reportServerPort, this.m_usessl);
            String runTimeInfoReporter = this.getRequiredAttribute(this.m_logger4Disp, "runTimeInfoReporter");
            this.m_queueableReportingHandler = (QueueableRequestReportingHandler)engine.lookupHandler(runTimeInfoReporter);
            if (this.m_queueableReportingHandler == null) {
                this.m_logger.unexpectedSituation("Lookup of reporting handler named \"" + runTimeInfoReporter + "\" failed.");
            }
            this.m_processManager.setMinProcessCount(Integer.parseInt(initParamsMap.get("linger_process")));
            int maxProcNum = Integer.parseInt(initParamsMap.get("max_process"));
            this.m_logger.traceInformative(thisMethod + "maxProcNum " + maxProcNum);
            this.m_processManager.setMaxProcessCount(maxProcNum);
            int shutdownTimeLimit = Integer.parseInt(initParamsMap.get("process_shutdown_timeout_ms"));
            this.m_processManager.setShutdownTimeLimit(shutdownTimeLimit);
            String delinquentTimeoutSecondsStr = initParamsMap.get("delinquent_timeout_seconds");
            if (delinquentTimeoutSecondsStr != null) {
                try {
                    int delinquentTimeoutSeconds = Integer.parseInt(delinquentTimeoutSecondsStr);
                    this.m_processManager.setDelinquenceLimit(delinquentTimeoutSeconds);
                }
                catch (Exception e) {
                    this.m_logger.unexpectedSituation("Lookup of reporting handler named \"" + runTimeInfoReporter + "\" failed.");
                }
            }
            int idle_process_check_interval_ms = Integer.parseInt(initParamsMap.get("idle_process_check_interval_ms"));
            int idle_process_max_idle_ticks = Integer.parseInt(initParamsMap.get("idle_process_max_idle_ticks"));
            this.m_processManager.setIdleProcessTimeout(idle_process_check_interval_ms, idle_process_max_idle_ticks, -1L);
            this.m_processManager.setRequestCountLimit(Integer.parseInt(initParamsMap.get("default_process_use_limit")));
            this.m_mdsrvQueue.setProcessList(this.m_processManager.getProcessList());
            this.m_requestInvoker.setDefaultTimeout(Integer.parseInt(initParamsMap.get("queue_time_limit_ms")));
            this.m_requestInvoker.setReportServerPath(initParamsMap.get("worker_request_path"));
            this.m_requestInvoker.setCleanListName(this.m_cleanListName);
            if (this.m_logger.isTraceInformativeEnabled()) {
                this.m_logger.traceInformative("Current async_wait_timeout_ms value: " + this.m_requestExpirationTime);
            }
            this.m_requestExpirationTime = Integer.parseInt(initParamsMap.get("async_wait_timeout_ms"));
            if (this.m_logger.isTraceInformativeEnabled()) {
                this.m_logger.traceInformative("async_wait_timeout_ms value from configuration file: " + this.m_requestExpirationTime);
            }
            this.m_processManager.setPrestartProcess(Boolean.valueOf(initParamsMap.get("prestart_process")));
            String notificationTimeStr = initParamsMap.get("notificationTimeInterval");
            if (notificationTimeStr != null) {
                this.m_notificationTimeInterval = Integer.parseInt(notificationTimeStr) * 1000;
            }
            this.m_logger.methodEnd(thisMethod);
        }
        catch (Exception ex) {
            this.m_logger.rethrownException("problem composing " + this.getName(), ex);
            throw new PogoException(DispatcherStrings.getInstance().getString("ReportServerHandler.badConfig"), ex);
        }
    }

    public void contextualize(Element config) throws PogoException {
        String thisMethod = "MDSRVHandler.contextualize: ";
        this.m_logger.methodStart(thisMethod);
        super.contextualize(config);
        String factoryClassName = this.getRequiredAttribute(this.m_logger4Disp, "objectFactory");
        try {
            this.m_componentFactory = (MDProviderComponentFactory)((Object)Class.forName(factoryClassName).newInstance());
            this.m_componentFactory.setHandler(this);
        }
        catch (Exception e) {
            this.m_logger.rethrownException("unable to instantiate object factory " + factoryClassName, e);
            throw new PogoException("unable to instantiate object factory " + factoryClassName, e);
        }
        this.m_executingRequests = this.m_componentFactory.newInteractiveReportExecutingRequests();
        this.m_requestInvoker = (MDProviderRequestInvoker)this.m_componentFactory.newRequestInvoker(this.m_executingRequests);
        this.m_logger.methodEnd(thisMethod + "requestInvoker " + (Object)((Object)this.m_requestInvoker));
    }

    public void configure(Configuration configuration) {
        this.m_configuration = configuration;
        if (this.m_configuration != null) {
            this.m_commandFactory.configure(this.m_configuration);
            this.m_requestInvoker.configure(this.m_configuration);
            if (this.m_processManager != null) {
                this.m_processManager.configure(this.m_configuration);
            }
            this.m_inProgressRequests.configure(this.m_configuration);
            int queueLimit = -1;
            this.m_mdsrvQueue.setDefaultTimeout((long)queueLimit);
            boolean inPeakDemandPeriod = "true".equalsIgnoreCase(this.m_configuration.getValue("inPeakDemandPeriod"));
            int maxProcess = 0;
            try {
                maxProcess = inPeakDemandPeriod ? Integer.parseInt(this.m_configuration.getValue("mdsPeakMaximumProcesses")) : Integer.parseInt(this.m_configuration.getValue("mdsMaximumProcesses"));
                this.m_processManager.setMaxProcessCount(maxProcess);
            }
            catch (Exception ex) {
                this.m_logger.unexpectedHandledException("Configuration property 'mdsMaximumProcesses' did not return an integer.  Ignoring configuration update", ex);
            }
        }
    }

    public void reconfigure(Configuration configuration) {
        this.configure(configuration);
    }

    public ProcessManager getProcessManager() {
        return this.m_processManager;
    }

    public void start() {
        this.m_inProgressRequests.startExpirationTimer(this.m_requestExpirationTime);
        if (this.m_processManager != null) {
            this.m_processManager.start(this.m_configuration);
        }
    }

    public void stop() {
        if (this.m_mdsrvQueue != null) {
            this.m_mdsrvQueue.shutdown();
        }
        if (this.m_processManager != null) {
            this.m_processManager.shutdown();
        }
        if (this.m_inProgressRequests != null) {
            this.m_inProgressRequests.cancelExpirationTimer();
        }
    }

    public void suspend(boolean immediate) {
        if (!immediate) {
            return;
        }
        this.m_processManager.suspend(immediate);
        this.m_mdsrvQueue.suspend(immediate);
        this.m_inProgressRequests.clear();
    }

    public void resume() {
        String thisMethod = "MDSRVHandler.resume ";
        this.m_logger.methodStart(thisMethod);
        this.m_processManager.resumeIt();
        this.m_mdsrvQueue.resume();
        this.m_logger.methodEnd(thisMethod);
    }

    public void testFinishedStopping() {
        if (this.m_queueableReportingHandler == null) {
            return;
        }
        RequestReporter reporter = this.m_queueableReportingHandler.getRequestReporter();
        String state = reporter.getServiceStatus();
        if (state != "stopping") {
            return;
        }
        if (this.m_mdsrvQueue.getQueueSize() != 0) {
            return;
        }
        if (this.m_inProgressRequests.size() != 0) {
            return;
        }
        this.m_logger.traceInformative("service goes from \"STOPPING\" to \"SUSPENDED\"");
        reporter.setServiceStatus("suspended");
    }

    public AsyncService getAsyncRequest(MessageContext mc) {
        MDSRVAsyncService asyncService = null;
        String thisMethod = "MDSRVHandler.getAsyncRequest ";
        this.m_logger.methodStart(thisMethod);
        BIBusEnvelope reqEnv = (BIBusEnvelope)mc.getProperty("request.envelope");
        Element body = reqEnv.getBody();
        Iterator itElems = body.elementIterator();
        while (itElems.hasNext()) {
            Element method = (Element)itElems.next();
            if ("runSpecification".equals(method.getName())) {
                int primaryThreshold = 1;
                RequestOptions requestOptions = new RequestOptions(mc);
                int tempPT = requestOptions.getIntValue("primaryWaitThreshold");
                if (tempPT >= 0) {
                    this.m_logger.traceInformative(thisMethod + " Incoming Request contains Primary threshold " + tempPT);
                    primaryThreshold = tempPT;
                }
                this.m_logger.traceInformative(thisMethod + " Primary threshold " + primaryThreshold);
                mc.setProperty("multipart", (Object)Boolean.FALSE);
                mc.setProperty("getOutputRequired", (Object)Boolean.TRUE);
                mc.setProperty("executionTime", (Object)"5");
                mc.setProperty("answerWithFault", (Object)Boolean.FALSE);
                this.m_commandServiceParams.put(CommandFixtures.CONFIGURATION, this.m_configuration);
                this.m_commandServiceParams.put(CommandFixtures.MDPROVIDERREQUESTINVOKER, (Object)this.m_requestInvoker);
                this.m_commandServiceParams.put(CommandFixtures.MESSAGECONTEXT, mc);
                return new MDSRVAsyncService(this.m_commandFactory, this.m_commandServiceParams, primaryThreshold, this.m_cleanListName);
            }
            if (!"release".equals(method.getName()) && !"cancel".equals(method.getName())) continue;
            asyncService = new MDSRVAsyncService(this.m_commandFactory, this.m_commandServiceParams, 0, this.m_cleanListName);
        }
        if (asyncService == null) {
            this.m_logger.traceInformative(thisMethod + " Method called will processed synchronously ");
        }
        return asyncService;
    }

    public void invokeImpl(MessageContext mc) {
        MDSRVLogUtil logUtil = MDSRVLogUtil.getLogUtilInstance();
        ServicePerfMarker sp = new ServicePerfMarker(((Object)((Object)this)).getClass().getName() + ".invokeImpl", "BEGIN");
        BIBusEnvelope requestEnvelope = (BIBusEnvelope)mc.getProperty("request.envelope");
        logUtil.startMDSRVRequest(requestEnvelope);
        this.m_logger.traceInformative("MDSRVHandler.invokeImpl  sync invoke " + mc.toString());
        try {
            this.processRequest(mc);
        }
        catch (MDSRVException mdsrvExc) {
            logUtil.runtimeError(mdsrvExc, requestEnvelope);
            Fault fault = mdsrvExc.getFault();
            mc.setFault(fault);
        }
        catch (Exception ex) {
            logUtil.runtimeError(ex, requestEnvelope);
            Fault fault = new Fault(MDSRVException.determineMessageCode(ex), ex);
            mc.setFault(fault);
        }
        catch (Throwable th) {
            logUtil.runtimeError(th, requestEnvelope);
            Fault fault = new Fault(MDSRVException.determineMessageCode(th));
            mc.setFault(fault);
        }
        sp.endPerf();
        logUtil.endMDSRVRequest((BIBusEnvelope)mc.getProperty("response.envelope"));
    }

    private BIBusEnvelope processRequest(MessageContext mc) throws MDSRVException {
        BIBusEnvelope response = null;
        Element commandElem = null;
        this.m_commandServiceParams.put(CommandFixtures.CONFIGURATION, this.m_configuration);
        this.m_commandServiceParams.put(CommandFixtures.MDPROVIDERREQUESTINVOKER, (Object)this.m_requestInvoker);
        CommandKey commandKey = new CommandKey(mc);
        commandElem = commandKey.getCommandElem();
        Command requestHandler = this.m_commandFactory.getCommand(commandElem, this.m_commandServiceParams);
        if (requestHandler == null) {
            throw new MDSRVException(MDSRVErrorType.CLIENT, MDSRVErrorCode.MSR_MSR_CommandNotFound);
        }
        boolean answeredWithFault = requestHandler.invokeRequest(mc);
        if (!answeredWithFault) {
            response = (BIBusEnvelope)mc.getProperty("response.envelope");
            response.setBIBusHeader((Element)commandKey.getRequest().getBIBusHeader().clone());
            response.setConversationContextStatus("complete");
            mc.setResponseName("response");
            mc.setProperty("response.envelope", (Object)response);
            mc.setProperty("response.status_code", (Object)Integer.toString(200));
            mc.setProperty("response.status_msg", (Object)"OK");
        }
        return response;
    }

    public String[] getProcessArguments(List<Element> childProcCmdList, Map<String, String> initParamMap) throws IOException {
        ArrayList<String> argList = new ArrayList<String>();
        String exeName = initParamMap.get("exe_name");
        argList.add(exeName);
        argList.add("threads=10");
        argList.add("camssl=" + (this.m_usessl ? "true" : "false"));
        argList.add("COG_ROOT=");
        Iterator<Element> iterator = childProcCmdList.iterator();
        while (iterator.hasNext()) {
            argList.add(iterator.next().getTextTrim());
        }
        String[] args = new String[argList.size()];
        for (int i = 0; i < args.length; ++i) {
            args[i] = (String)argList.get(i);
        }
        return args;
    }

    public ReportServerQueue getReportServerQueue() {
        return this.m_mdsrvQueue;
    }

    public ReportServerInProgressRequests getInProgressRequests() {
        return this.m_inProgressRequests;
    }

    public String getProcessUseLimitPropertyName() {
        return INTERACTIVE_PROCESS_USE_LIMIT;
    }

    public int getRequestUsage() {
        return this.m_processManager.getRequestUsage();
    }

    public int getCurrentCapacity() {
        return -1;
    }

    public String constructMessageID(String msgTail) {
        String msgID = this.m_errorMessageCodePrefix + msgTail;
        this.m_logger.traceInformative("generated fault message ID: " + msgID);
        return msgID;
    }

    public void dispose() {
        super.dispose();
    }

    private static Map<String, String> getInitParams(List<Element> initParamList) {
        if (initParamList == null) {
            return new HashMap<String, String>();
        }
        HashMap<String, String> initParamsMap = new HashMap<String, String>(initParamList.size());
        for (Element initParamElement : initParamList) {
            initParamsMap.put(initParamElement.elementTextTrim("param-name"), initParamElement.elementTextTrim("param-value"));
        }
        return initParamsMap;
    }

    class CleanableImpl
    implements Cleanable {
        MDSRVLogUtil m_logUtil = MDSRVLogUtil.getLogUtilInstance();

        CleanableImpl() {
        }

        public void clean(MessageContext mc) {
            if (this.m_logUtil.isMethodTraceEnabled()) {
                this.m_logUtil.traceInformative("MDSRVHandler.CleanableImpl.clean ");
            }
            if (this.m_logUtil.isMethodTraceEnabled()) {
                this.m_logUtil.traceInformative("MDSRVHandler.CleanableImpl.clean ");
            }
        }
    }
}

