/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.metadataService.bibusHandler.mdprovider;

import com.cognos.metadataService.bibusHandler.mdprovider.MDProviderComponentFactory;
import com.cognos.metadataService.util.logging.MDSRVLogUtil;
import com.cognos.pogo.pdk.Configuration;
import com.cognos.pogo.reportservice.ProcessManager;
import com.cognos.pogo.reportservice.RSComponentFactory;
import com.cognos.pogo.reportservice.ReportServerQueueCallback;
import org.dom4j.Element;

public class MDProviderProcessManager
extends ProcessManager {
    boolean m_prestartProcess = false;
    MDSRVLogUtil m_logUtil = MDSRVLogUtil.getLogUtilInstance();

    public boolean isPrestartProcess() {
        return this.m_prestartProcess;
    }

    public void setPrestartProcess(boolean prestartProcess) {
        this.m_prestartProcess = prestartProcess;
    }

    public MDProviderProcessManager(MDProviderComponentFactory compFactory, String serviceName, ReportServerQueueCallback callback, String[] args, Element config, String host, int port, boolean ssl) {
        super((RSComponentFactory)compFactory, serviceName, callback, args, config, host, port, ssl);
    }

    public void start(Configuration configuration) {
        this.correctProcessBinaryPath(configuration.getICCLConfiguration());
        int minProcessCount = this.getMinProcessCount();
        int maxProcessCount = this.getMaxProcessCount();
        this.m_logUtil.traceInformative("minimum (linger) process count is: " + minProcessCount);
        this.m_logUtil.traceInformative("maximum process count is: " + maxProcessCount);
        minProcessCount = Math.min(minProcessCount, this.getMaxProcessCount());
        if (this.m_prestartProcess && minProcessCount > 0) {
            this.m_logUtil.traceInformative("prestarting " + minProcessCount + " processes.");
            this.createAnotherProcess(minProcessCount);
        }
        this.start();
    }

    public void configure(Configuration configuration) {
        String thisMethod = "MDSRVProcessManager.configure ";
        Element configurationFromCM = configuration.getCmResponse();
        if (configurationFromCM == null) {
            this.m_logUtil.unexpectedSituation(thisMethod + "null configurationFromCM ie configuration.getCmResponse()");
        } else {
            this.setCclConfiguration(configurationFromCM);
        }
        boolean inPeakDemandPeriod = "true".equalsIgnoreCase(configuration.getValue("inPeakDemandPeriod"));
        try {
            int nonAffineConnections;
            int affineConnections;
            if (inPeakDemandPeriod) {
                affineConnections = MDProviderProcessManager.getIntConfigProperty(configuration, "mdsrvPeakAffineConnections");
                nonAffineConnections = MDProviderProcessManager.getIntConfigProperty(configuration, "mdsrvPeakNonAffineConnections");
            } else {
                affineConnections = MDProviderProcessManager.getIntConfigProperty(configuration, "mdsrvAffineConnections");
                nonAffineConnections = MDProviderProcessManager.getIntConfigProperty(configuration, "mdsrvNonAffineConnections");
            }
            this.updateConnectionsPerProcess(affineConnections, nonAffineConnections);
            this.updateActiveCM(configuration.getValue("contentManager"));
            try {
                int maxProcess = inPeakDemandPeriod ? MDProviderProcessManager.getIntConfigProperty(configuration, "mdsrvPeakMaximumProcesses") : MDProviderProcessManager.getIntConfigProperty(configuration, "mdsrvMaximumProcesses");
                this.setMaxProcessCount(maxProcess);
            }
            catch (NumberFormatException ex) {
                this.m_logUtil.unexpectedHandledException(thisMethod + "Configuration property 'mdsrvMaximumProcesses' did not return an integer.  Ignoring configuration update", ex);
            }
        }
        catch (NumberFormatException ex) {
            this.m_logUtil.unexpectedHandledException(thisMethod + "Configuration connection properties did not return integers.  Ignoring configuration update", ex);
        }
        this.setWorkingDirectory(configuration.getICCLConfiguration().resolveEffectivePath("../bin"));
        this.useNewConfiguration();
    }

    static int getIntConfigProperty(Configuration configuration, String propertyName) {
        return Integer.parseInt(configuration.getValue(propertyName));
    }
}

