/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.metadataService.bibusHandler.soaphelpers;

import com.cognos.developer.schemas.bibus._3.AsynchDetailMIMEAttachment;
import com.cognos.developer.schemas.bibus._3.AsynchReply;
import com.cognos.developer.schemas.bibus._3.AsynchReplyStatusEnum;
import com.cognos.developer.schemas.bibus._3.Base64BinaryMIMEProp;
import com.cognos.developer.schemas.bibus._3.EncodingEnum;
import com.cognos.developer.schemas.bibus._3.Option;
import com.cognos.metadataService.util.logging.MDSRVLogUtil;
import com.cognos.metadataService.util.misc.AxisTypesHelper;
import com.cognos.pogo.async.AsyncServiceBase;
import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.pogo.pdk.MessageContext;
import com.cognos.pogo.pdk.SOAPEnvelope;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.SequenceInputStream;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.zip.GZIPOutputStream;
import org.apache.axis.encoding.Base64;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.QName;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;

public class AsyncResponseHelper {
    public static final String OPTION = BIBusEnvelope.NS_BUS.getPrefix() + ":option";
    private BIBusEnvelope m_commandResponseEnv;
    public static final String SECONDARY_REQUEST = BIBusEnvelope.NS_BUS.getPrefix() + ":asynchSecondaryRequest";
    public static final QName SECONDARY_REQUESTS = DocumentHelper.createQName((String)"secondaryRequests");
    public static final QName STATUS = DocumentHelper.createQName((String)"status");
    public static final String PARAMETER_VALUE = BIBusEnvelope.NS_BUS.getPrefix() + ":parameterValue";
    private static final String CONTENT_ID_HEADER_VALUE = "lineageResponseAttachment@cognos.ibm.com";
    private static final String CONTENT_TYPE_HEADER_LINE = "Content-Type: application/xml\r\n";
    private static final String CONTENT_TYPE_GZIP_LINE = "Content-Type: application/xml\r\n";
    private static final String CONTENT_ID_HEADER_LINE = "Content-Id: lineageResponseAttachment@cognos.ibm.com\r\n";
    private static final String CONTENT_GZIP_HEADER_LINE = "Content-Encoding: gzip\r\n";
    private static final String CONTENT_8BIT_HEADER_LINE = "Content-Transfer-Encoding: 8bit\r\n\n";
    private static final String CONTENT_LENGTH = "Content-Length: -size-\r\n";
    private static final String UNCOMPRESSED_HEADER = "Content-Type: application/xml\r\nContent-Id: lineageResponseAttachment@cognos.ibm.com\r\nContent-Length: -size-\r\nContent-Transfer-Encoding: 8bit\r\n\n";
    private static final String COMPRESSED_HEADER = "Content-Type: application/xml\r\nContent-Id: lineageResponseAttachment@cognos.ibm.com\r\nContent-Encoding: gzip\r\nContent-Length: -size-\r\nContent-Transfer-Encoding: 8bit\r\n\n";

    public BIBusEnvelope writeResponse(MessageContext mc, AsynchReplyStatusEnum status, BIBusEnvelope commandResponseEnvelope, ArrayList<InputStream> attachmentList) {
        BIBusEnvelope requestEnvelope = (BIBusEnvelope)mc.getProperty("request.envelope");
        BIBusEnvelope mcResponseEnvelope = AsyncServiceBase.prepareSkeletalResponse((BIBusEnvelope)requestEnvelope, (MessageContext)mc, null);
        Element responseBodyElem = mcResponseEnvelope.getBody();
        QName responseQName = this.getResponseQName(requestEnvelope);
        Element asynchResponseRootElem = responseBodyElem.addElement(responseQName);
        Element asynchResponseResultElem = AxisTypesHelper.addBIBusResponseElem(asynchResponseRootElem, "bus:result", AxisTypesHelper.getOMClassTypeName(AsynchReply.class));
        this.addSecondaryRequests(status, asynchResponseResultElem);
        Element statusElem = AxisTypesHelper.addBIBusResponseElem(asynchResponseResultElem, "bus:status", "asynchReplyStatusEnum");
        statusElem.setText(status.getValue());
        mcResponseEnvelope.setConversationContextStatus(status.getValue());
        Element commandResultsElem = this.getCommandResults(commandResponseEnvelope);
        if (commandResultsElem != null) {
            String responseXml;
            Element detailsElem = AxisTypesHelper.addResponseElem(asynchResponseResultElem, "details", SOAPEnvelope.SOAP_ENC_ARRAY);
            String responseXmlEncoded = responseXml = commandResultsElem.asXML();
            EncodingEnum encoding = AsyncResponseHelper.getEncodingOptionForAsyncRequest(requestEnvelope);
            detailsElem.addAttribute(SOAPEnvelope.SOAP_ENC_ARRAYTYPE, AxisTypesHelper.getBIBusObjectTypeName(AxisTypesHelper.getOMClassTypeName(AsynchDetailMIMEAttachment.class) + "[1]"));
            Element itemElem = AxisTypesHelper.addBIBusResponseElem(detailsElem, "item", AxisTypesHelper.getOMClassTypeName(AsynchDetailMIMEAttachment.class));
            Element dataElem = AxisTypesHelper.addResponseElem(itemElem, "data", AxisTypesHelper.getXsdPropValueTypeName(Base64BinaryMIMEProp.class));
            if (attachmentList.size() > 0) {
                mc.setProperty("response.attachments", attachmentList.iterator());
            }
            if (encoding.equals((Object)EncodingEnum.MIME) || encoding.equals((Object)EncodingEnum.MIMECompressed)) {
                dataElem.addAttribute("href", CONTENT_ID_HEADER_VALUE);
                ByteArrayInputStream headerStream = null;
                mc.setProperty("multipart", (Object)Boolean.TRUE);
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                try {
                    String header;
                    BufferedOutputStream outStream;
                    if (encoding.equals((Object)EncodingEnum.MIMECompressed)) {
                        outStream = new BufferedOutputStream(new GZIPOutputStream(baos));
                        ((OutputStream)outStream).write(responseXmlEncoded.getBytes("UTF-8"));
                        ((OutputStream)outStream).flush();
                        ((OutputStream)outStream).close();
                        baos.close();
                        header = COMPRESSED_HEADER.replaceAll("-size-", Integer.toString(baos.size()));
                        headerStream = new ByteArrayInputStream(header.getBytes());
                    } else {
                        outStream = new BufferedOutputStream(baos);
                        ((OutputStream)outStream).write(responseXmlEncoded.getBytes("UTF-8"));
                        ((OutputStream)outStream).flush();
                        ((OutputStream)outStream).close();
                        baos.close();
                        header = UNCOMPRESSED_HEADER.replaceAll("-size-", Integer.toString(baos.size()));
                        headerStream = new ByteArrayInputStream(header.getBytes());
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                ByteArrayInputStream resultStream = new ByteArrayInputStream(baos.toByteArray());
                SequenceInputStream sequenceStream = new SequenceInputStream(headerStream, resultStream);
                attachmentList.add(0, sequenceStream);
                mc.setProperty("response.boundary", (Object)"###_MIME_BOUNDARY_###");
                mc.setProperty("response.attachments", attachmentList.iterator());
            } else {
                responseXmlEncoded = this.encodeResults(responseXml);
                dataElem.setText(responseXmlEncoded);
            }
            Element dataSizeElem = AxisTypesHelper.addResponseElem(itemElem, "dataSize", "xsd:integer");
            dataSizeElem.setText(String.valueOf(responseXmlEncoded.length()));
            Element dataTypeElem = AxisTypesHelper.addResponseElem(itemElem, "dataType", "xsd:string");
            dataTypeElem.setText("application/xml");
            this.m_commandResponseEnv = mcResponseEnvelope;
        }
        return this.m_commandResponseEnv;
    }

    private String encodeResults(String responseXml) {
        String responseXmlEncoded = null;
        try {
            responseXmlEncoded = Base64.encode((byte[])responseXml.getBytes("utf-8"));
        }
        catch (UnsupportedEncodingException e) {
            MDSRVLogUtil.getLogUtilInstance().rethrownException("writeResponse, UnsupportedEncodingException occurred when trying to encode: " + responseXml, e);
            throw new RuntimeException(e);
        }
        return responseXmlEncoded;
    }

    Element getCommandResults(BIBusEnvelope commandResponseEnvelope) {
        Element responseBodyElem;
        List commandResponseBodyElems;
        Iterator commandResponseBodyElemsIter;
        Element commandResponseBodyElem = null;
        if (commandResponseEnvelope != null && (commandResponseBodyElemsIter = (commandResponseBodyElems = (responseBodyElem = commandResponseEnvelope.getBody()).elements()).iterator()).hasNext()) {
            commandResponseBodyElem = (Element)commandResponseBodyElemsIter.next();
            commandResponseBodyElem.detach();
        }
        return commandResponseBodyElem;
    }

    private void addSecondaryRequest(String requestName, Element secondaryRequestsElement) {
        Element itemElement = secondaryRequestsElement.addElement("item");
        itemElement.addAttribute(SOAPEnvelope.XSI_TYPE, SECONDARY_REQUEST);
        Element nameElement = itemElement.addElement("name");
        nameElement.addAttribute(SOAPEnvelope.XSI_TYPE, SOAPEnvelope.XSD_STRING);
        nameElement.setText(requestName);
        Element paramsElement = itemElement.addElement("parameters");
        paramsElement.addAttribute(SOAPEnvelope.XSI_TYPE, SOAPEnvelope.SOAP_ENC_ARRAY);
        paramsElement.addAttribute(SOAPEnvelope.SOAP_ENC_ARRAYTYPE, PARAMETER_VALUE + "[0]");
        Element optionsElement = itemElement.addElement("options");
        optionsElement.addAttribute(SOAPEnvelope.XSI_TYPE, SOAPEnvelope.SOAP_ENC_ARRAY);
        optionsElement.addAttribute(SOAPEnvelope.SOAP_ENC_ARRAYTYPE, AxisTypesHelper.getBIBusObjectTypeName(AxisTypesHelper.getOMClassTypeName(Option.class)) + "[0]");
    }

    /*
     * Enabled aggressive block sorting
     */
    private Element addSecondaryRequests(AsynchReplyStatusEnum statusEnum, Element resultElement) {
        Element secondaryRequestsElement;
        MDSRVLogUtil util;
        block12: {
            util = MDSRVLogUtil.getLogUtilInstance();
            if (util.isMethodTraceEnabled()) {
                util.methodStart("MDSRVAsyncService.addSecondaryRequests start");
            }
            if (!(AsynchReplyStatusEnum.working.equals((Object)statusEnum) || AsynchReplyStatusEnum.stillWorking.equals((Object)statusEnum) || AsynchReplyStatusEnum.complete.equals((Object)statusEnum))) {
                return null;
            }
            secondaryRequestsElement = resultElement.element(SECONDARY_REQUESTS);
            if (secondaryRequestsElement != null) {
                if (secondaryRequestsElement.attribute(BIBusEnvelope.XSI_NIL) != null) {
                    if (util.isTraceInformativeEnabled()) {
                        util.traceInformative("MDSRVAsyncService.addSecondaryRequests empty");
                    }
                    secondaryRequestsElement.attribute(BIBusEnvelope.XSI_NIL).detach();
                    break block12;
                } else {
                    if (util.isTraceInformativeEnabled()) {
                        util.traceInformative("MDSRVAsyncService.addSecondaryRequests exists");
                    }
                    return secondaryRequestsElement;
                }
            }
            if (util.isTraceInformativeEnabled()) {
                util.traceInformative("MDSRVAsyncService.addSecondaryRequests create");
            }
            secondaryRequestsElement = resultElement.addElement(SECONDARY_REQUESTS);
            secondaryRequestsElement.addAttribute(SOAPEnvelope.XSI_TYPE, SOAPEnvelope.SOAP_ENC_ARRAY);
            secondaryRequestsElement.addAttribute(SOAPEnvelope.SOAP_ENC_ARRAYTYPE, SECONDARY_REQUEST + "[1]");
        }
        if (AsynchReplyStatusEnum.working.equals((Object)statusEnum) || AsynchReplyStatusEnum.stillWorking.equals((Object)statusEnum)) {
            this.addSecondaryRequest("wait", secondaryRequestsElement);
            this.addSecondaryRequest("cancel", secondaryRequestsElement);
        } else if (AsynchReplyStatusEnum.complete.equals((Object)statusEnum)) {
            this.addSecondaryRequest("release", secondaryRequestsElement);
        }
        if (util.isMethodTraceEnabled()) {
            util.methodEnd("MDSRVAsyncService.addSecondaryRequests END");
        }
        return secondaryRequestsElement;
    }

    private static EncodingEnum getEncodingOptionForAsyncRequest(BIBusEnvelope requestEnvelope) {
        Element optionsElem;
        EncodingEnum encodingOptionValue = null;
        Element requestBody = requestEnvelope.getBody();
        Element asyncCommandElem = null;
        Iterator childElemsIter = requestBody.elementIterator();
        if (childElemsIter.hasNext()) {
            asyncCommandElem = (Element)childElemsIter.next();
        }
        if (asyncCommandElem != null && (optionsElem = asyncCommandElem.element("options")) != null) {
            Element asynchOptionItemElem = null;
            Iterator optionsSubElemsIter = optionsElem.elementIterator();
            while (optionsSubElemsIter.hasNext()) {
                Element optionsSubElem = (Element)optionsSubElemsIter.next();
                Element nameElem = optionsSubElem.element("name");
                if (!nameElem.getText().equals("attachmentEncoding")) continue;
                asynchOptionItemElem = optionsSubElem;
            }
            if (asynchOptionItemElem != null) {
                Element valueElem = asynchOptionItemElem.element("value");
                encodingOptionValue = EncodingEnum.fromString((String)valueElem.getText());
            }
        }
        if (encodingOptionValue == null) {
            encodingOptionValue = EncodingEnum.base64;
        }
        return encodingOptionValue;
    }

    private QName getResponseQName(BIBusEnvelope requestEnvelope) {
        QName responceQName = null;
        Element body = requestEnvelope.getBody();
        Iterator children = body.elementIterator();
        if (children.hasNext()) {
            Element child = (Element)children.next();
            responceQName = new QName("runSpecificationResponse", child.getNamespace());
        }
        return responceQName;
    }

    public static void dumpToFile(Node node, String pathName, OutputFormat outputFormat) {
        try {
            String nodeStr = AsyncResponseHelper.domToString(node, outputFormat);
            File outFile = new File(pathName);
            if (outFile.exists()) {
                outFile.delete();
            }
            if (outFile.createNewFile()) {
                FileWriter fileWriter = new FileWriter(outFile);
                fileWriter.write(nodeStr);
                fileWriter.flush();
                fileWriter.close();
            }
        }
        catch (IOException e) {
            throw new RuntimeException("IOException caught: " + e.getMessage(), e);
        }
    }

    public static String domToString(Node node, OutputFormat outputFormat) throws IOException {
        StringWriter domStringWriter = new StringWriter();
        XMLWriter writer = new XMLWriter((Writer)domStringWriter, outputFormat);
        writer.write(node);
        String nodeStr = domStringWriter.toString();
        domStringWriter.flush();
        domStringWriter.close();
        writer.flush();
        writer.close();
        StringBuffer nodeStringBuffer = new StringBuffer(nodeStr);
        return new String(nodeStringBuffer);
    }
}

