/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.metadataService.bibusHandler.wip;

import com.cognos.developer.schemas.bibus._3.AsynchDetailUnstructuredData;
import com.cognos.developer.schemas.bibus._3.XmlEncodedXML;
import com.cognos.metadataService.command.Command;
import com.cognos.metadataService.command.CommandFactory;
import com.cognos.metadataService.command.CommandFixtures;
import com.cognos.metadataService.command.CommandKey;
import com.cognos.metadataService.util.errors.MDSRVErrorCode;
import com.cognos.metadataService.util.errors.MDSRVErrorType;
import com.cognos.metadataService.util.errors.MDSRVException;
import com.cognos.pogo.async.AsyncContext;
import com.cognos.pogo.async.AsyncServiceBase;
import com.cognos.pogo.async.service.AsyncBIBusXMLHelper;
import com.cognos.pogo.async.service.connection.IConnection;
import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.pogo.pdk.Configuration;
import com.cognos.pogo.pdk.Fault;
import com.cognos.pogo.pdk.MessageContext;
import com.cognos.pogo.pdk.SOAPEnvelope;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.axis.description.TypeDesc;
import org.dom4j.Element;

public class MDSRVConnection
implements IConnection {
    HashMap<CommandFixtures, Object> m_fixtures;
    CommandFactory m_commandFactory;
    Configuration m_configuration;

    public MDSRVConnection(HashMap<CommandFixtures, Object> fixtures) {
        this.m_fixtures = fixtures;
        this.m_commandFactory = (CommandFactory)fixtures.get(CommandFixtures.COMMANDFACTORY);
        this.m_configuration = (Configuration)fixtures.get(CommandFixtures.CONFIGURATION);
    }

    public boolean invokeRequest(MessageContext mc) {
        boolean isFaulted = false;
        try {
            CommandKey commandKey = new CommandKey(mc);
            Command requestHandler = this.m_commandFactory.getCommand(commandKey.getCommandElem(), this.m_fixtures);
            if (requestHandler == null) {
                throw new MDSRVException(MDSRVErrorType.CLIENT, MDSRVErrorCode.MSR_MSR_CommandNotFound);
            }
            isFaulted = requestHandler.invokeRequest(mc);
            if (commandKey.isAsync()) {
                MDSRVConnection.buildAsyncReplyDetails(mc);
            }
            MDSRVConnection.finalizeResponse(mc);
        }
        catch (MDSRVException mdsrvExc) {
            Fault fault = mdsrvExc.getFault();
            mc.setFault(fault);
            isFaulted = true;
        }
        catch (Exception ex) {
            Fault fault = new Fault(MDSRVException.determineMessageCode(ex), ex);
            mc.setFault(fault);
            isFaulted = true;
        }
        catch (Throwable th) {
            Fault fault = new Fault(MDSRVException.determineMessageCode(th));
            mc.setFault(fault);
            isFaulted = true;
        }
        return isFaulted;
    }

    public boolean waitReceivedForRequest(MessageContext mc, AsyncContext ac) {
        return false;
    }

    public boolean abandonRequest(MessageContext mc, AsyncContext ac) {
        return false;
    }

    public boolean cancelRequest(MessageContext mc, AsyncContext ac) {
        return false;
    }

    public boolean getOutputForRequest(MessageContext mc) {
        return false;
    }

    public boolean release() {
        return false;
    }

    public boolean releaseRequest(MessageContext mc) {
        return false;
    }

    public static void buildAsyncReplyDetails(MessageContext mc) {
        BIBusEnvelope requestEnvelope = (BIBusEnvelope)mc.getProperty("request.envelope");
        Element responseDetailsElem = null;
        BIBusEnvelope commandResponseEnvelope = (BIBusEnvelope)mc.getProperty("response.envelope");
        if (commandResponseEnvelope != null) {
            Element body = commandResponseEnvelope.getBody();
            Element mcResponseBodyElem = body;
            List mcResponseRootElems = mcResponseBodyElem.elements();
            if (mcResponseRootElems.size() > 0) {
                responseDetailsElem = (Element)mcResponseRootElems.get(0);
                mcResponseBodyElem.detach();
            }
            if (responseDetailsElem != null) {
                AsyncServiceBase.prepareSkeletalResponse((BIBusEnvelope)requestEnvelope, (MessageContext)mc, null);
                AsyncBIBusXMLHelper xmlBusXMLHelper = new AsyncBIBusXMLHelper();
                xmlBusXMLHelper.prepareCompletedPrimaryResponse(mc);
                mc.getProperty("response.envelope");
                Element responseBodyElem = body;
                Element detailsElem = responseBodyElem.element("details");
                if (detailsElem == null || "true".equals(detailsElem.attributeValue(SOAPEnvelope.XSI_NIL))) {
                    Element detailsParentElem = detailsElem.getParent();
                    detailsElem.detach();
                    detailsElem = detailsParentElem.addElement("details");
                }
                detailsElem.addAttribute(SOAPEnvelope.XSI_TYPE, SOAPEnvelope.SOAP_ENC_ARRAY);
                detailsElem.addAttribute(SOAPEnvelope.SOAP_ENC_ARRAYTYPE, MDSRVConnection.buildBusTypeDesc(AsynchDetailUnstructuredData.getTypeDesc()) + "[1]");
                Element itemElem = detailsElem.addElement("item");
                itemElem.addAttribute(SOAPEnvelope.XSI_TYPE, MDSRVConnection.buildBusTypeDesc(AsynchDetailUnstructuredData.getTypeDesc()));
                Element dataElem = itemElem.addElement("data");
                dataElem.addAttribute(SOAPEnvelope.XSI_TYPE, MDSRVConnection.buildBusTypeDesc(XmlEncodedXML.getTypeDesc()));
                List commandResponseBodyElems = body.elements();
                Iterator commandResponseBodyElemsIter = commandResponseBodyElems.iterator();
                if (commandResponseBodyElemsIter.hasNext()) {
                    Element commandResponseBodyElem = (Element)commandResponseBodyElemsIter.next();
                    dataElem.setText(commandResponseBodyElem.asXML());
                }
            }
        }
    }

    private static void finalizeResponse(MessageContext mc) {
        if (mc.getProperty("multipart") == null) {
            mc.setProperty("multipart", (Object)new Boolean(false));
        }
        BIBusEnvelope request = (BIBusEnvelope)mc.getProperty("request.envelope");
        BIBusEnvelope response = (BIBusEnvelope)mc.getProperty("response.envelope");
        response.setBIBusHeader((Element)request.getBIBusHeader().clone());
        mc.setResponseName("response");
    }

    private static String buildBusTypeDesc(TypeDesc typeDesc) {
        return BIBusEnvelope.NS_BUS.getPrefix() + ":" + typeDesc.getXmlType().getLocalPart();
    }
}

