/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.metadataService.command;

import com.cognos.cclcfgapi.CCLConfigurationException;
import com.cognos.cclcfgapi.CCLConfigurationFactory;
import com.cognos.cclcfgapi.ICCLConfiguration;
import com.cognos.developer.schemas.bibus._3.BiBusHeader;
import com.cognos.developer.schemas.bibus._3.CAM;
import com.cognos.developer.schemas.bibus._3.CAMPassport;
import com.cognos.developer.schemas.bibus._3.ContentManagerService_PortType;
import com.cognos.developer.schemas.bibus._3.ContentManagerService_ServiceLocator;
import com.cognos.developer.schemas.bibus._3.SaCAMService_PortType;
import com.cognos.developer.schemas.bibus._3.SaCAMService_ServiceLocator;
import com.cognos.metadataService.command.Command;
import com.cognos.metadataService.util.errors.MDSRVErrorCode;
import com.cognos.metadataService.util.errors.MDSRVErrorType;
import com.cognos.metadataService.util.errors.MDSRVException;
import java.net.MalformedURLException;
import java.net.URL;
import javax.xml.rpc.ServiceException;
import org.apache.axis.client.Stub;

public abstract class CMCommand
extends Command {
    protected ContentManagerService_PortType getContentManagerServicePort(String sPassport) {
        if (sPassport == null) {
            throw new MDSRVException(MDSRVErrorType.SERVER, MDSRVErrorCode.MSR_API_MissingParameter, "m_passportID=CAMPAssport()");
        }
        try {
            ContentManagerService_ServiceLocator serviceLocator = new ContentManagerService_ServiceLocator();
            ContentManagerService_PortType port = null;
            port = serviceLocator.getcontentManagerService(this.getDispatcherURL());
            this.configurePort((Stub)port, sPassport);
            return port;
        }
        catch (ServiceException mue) {
            throw new RuntimeException(mue);
        }
    }

    private SaCAMService_PortType getSaCAMServicePort(String sPassport) {
        if (sPassport == null) {
            throw new MDSRVException(MDSRVErrorType.SERVER, MDSRVErrorCode.MSR_API_MissingParameter, "m_passportID=CAMPAssport()");
        }
        try {
            SaCAMService_ServiceLocator serviceLocator = new SaCAMService_ServiceLocator();
            SaCAMService_PortType port = null;
            port = serviceLocator.getsaCAMService(this.getDispatcherURL());
            this.configurePort((Stub)port, sPassport);
            return port;
        }
        catch (ServiceException mue) {
            throw new RuntimeException(mue);
        }
    }

    private void configurePort(Stub port, String sPassport) {
        BiBusHeader header = this.createBiBusHeader(sPassport);
        port.setHeader("http://developer.cognos.com/schemas/bibus/3/", "biBusHeader", (Object)header);
        port._setProperty("sendMultiRefs", (Object)Boolean.FALSE);
    }

    private BiBusHeader createBiBusHeader(String sPassport) {
        CAMPassport pp = new CAMPassport();
        pp.setId(sPassport);
        CAM mycam = new CAM();
        mycam.setCAMPassport(pp);
        BiBusHeader header = new BiBusHeader();
        header.setCAM(mycam);
        return header;
    }

    private URL getDispatcherURL() {
        try {
            ICCLConfiguration x = CCLConfigurationFactory.getInstance();
            x.init();
            String value = x.getValue("internalDispatcher", false);
            return new URL(value);
        }
        catch (MalformedURLException mue) {
            throw new RuntimeException(mue);
        }
        catch (CCLConfigurationException mue) {
            throw new RuntimeException(mue);
        }
    }

    public static final String cmEncode(String searchPath) {
        return searchPath.replaceAll("'", "''");
    }

    public static final String getSearchPath(String storeID) {
        return "storeID('" + storeID + "')";
    }
}

