/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.metadataService.command;

import com.cognos.cclcfgapi.CCLConfigurationException;
import com.cognos.cclcfgapi.CCLConfigurationFactory;
import com.cognos.cclcfgapi.ICCLConfiguration;
import com.cognos.developer.schemas.bibus._3.BaseClass;
import com.cognos.developer.schemas.bibus._3.BaseClassArrayProp;
import com.cognos.developer.schemas.bibus._3.BiBusHeader;
import com.cognos.developer.schemas.bibus._3.CAM;
import com.cognos.developer.schemas.bibus._3.CAMPassport;
import com.cognos.developer.schemas.bibus._3.ContentManagerService_PortType;
import com.cognos.developer.schemas.bibus._3.ContentManagerService_ServiceLocator;
import com.cognos.developer.schemas.bibus._3.PropEnum;
import com.cognos.developer.schemas.bibus._3.QueryOptions;
import com.cognos.developer.schemas.bibus._3.Report;
import com.cognos.developer.schemas.bibus._3.SearchPathMultipleObject;
import com.cognos.developer.schemas.bibus._3.Sort;
import com.cognos.developer.schemas.bibus._3.StringProp;
import com.cognos.developer.schemas.bibus._3._package;
import com.cognos.metadataService.command.CommandFixtures;
import com.cognos.metadataService.command.CommandKey;
import com.cognos.metadataService.util.errors.MDSRVErrorCode;
import com.cognos.metadataService.util.errors.MDSRVErrorType;
import com.cognos.metadataService.util.errors.MDSRVException;
import com.cognos.mfw4j.framework.MFWRequestContext;
import com.cognos.pogo.async.AsyncContext;
import com.cognos.pogo.async.service.connection.IConnection;
import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.pogo.pdk.MessageContext;
import com.cognos.pogo.util.CROneCookie;
import java.io.Reader;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.rpc.ServiceException;
import org.apache.axis.client.Stub;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.io.SAXReader;
import org.xml.sax.SAXException;

public abstract class Command
implements IConnection {
    protected HashMap<CommandFixtures, Object> m_fixtures = new HashMap();
    protected CommandKey mCommandKey;
    public static final String SEARCH_PATH_SESSION = "~~";

    public void setFixtures(HashMap<CommandFixtures, Object> serviceParams) {
        this.m_fixtures = new HashMap();
        this.m_fixtures.putAll(serviceParams);
    }

    public boolean waitReceivedForRequest(MessageContext mc, AsyncContext ac) {
        return false;
    }

    public boolean getOutputForRequest(MessageContext mc) {
        return false;
    }

    public boolean release() {
        return false;
    }

    public boolean releaseRequest(MessageContext mc) {
        return false;
    }

    public boolean abandonRequest(MessageContext arg0, AsyncContext arg1) {
        return false;
    }

    public boolean cancelRequest(MessageContext arg0, AsyncContext arg1) {
        return false;
    }

    public void validate() {
    }

    public void cancel() {
    }

    public static MFWRequestContext MakeMFWReqContext(BIBusEnvelope soapEnvelope) {
        String cookieString = soapEnvelope.getCookieValue("CRN");
        CROneCookie aCookie = cookieString == null ? null : new CROneCookie(cookieString);
        MFWRequestContext aReqContext = MFWRequestContext.create((String)(aCookie == null ? "en" : (String)aCookie.getPreferences().get("productLocale")), (String)(aCookie == null ? "en" : (String)aCookie.getPreferences().get("contentLocale")), (String)soapEnvelope.getPassportID());
        Command.addNoLWM2RequestContext(aReqContext);
        return aReqContext;
    }

    public static void addNoLWM2RequestContext(MFWRequestContext aReqContext) {
        try {
            StringReader myReader = new StringReader("<noLWMCluster/>");
            SAXReader myParser = new SAXReader();
            myParser.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
            myParser.setFeature("http://xml.org/sax/features/external-general-entities", false);
            myParser.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            Document document = myParser.read((Reader)myReader);
            aReqContext.setConnectionSpec(document.getRootElement());
        }
        catch (DocumentException de) {
            throw new RuntimeException(de);
        }
        catch (SAXException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    private URL getDispatcherURL() {
        try {
            ICCLConfiguration x = CCLConfigurationFactory.getInstance();
            x.init();
            String value = x.getValue("internalDispatcher", false);
            return new URL(value);
        }
        catch (MalformedURLException mue) {
            throw new RuntimeException(mue);
        }
        catch (CCLConfigurationException mue) {
            throw new RuntimeException(mue);
        }
    }

    protected ContentManagerService_PortType getContentManagerServicePort() {
        String sPassport = this.mCommandKey.getRequest().getPassportID();
        if (sPassport == null) {
            throw new MDSRVException(MDSRVErrorType.SERVER, MDSRVErrorCode.MSR_API_MissingParameter, "m_passportID=CAMPAssport()");
        }
        try {
            CAMPassport pp = new CAMPassport();
            pp.setId(sPassport);
            CAM mycam = new CAM();
            mycam.setCAMPassport(pp);
            BiBusHeader header = new BiBusHeader();
            header.setCAM(mycam);
            ContentManagerService_ServiceLocator serviceLocator = new ContentManagerService_ServiceLocator();
            ContentManagerService_PortType port = null;
            port = serviceLocator.getcontentManagerService(this.getDispatcherURL());
            ((Stub)port).setHeader("http://developer.cognos.com/schemas/bibus/3/", "biBusHeader", (Object)header);
            ((Stub)port)._setProperty("sendMultiRefs", (Object)Boolean.FALSE);
            return port;
        }
        catch (ServiceException mue) {
            throw new RuntimeException(mue);
        }
    }

    protected String getPackagePathFromCM(String reportSearchPath) {
        try {
            PropEnum[] propArray = new PropEnum[]{PropEnum.defaultName, PropEnum.searchPath, PropEnum.metadataModel, PropEnum.metadataModelPackage};
            Sort[] sortOptions = new Sort[]{new Sort()};
            ContentManagerService_PortType portCM = this.getContentManagerServicePort();
            BaseClass[] results = portCM.query(new SearchPathMultipleObject(reportSearchPath), propArray, sortOptions, new QueryOptions());
            String packagePath = null;
            Report targetReport = null;
            String regex = "package\\[@name='[^']*'\\]";
            Pattern p = Pattern.compile(regex);
            for (int i = 0; i < results.length; ++i) {
                BaseClass baseClass = results[i];
                if (!(baseClass instanceof Report)) continue;
                targetReport = (Report)baseClass;
                break;
            }
            if (targetReport != null) {
                Matcher m;
                String modelPart;
                int index;
                BaseClass model;
                StringProp theModelSearchPath;
                String theModelSearchPathStr;
                BaseClassArrayProp baseClassArrayPropModel;
                BaseClass[] baseClassArrayModel;
                Matcher m2;
                BaseClass modelPackage;
                StringProp theModelPackageSearchPath;
                String theModelPackageSearchPathStr;
                BaseClassArrayProp baseClassArrayPropModelPackage = targetReport.getMetadataModelPackage();
                BaseClass[] baseClassArrayModelPackage = baseClassArrayPropModelPackage.getValue();
                if (baseClassArrayModelPackage.length > 0 && (theModelPackageSearchPathStr = (theModelPackageSearchPath = (modelPackage = baseClassArrayModelPackage[0]).getSearchPath()).getValue()) != null && theModelPackageSearchPathStr.length() > 0 && (m2 = p.matcher(theModelPackageSearchPathStr)).find()) {
                    packagePath = theModelPackageSearchPathStr;
                }
                if (packagePath == null && (baseClassArrayModel = (baseClassArrayPropModel = targetReport.getMetadataModel()).getValue()).length > 0 && (theModelSearchPathStr = (theModelSearchPath = (model = baseClassArrayModel[0]).getSearchPath()).getValue()) != null && theModelSearchPathStr.length() > 0 && (index = theModelSearchPathStr.indexOf(modelPart = "/model[@name='model']")) > 0 && (m = p.matcher(theModelSearchPathStr)).find()) {
                    packagePath = theModelSearchPathStr.substring(0, index);
                }
            }
            return packagePath;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    protected _package getPackageFromCM(String packageSearchPath) {
        try {
            PropEnum[] propArray = new PropEnum[]{PropEnum.searchPath, PropEnum.defaultName, PropEnum.routingHints, PropEnum.permissions, PropEnum.storeID, PropEnum.routingServerGroup};
            Sort[] sortOptions = new Sort[]{new Sort()};
            ContentManagerService_PortType portCM = this.getContentManagerServicePort();
            BaseClass[] results = portCM.query(new SearchPathMultipleObject(packageSearchPath), propArray, sortOptions, new QueryOptions());
            _package tpackage = null;
            for (int i = 0; i < results.length; ++i) {
                BaseClass baseClass = results[i];
                if (!(baseClass instanceof _package)) continue;
                tpackage = (_package)baseClass;
            }
            return tpackage;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }
}

