/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.metadataService.command;

import com.cognos.cclcfgapi.ICCLConfiguration;
import com.cognos.metadataService.command.Command;
import com.cognos.metadataService.command.CommandFixtures;
import com.cognos.metadataService.util.errors.MDSRVErrorCode;
import com.cognos.metadataService.util.errors.MDSRVErrorType;
import com.cognos.metadataService.util.errors.MDSRVException;
import com.cognos.pogo.pdk.Configuration;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.List;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;

public class CommandFactory {
    private static final String COMMANDS_FILE_RELATIVE_PATH = "../webapps/p2pd/WEB-INF/mdsrv/mdsrvCommands.xml";
    private static final String CLASS = "class";
    private static final String COMMANDID = "commandID";
    private static final String COMMAND = "command";
    private HashMap<String, Class<? extends Command>> m_commandMap = null;
    ICCLConfiguration m_configuration = null;

    public void configure(Configuration configuration) {
        this.m_configuration = configuration.getICCLConfiguration();
    }

    public Command getCommand(Element commandElem, HashMap<CommandFixtures, Object> serviceParams) {
        Class<? extends Command> commandClass;
        Command command = null;
        if (this.m_commandMap == null) {
            this.loadCommands();
        }
        if ((command = this.instantiateCommandClass(commandClass = this.getCommandClassForRequest(commandElem))) != null) {
            command.setFixtures(serviceParams);
        }
        return command;
    }

    private Class<? extends Command> getCommandClassForRequest(Element requestBodyRootElem) {
        if (requestBodyRootElem == null) {
            throw new MDSRVException(MDSRVErrorType.CLIENT, MDSRVErrorCode.MSR_API_MissingParameter, "BIBus request body");
        }
        String commandName = requestBodyRootElem.getName();
        Class<? extends Command> commandClass = this.m_commandMap.get(commandName);
        return commandClass;
    }

    private Command instantiateCommandClass(Class<? extends Command> commandClass) {
        Command command = null;
        if (commandClass != null) {
            try {
                command = commandClass.newInstance();
            }
            catch (InstantiationException instantiationException) {
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
        return command;
    }

    private void loadCommands() {
        this.m_commandMap = new HashMap();
        SAXReader saxReader = new SAXReader();
        String resolvedPath = this.m_configuration.resolveEffectivePath(COMMANDS_FILE_RELATIVE_PATH);
        File commandsFile = new File(resolvedPath);
        FileInputStream commandsFileInputStream = null;
        Element commandsRootElem = null;
        try {
            saxReader.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
            saxReader.setFeature("http://xml.org/sax/features/external-general-entities", false);
            saxReader.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            commandsFileInputStream = new FileInputStream(commandsFile);
            Document fileDoc = saxReader.read((InputStream)commandsFileInputStream);
            commandsRootElem = fileDoc.getRootElement();
        }
        catch (Exception e) {
            throw new MDSRVException(MDSRVErrorType.SERVER, MDSRVErrorCode.MSR_MSR_CommandFolderNotFound, e);
        }
        List commandNodes = commandsRootElem.elements(COMMAND);
        for (Element commandNode : commandNodes) {
            Node commandIDNode = commandNode.selectSingleNode(COMMANDID);
            Node commandClassNode = commandNode.selectSingleNode(CLASS);
            if (commandIDNode == null || commandClassNode == null) continue;
            String commandID = ((Element)commandIDNode).getText();
            String commandClassName = ((Element)commandClassNode).getText();
            Class<? extends Command> commandClass = this.loadCommandClass(commandClassName);
            if (commandClass == null) continue;
            this.m_commandMap.put(commandID, commandClass);
        }
    }

    private Class<? extends Command> loadCommandClass(String commandClassName) {
        Class<?> commandClass = null;
        try {
            Class<?> thisClass = this.getClass();
            ClassLoader classLoader = thisClass.getClassLoader();
            commandClass = Class.forName(commandClassName, true, classLoader);
        }
        catch (ClassNotFoundException thisClass) {
            // empty catch block
        }
        if (commandClass != null && !Command.class.isAssignableFrom(commandClass)) {
            commandClass = null;
        }
        if (commandClass != null) {
            Constructor<?>[] constructors = commandClass.getConstructors();
            boolean isBlankConstructorAccessible = false;
            for (int constructorIdx = 0; !isBlankConstructorAccessible && constructorIdx < constructors.length; ++constructorIdx) {
                Constructor<?> constructor = constructors[constructorIdx];
                if (constructor.getParameterTypes().length != 0) continue;
                isBlankConstructorAccessible = true;
            }
            if (!isBlankConstructorAccessible) {
                commandClass = null;
            }
        }
        Class<?> retVal = commandClass;
        return retVal;
    }
}

