/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.metadataService.command;

import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.pogo.pdk.MessageContext;
import com.cognos.pogo.util.CROneCookie;
import java.io.Reader;
import java.io.StringReader;
import java.util.List;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;
import org.xml.sax.SAXException;

public class CommandKey {
    Element m_commandElem;
    boolean m_isAsync = false;
    BIBusEnvelope m_request;
    BIBusEnvelope m_response;
    String m_contentLocale;
    String m_productLocale;

    public CommandKey(MessageContext mc) {
        this.m_request = (BIBusEnvelope)mc.getProperty("request.envelope");
        this.m_response = (BIBusEnvelope)mc.getProperty("response.envelope");
        Element requestElementBody = this.m_request.getBody();
        this.m_commandElem = CommandKey.getFirstChildElement(requestElementBody);
        if (this.m_commandElem != null) {
            String commandElemName = this.m_commandElem.getName();
            boolean bl = this.m_isAsync = commandElemName.equals("runSpecification") || commandElemName.equals("wait") || commandElemName.equals("cancel") || commandElemName.equals("release");
            if (this.m_isAsync) {
                this.m_commandElem = CommandKey.getCommandElemForAsyncRequest(this.m_commandElem);
            }
        }
        CROneCookie crnCookie = this.getRequestCookie();
        Object _contentLocale = null;
        Object _productLocale = null;
        if (crnCookie != null) {
            _contentLocale = crnCookie.getPreferences().get("contentLocale");
            _productLocale = crnCookie.getPreferences().get("productLocale");
        }
        this.m_contentLocale = _contentLocale != null ? _contentLocale.toString() : "en";
        this.m_productLocale = _productLocale != null ? _productLocale.toString() : this.m_contentLocale;
    }

    public Element getCommandElem() {
        return this.m_commandElem;
    }

    public BIBusEnvelope getRequest() {
        return this.m_request;
    }

    public Element getRequestParameterValues() {
        Element parametersElem = null;
        Node paramNode = this.m_request.getBody().selectSingleNode("./*[local-name()='runSpecification']/parameterValues");
        if (paramNode != null) {
            parametersElem = (Element)paramNode;
        }
        return parametersElem;
    }

    public CROneCookie getRequestCookie() {
        String cookieString = this.m_request.getCookieValue("CRN");
        return cookieString == null ? null : new CROneCookie(cookieString);
    }

    public String getLocale() {
        return this.m_contentLocale;
    }

    public String getContentLocale() {
        return this.m_contentLocale;
    }

    public String getProductLocale() {
        return this.m_productLocale;
    }

    public BIBusEnvelope getResponse() {
        return this.m_response;
    }

    public boolean isAsync() {
        return this.m_isAsync;
    }

    private static Element getFirstChildElement(Element parentElem) {
        Element firstChildElem = null;
        List elements = parentElem.elements();
        if (elements.size() > 0) {
            firstChildElem = (Element)elements.get(0);
        }
        return firstChildElem;
    }

    private static Element getCommandElemForAsyncRequest(Element asyncCommandElem) {
        Element valueElem;
        Element commandElem = null;
        Element specificationElem = asyncCommandElem.element("specification");
        if (specificationElem != null && (valueElem = specificationElem.element("value")) != null) {
            String value = valueElem.getText();
            SAXReader saxReader = new SAXReader();
            try {
                saxReader.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
                saxReader.setFeature("http://xml.org/sax/features/external-general-entities", false);
                saxReader.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
                StringReader valueReader = new StringReader(value);
                Document requestDoc = saxReader.read((Reader)valueReader);
                commandElem = requestDoc.getRootElement();
            }
            catch (DocumentException valueReader) {
            }
            catch (SAXException e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        }
        return commandElem;
    }
}

