/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.metadataService.command.fmEdit;

import com.cognos.metadataService.command.Command;
import com.cognos.metadataService.command.CommandKey;
import com.cognos.metadataService.command.fmEdit.FmModelEditor;
import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.pogo.pdk.MessageContext;
import org.dom4j.DocumentFactory;
import org.dom4j.Element;

public class CommandFmEdit
extends Command {
    private CommandKey m_commandKey;

    public boolean invokeRequest(MessageContext mc) {
        this.m_commandKey = new CommandKey(mc);
        Element fmEdit = this.m_commandKey.getCommandElem();
        if (fmEdit == null) {
            return false;
        }
        this.processBatchEdits(fmEdit);
        this.buildResponse(mc);
        return true;
    }

    private void buildResponse(MessageContext mc) {
        DocumentFactory fac = new DocumentFactory();
        Element elmResponse = fac.createElement("output");
        elmResponse.addElement("status").addText("success");
        BIBusEnvelope soapResponse = new BIBusEnvelope();
        soapResponse.getBody().add(elmResponse);
        mc.setProperty("response.envelope", (Object)soapResponse);
    }

    private void processBatchEdits(Element fmEdit) {
        FmModelEditor editor = new FmModelEditor();
        for (Object child : fmEdit.elements()) {
            Element node = (Element)child;
            String tagName = node.getName();
            FmEditTag tag = FmEditTag.valueOf(tagName);
            switch (tag) {
                case model: {
                    this.processModel(editor, node);
                    break;
                }
                case setValue: {
                    this.processSetValue(editor, node);
                }
            }
        }
        editor.saveToContentManager(this.m_commandKey.getRequest());
    }

    private void processModel(FmModelEditor editor, Element element) {
        editor.loadModel(element.getText(), this.m_commandKey.getRequest());
    }

    private void processSetValue(FmModelEditor editor, Element setValueNode) {
        Element xpath = (Element)setValueNode.selectSingleNode("xpath");
        Element value = (Element)setValueNode.selectSingleNode("value");
        editor.setNodeValue(xpath.getText(), value.getText());
    }

    static enum FmEditTag {
        model,
        setValue;

    }
}

