/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.metadataService.command.fmEdit;

import com.cognos.cclcfgapi.CCLConfigurationException;
import com.cognos.cclcfgapi.CCLConfigurationFactory;
import com.cognos.cclcfgapi.ICCLConfiguration;
import com.cognos.developer.schemas.bibus._3.AnyTypeMIMEProp;
import com.cognos.developer.schemas.bibus._3.BaseClass;
import com.cognos.developer.schemas.bibus._3.BiBusHeader;
import com.cognos.developer.schemas.bibus._3.ContentManagerService_PortType;
import com.cognos.developer.schemas.bibus._3.ContentManagerService_ServiceLocator;
import com.cognos.developer.schemas.bibus._3.DeleteOptions;
import com.cognos.developer.schemas.bibus._3.EncodingEnum;
import com.cognos.developer.schemas.bibus._3.Model;
import com.cognos.developer.schemas.bibus._3.PropEnum;
import com.cognos.developer.schemas.bibus._3.QueryOptions;
import com.cognos.developer.schemas.bibus._3.SearchPathMultipleObject;
import com.cognos.developer.schemas.bibus._3.UpdateOptions;
import com.cognos.metadataService.ui.MessageHelper;
import com.cognos.metadataService.ui.exceptions.UIException;
import com.cognos.mfw4j.utilities.MFWBiBusHelper;
import com.cognos.mfw4j.utilities.MFWContentHelper;
import com.cognos.pogo.pdk.BIBusEnvelope;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.net.MalformedURLException;
import java.net.URL;
import java.rmi.RemoteException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.GZIPOutputStream;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.xml.rpc.ServiceException;
import org.apache.axis.attachments.AttachmentPart;
import org.apache.axis.attachments.OctetStream;
import org.apache.axis.attachments.OctetStreamDataSource;
import org.apache.axis.client.Stub;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;
import org.dom4j.io.XMLWriter;
import org.dom4j.xpath.DefaultXPath;
import org.jaxen.NamespaceContext;
import org.jaxen.SimpleNamespaceContext;
import org.xml.sax.SAXException;

public class FmModelEditor {
    private Document m_model;
    private String m_modelPath;
    private MessageHelper m_messageHelper;

    public void saveToContentManager(BiBusHeader header) {
        ContentManagerService_PortType cmService = this.getCMSerivce(header);
        Model model = null;
        AnyTypeMIMEProp mimeProp = new AnyTypeMIMEProp();
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        try {
            BaseClass[] models = cmService.query(new SearchPathMultipleObject(this.m_modelPath), new PropEnum[0], null, new QueryOptions());
            model = (Model)models[0];
            GZIPOutputStream stream = new GZIPOutputStream(outStream);
            XMLWriter writer = new XMLWriter((OutputStream)stream);
            writer.write(this.m_model.getDocument());
            writer.flush();
            writer.close();
            stream.flush();
            stream.close();
            OctetStream aStream = new OctetStream(outStream.toByteArray());
            OctetStreamDataSource ds = new OctetStreamDataSource("somename", aStream);
            DataHandler dh = new DataHandler((DataSource)ds);
            AttachmentPart attachment = new AttachmentPart(dh);
            attachment.setMimeHeader("Content-Encoding", "gzip");
            ((Stub)cmService).addAttachment((Object)attachment);
            mimeProp.setValue("[attribute]" + attachment.getContentIdRef());
            model.setModel(mimeProp);
            UpdateOptions updateOptions = new UpdateOptions();
            BaseClass[] objects = new BaseClass[]{model};
            BaseClass[] baseClassArray = cmService.update(objects, updateOptions);
        }
        catch (IOException io) {
            throw new RuntimeException(io.getMessage(), io);
        }
    }

    public void saveToContentManager(BIBusEnvelope envelope) {
        int modelIdx = this.m_modelPath.lastIndexOf("/model");
        BiBusHeader header = MFWBiBusHelper.buildBiBusHeaderFrom((BIBusEnvelope)envelope);
        this.saveToContentManager(header);
    }

    private ContentManagerService_PortType getCMSerivce(BiBusHeader header) {
        try {
            ICCLConfiguration config = CCLConfigurationFactory.getInstance();
            config.init();
            String url = config.getValue("internalDispatcher", false);
            ContentManagerService_ServiceLocator cmServiceLocator = new ContentManagerService_ServiceLocator();
            cmServiceLocator.getEngine().setOption("sendMultiRefs", (Object)Boolean.FALSE);
            ContentManagerService_PortType cmService = cmServiceLocator.getcontentManagerService(new URL(url));
            ((Stub)cmService).setHeader("http://developer.cognos.com/schemas/bibus/3/", "biBusHeader", (Object)header);
            return cmService;
        }
        catch (CCLConfigurationException cce) {
            throw new RuntimeException(cce.getMessage(), cce);
        }
        catch (ServiceException se) {
            throw new RuntimeException(se.getMessage(), se);
        }
        catch (MalformedURLException mu) {
            throw new RuntimeException(mu.getMessage(), mu);
        }
    }

    private void deleteAllModelsInPackage(String cmPackagePath, ContentManagerService_PortType cmService) {
        String searchPath = cmPackagePath + "/model";
        PropEnum[] propArray = new PropEnum[]{PropEnum.searchPath};
        QueryOptions queryOpts = new QueryOptions();
        queryOpts.setPermission("read");
        queryOpts.setSchemaInfo(false);
        queryOpts.setMaxObjects(BigInteger.valueOf(0L));
        queryOpts.setSkipObjects(BigInteger.valueOf(0L));
        queryOpts.setDataEncoding(EncodingEnum.base64);
        queryOpts.setMaxDataBytes(BigInteger.valueOf(0L));
        queryOpts.setSkipDataBytes(BigInteger.valueOf(0L));
        try {
            BaseClass[] models = cmService.query(new SearchPathMultipleObject(searchPath), propArray, null, queryOpts);
            if (models.length > 0) {
                DeleteOptions deleteOpt = new DeleteOptions();
                deleteOpt.setForce(true);
                deleteOpt.setRecursive(true);
                cmService.delete(models, deleteOpt);
            }
        }
        catch (RemoteException re) {
            throw new RuntimeException(re.getMessage(), re);
        }
    }

    public void loadModel(String modelPath, BIBusEnvelope envelope) {
        MFWContentHelper contentHelper = MFWContentHelper.create((String)"", (String)"", (String)"", (BIBusEnvelope)envelope);
        try {
            Document document;
            InputStream stream = contentHelper.queryPackage(modelPath);
            SAXReader reader = new SAXReader();
            reader.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
            reader.setFeature("http://xml.org/sax/features/external-general-entities", false);
            reader.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            this.m_model = document = reader.read(stream);
            this.m_modelPath = modelPath;
        }
        catch (DocumentException dte) {
            throw new RuntimeException(dte.getMessage(), dte);
        }
        catch (SAXException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public void setNodeValue(String xpath, String value) {
        Node node = this.selectSingleNode((Node)this.m_model, xpath);
        node.setText(value);
    }

    public Node selectSingleNode(Node node, String xpath) {
        Pattern p = Pattern.compile("(document|evaluate)\\s*\\(");
        Matcher m = p.matcher(xpath);
        if (m.find()) {
            throw new UIException(this.m_messageHelper.getMessage("MSR_LIN_MaliciousXPath"));
        }
        SimpleNamespaceContext context = new SimpleNamespaceContext();
        context.addNamespace("bus", node.getDocument().getRootElement().getNamespaceURI());
        DefaultXPath path = new DefaultXPath(xpath);
        path.setNamespaceContext((NamespaceContext)context);
        Node n = path.selectSingleNode((Object)node);
        return n;
    }
}

