/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.metadataService.command.lineage;

import com.cognos.metadataService.command.Command;
import com.cognos.metadataService.command.CommandKey;
import com.cognos.metadataService.command.api.ser.DomSerializer;
import com.cognos.metadataService.command.lineage.adapters.request.MfwGatewayFactory;
import com.cognos.metadataService.command.lineage.adapters.request.ObjectQuery;
import com.cognos.metadataService.command.lineage.adapters.request.Request;
import com.cognos.metadataService.command.lineage.adapters.response.ResponseSerializer;
import com.cognos.metadataService.command.lineage.algorithm.ContextTraversal;
import com.cognos.metadataService.command.lineage.algorithm.EmbeddedObjectTraversal;
import com.cognos.metadataService.command.lineage.algorithm.IMfwLineageConnection;
import com.cognos.metadataService.command.lineage.algorithm.Mediator;
import com.cognos.metadataService.command.lineage.algorithm.TransformationTraversal;
import com.cognos.metadataService.command.lineage.api.client.LineageRequest;
import com.cognos.metadataService.command.lineage.api.client.LineageResponse;
import com.cognos.metadataService.command.lineage.api.client.QuerySetParser;
import com.cognos.metadataService.command.lineage.api.interfaces.ILineageObjectQuery;
import com.cognos.metadataService.command.lineage.api.interfaces.ILineageResponse;
import com.cognos.metadataService.sources.contentmanager.CMQuery;
import com.cognos.metadataService.util.logging.MDSRVLogUtil;
import com.cognos.metadataService.util.logging.ServicePerfMarker;
import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.pogo.pdk.MessageContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.dom4j.Element;

public class LineageCommand
extends Command {
    MfwGatewayFactory m_mfwGatewayFactory = new MfwGatewayFactory();
    IMfwLineageConnection m_connection;

    public boolean invokeRequest(MessageContext mc) {
        Element elemFullResponse;
        Element elemOrigLineageRequest;
        CommandKey commandKey = new CommandKey(mc);
        Element commandElem = commandKey.getCommandElem();
        String asXML = commandElem.asXML();
        String trimmed = asXML.trim();
        ServicePerfMarker perfMarker = new ServicePerfMarker(this.getClass().getName() + "invokeRequest: " + trimmed, "BEGIN");
        boolean bFault = false;
        Element elemLineageRequest = elemOrigLineageRequest = commandElem;
        LineageRequest m_lineageRequest = new LineageRequest();
        m_lineageRequest.buildFromInstanceElem(elemOrigLineageRequest);
        QuerySetParser m_parserQuerySet = new QuerySetParser(m_lineageRequest);
        List<Object> elemLineageRequests = new ArrayList<Element>();
        if (m_lineageRequest.isUsingQuerySet()) {
            m_parserQuerySet.setContentLocale(commandKey.getLocale());
            m_parserQuerySet.parse();
            elemLineageRequests = m_parserQuerySet.getModelLineageRequestElems();
        } else {
            elemLineageRequests.add(elemOrigLineageRequest);
        }
        ArrayList<ILineageResponse> iResponses = new ArrayList<ILineageResponse>();
        if (!m_lineageRequest.isUsingQuerySet() || m_parserQuerySet.getModelObjectRefs().size() != 0) {
            for (Element element : elemLineageRequests) {
                ILineageResponse resp = this.processRequest(element, commandKey);
                iResponses.add(resp);
            }
        }
        if (m_lineageRequest.isUsingQuerySet()) {
            LineageResponse lineageResponse = m_parserQuerySet.getQueryLineageResponse();
            for (ILineageResponse resp : iResponses) {
                lineageResponse.addObjects(resp);
            }
            elemFullResponse = lineageResponse.dumpToParentElem(null);
        } else {
            ResponseSerializer responseSerializer = new ResponseSerializer(new DomSerializer());
            elemFullResponse = (Element)responseSerializer.serialize((ILineageResponse)iResponses.get(0)).getElemObj();
        }
        BIBusEnvelope bIBusEnvelope = new BIBusEnvelope();
        bIBusEnvelope.getBody().add(elemFullResponse);
        mc.setProperty("response.envelope", (Object)bIBusEnvelope);
        perfMarker.endPerf();
        return bFault;
    }

    private ILineageResponse processRequest(Element elemLineageRequest, CommandKey commandKey) {
        Request request = new Request(elemLineageRequest);
        CMQuery cmQuery = new CMQuery((Element)commandKey.getRequest().getBIBusHeader().clone(), commandKey.getRequestCookie());
        request.bind(cmQuery, commandKey.getRequest().getPassportID(), this.m_mfwGatewayFactory, commandKey.getRequestParameterValues(), this.m_fixtures);
        this.m_connection = (IMfwLineageConnection)request.getConnection();
        Mediator mediator = new Mediator(this.m_connection, new TransformationTraversal(), new ContextTraversal(), new EmbeddedObjectTraversal());
        Collection<ILineageObjectQuery> objectQueryList = request.getObjectQueryList();
        for (ObjectQuery objectQuery : objectQueryList) {
            mediator.runObjectQuery(objectQuery);
        }
        return mediator.getResponse();
    }

    @Override
    public void cancel() {
        this.release();
    }

    public boolean cancelRequest(MessageContext mc) {
        this.cancel();
        return false;
    }

    @Override
    public boolean release() {
        try {
            if (this.m_connection != null) {
                this.m_connection.close();
            }
        }
        catch (Exception e) {
            MDSRVLogUtil.getLogUtilInstance().unexpectedHandledException("Error occured when trying to close connections: ", e);
        }
        return false;
    }

    @Override
    public boolean releaseRequest(MessageContext mc) {
        return this.release();
    }
}

