/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.metadataService.command.lineage.adapters.request;

import com.cognos.developer.schemas.bibus._3.Analysis;
import com.cognos.developer.schemas.bibus._3.Model;
import com.cognos.developer.schemas.bibus._3.Output;
import com.cognos.developer.schemas.bibus._3.PropEnum;
import com.cognos.developer.schemas.bibus._3.Query;
import com.cognos.developer.schemas.bibus._3.Report;
import com.cognos.developer.schemas.bibus._3.ReportVersion;
import com.cognos.developer.schemas.bibus._3.ReportView;
import com.cognos.developer.schemas.bibus._3._package;
import com.cognos.metadataService.command.CommandFixtures;
import com.cognos.metadataService.command.lineage.adapters.request.IMfwGatewayFactory;
import com.cognos.metadataService.command.lineage.adapters.response.MfwLineageQuery;
import com.cognos.metadataService.command.lineage.algorithm.IMfwLineageConnection;
import com.cognos.metadataService.command.lineage.api.interfaces.ILineageParam;
import com.cognos.metadataService.command.lineage.source.contentmanager.CMAccessStrategyAuthoredReport;
import com.cognos.metadataService.command.lineage.source.contentmanager.CMAccessStrategyModel;
import com.cognos.metadataService.command.lineage.source.contentmanager.CMAccessStrategyPackage;
import com.cognos.metadataService.command.lineage.source.contentmanager.CMAccessStrategyReportVersion;
import com.cognos.metadataService.command.lineage.source.contentmanager.CMAccessStrategyReportVersionOutput;
import com.cognos.metadataService.command.lineage.source.contentmanager.CMAccessStrategyReportView;
import com.cognos.metadataService.command.lineage.source.contentmanager.ICMAccess;
import com.cognos.metadataService.sources.contentmanager.CMObject;
import com.cognos.metadataService.sources.contentmanager.CMQuery;
import com.cognos.metadataService.sources.mfw.ContentManagerMetadataSourceRetrieval;
import com.cognos.metadataService.sources.mfw.IModelRoots;
import com.cognos.metadataService.sources.mfw.LocalizedSchemaValues;
import com.cognos.metadataService.sources.mfw.MetadataSourceBuilder;
import com.cognos.metadataService.sources.mfw.ModelRoots;
import com.cognos.metadataService.sources.mfw.MultilingualPropertyTranslater;
import com.cognos.metadataService.sources.mfw.RequestContextBuilder;
import com.cognos.metadataService.util.errors.MDSRVErrorCode;
import com.cognos.metadataService.util.errors.MDSRVErrorType;
import com.cognos.metadataService.util.errors.MDSRVException;
import com.cognos.mfw4j.framework.MFWGateway;
import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.pogo.pdk.MessageContext;
import com.cognos.pogo.reportservice.RequestInvoker;
import java.util.Collection;
import java.util.HashMap;
import org.dom4j.Element;

public class Connection
implements IMfwLineageConnection {
    ICMAccess m_cmStrategy;
    MFWGateway m_mfwGateway;
    String m_passport;
    HashMap<String, ILineageParam> m_params = new HashMap();
    ModelRoots m_modelRoots;
    MfwLineageQuery m_lineageObjectFactory;
    LocalizedSchemaValues m_localizedSchemaValues;
    MultilingualPropertyTranslater m_multilingualPropertyTranslater;

    @Override
    public void addParam(ILineageParam param) {
        this.m_params.put(param.getName(), param);
    }

    @Override
    public Collection<ILineageParam> getParamList() {
        return this.m_params.values();
    }

    @Override
    public ILineageParam getParam(String name) {
        return this.m_params.get(name);
    }

    public void bind(CMQuery cmQuery, IMfwGatewayFactory mfwGatewayFactory, String passport, Element parametersElem, HashMap<CommandFixtures, Object> fixtures) {
        this.m_cmStrategy = this.buildCmStrategy(cmQuery);
        RequestInvoker requestInvoker = (RequestInvoker)fixtures.get(CommandFixtures.MDPROVIDERREQUESTINVOKER);
        MessageContext context = (MessageContext)fixtures.get(CommandFixtures.MESSAGECONTEXT);
        BIBusEnvelope request = null;
        if (context != null) {
            request = (BIBusEnvelope)context.getProperty("request.envelope");
        }
        String gatewayId = "mdsrvLineage---" + this.m_cmStrategy.getMetadataSourceObject().getSearchPath() + "---" + passport;
        MetadataSourceBuilder metadataSourceBuilder = new MetadataSourceBuilder(this.m_cmStrategy.getMetadataSourceObject());
        RequestContextBuilder requestContextBuilder = new RequestContextBuilder(passport, cmQuery.getProductLocale(), cmQuery.getContentLocale(), parametersElem, requestInvoker, request);
        this.m_mfwGateway = mfwGatewayFactory.buildGateway(gatewayId, requestContextBuilder.getRequestContext(), metadataSourceBuilder.getMetadataSource());
        this.m_localizedSchemaValues = new LocalizedSchemaValues(this.m_mfwGateway.getContext().getProductLocale());
        this.m_modelRoots = new ModelRoots(this.m_mfwGateway);
        ContentManagerMetadataSourceRetrieval cmSourceRetrieval = new ContentManagerMetadataSourceRetrieval();
        this.m_cmStrategy.update(cmSourceRetrieval.getSearchPaths(this.m_mfwGateway, this.m_modelRoots));
        this.m_multilingualPropertyTranslater = new MultilingualPropertyTranslater(this.m_mfwGateway, this.m_modelRoots);
        this.m_lineageObjectFactory = new MfwLineageQuery(this.m_mfwGateway, this.m_localizedSchemaValues, this.m_multilingualPropertyTranslater);
    }

    ICMAccess buildCmStrategy(CMQuery cmQuery) {
        ILineageParam searchPathParam = this.getParam("searchPath");
        if (searchPathParam == null) {
            throw new MDSRVException(MDSRVErrorType.CLIENT, MDSRVErrorCode.MSR_API_MissingParameter, PropEnum.searchPath.getValue());
        }
        CMObject cmObj = cmQuery.querySingleObj(searchPathParam.getValue(), new PropEnum[]{PropEnum.storeID, PropEnum.searchPath, PropEnum.objectClass, PropEnum.defaultName, PropEnum.parent});
        if (cmObj == null) {
            throw new MDSRVException(MDSRVErrorType.CLIENT, MDSRVErrorCode.MSR_LIN_ModelConnectError, searchPathParam.getValue());
        }
        ICMAccess cmStrategy = null;
        if (cmObj.isAxisType(Report.class) || cmObj.isAxisType(Analysis.class) || cmObj.isAxisType(Query.class)) {
            cmStrategy = new CMAccessStrategyAuthoredReport(cmObj.getSearchPath(), cmObj.getSourceQuery());
        } else if (cmObj.isAxisType(ReportView.class)) {
            cmStrategy = new CMAccessStrategyReportView(cmObj.getSearchPath(), cmObj.getSourceQuery());
        } else if (cmObj.isAxisType(Model.class)) {
            cmStrategy = new CMAccessStrategyModel(cmObj.getSearchPath(), cmObj.getSourceQuery());
        } else if (cmObj.isAxisType(_package.class)) {
            cmStrategy = new CMAccessStrategyPackage(cmObj.getSearchPath(), cmObj.getSourceQuery());
        } else if (cmObj.isAxisType(ReportVersion.class)) {
            cmStrategy = new CMAccessStrategyReportVersion(cmObj.getSearchPath(), cmObj.getSourceQuery());
        } else if (cmObj.isAxisType(Output.class)) {
            cmStrategy = new CMAccessStrategyReportVersionOutput(cmObj.getSearchPath(), cmObj.getSourceQuery());
        } else {
            throw new MDSRVException(MDSRVErrorType.CLIENT, MDSRVErrorCode.MSR_API_InvalidParameter, cmObj.getSearchPath(), "cmSearchPath");
        }
        return cmStrategy;
    }

    @Override
    public void close() {
        if (this.m_mfwGateway != null) {
            this.m_mfwGateway.close();
        }
    }

    @Override
    public MFWGateway getMfwGateway() {
        return this.m_mfwGateway;
    }

    @Override
    public ICMAccess getCmAccessStrategy() {
        return this.m_cmStrategy;
    }

    @Override
    public MfwLineageQuery getLineageObjectFactory() {
        return this.m_lineageObjectFactory;
    }

    @Override
    public LocalizedSchemaValues getLocalizedSchemaValues() {
        return this.m_localizedSchemaValues;
    }

    @Override
    public MultilingualPropertyTranslater getMultilingualPropertyTranslater() {
        return this.m_multilingualPropertyTranslater;
    }

    @Override
    public IModelRoots getModelRoots() {
        return this.m_modelRoots;
    }
}

