/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.metadataService.command.lineage.adapters.request;

import com.cognos.metadataService.command.lineage.adapters.request.ParamContainer;
import com.cognos.metadataService.command.lineage.adapters.response.IMfwLineageObject;
import com.cognos.metadataService.command.lineage.adapters.response.LineageObjectId;
import com.cognos.metadataService.command.lineage.adapters.response.MfwLineageQuery;
import com.cognos.metadataService.command.lineage.algorithm.IMfwLineageConnection;
import com.cognos.metadataService.command.lineage.api.client.QueryResult;
import com.cognos.metadataService.command.lineage.api.client.QuerySetIDHelper;
import com.cognos.metadataService.command.lineage.api.interfaces.ILineageObjectQuery;
import com.cognos.metadataService.command.lineage.api.interfaces.ILineageParam;
import com.cognos.metadataService.command.lineage.source.model.MfwLineageExpression;
import com.cognos.metadataService.sources.mfw.PropertyNodeRetrieval;
import com.cognos.metadataService.util.errors.MDSRVErrorCode;
import com.cognos.metadataService.util.errors.MDSRVErrorType;
import com.cognos.metadataService.util.errors.MDSRVException;
import com.cognos.mfw4j.framework.MFWGateway;
import com.cognos.mfw4j.framework.MFWModelRes;
import com.cognos.mfw4j.framework.MFWNodeHandle;
import com.cognos.xqe.ast.v5Exp.uniqueName.IV5UniqueNamePiece;
import com.cognos.xqe.ast.v5Exp.uniqueName.adapters.V5UniqueNamePartNameValue;
import com.cognos.xqe.ast.v5Exp.uniqueName.adapters.V5UniqueNamePartPartValue;
import com.cognos.xqe.ast.v5Exp.uniqueName.adapters.V5UniqueNamePieceNamePartList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Vector;

public class ObjectQuery
implements ILineageObjectQuery {
    String m_id;
    ParamContainer m_paramContainer = new ParamContainer();
    Collection<IMfwLineageObject> m_referencedObjects = new Vector<IMfwLineageObject>();

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        ObjectQuery objQuery = (ObjectQuery)obj;
        boolean bEquals = false;
        ILineageParam modelItemRef = this.getParam("modelItemRef");
        if (modelItemRef != null) {
            bEquals = this.getParam("modelItemRef").equals(objQuery.getParam("modelItemRef"));
        } else {
            boolean bEqualQuery = this.getParam("queryName").equals(objQuery.getParam("queryName"));
            boolean bEqualItem = this.getParam("dataItemName").equals(objQuery.getParam("dataItemName"));
            bEquals = bEqualQuery & bEqualItem;
        }
        return bEquals;
    }

    public int hashCode() {
        int hash = 31;
        ILineageParam modelItemRef = this.getParam("modelItemRef");
        hash = modelItemRef != null ? (hash *= this.getParam("modelItemRef").hashCode()) : hash * this.getParam("queryName").hashCode() + this.getParam("dataItemName").hashCode();
        return hash;
    }

    public boolean containsDataItem(String sQueryName, String sDataItemName) {
        String sQuery = this.getParam("queryName").getValue();
        String sDataItem = this.getParam("dataItemName").getValue();
        boolean bContains = sQueryName.equals(sQuery) && sDataItemName.equals(sDataItem);
        return bContains;
    }

    @Override
    public String getId() {
        return this.m_id;
    }

    @Override
    public void setId(String id) {
        this.m_id = id;
    }

    @Override
    public void addParam(ILineageParam param) {
        this.m_paramContainer.addParam(param);
    }

    @Override
    public Collection<ILineageParam> getParamList() {
        return this.m_paramContainer.getParamList();
    }

    @Override
    public ILineageParam getParam(String name) {
        return this.m_paramContainer.getParam(name);
    }

    public void bind(IMfwLineageConnection connection) {
        ILineageParam expressionParam = this.getParam("modelItemRef");
        if (expressionParam != null) {
            String expression = null;
            expression = expressionParam.getValue();
            if (expression == null) {
                throw new MDSRVException(MDSRVErrorType.CLIENT, MDSRVErrorCode.MSR_API_MissingParameter, "objectQuery");
            }
            MfwLineageQuery lineageObjectFactory = connection.getLineageObjectFactory();
            MfwLineageExpression expressionParser = new MfwLineageExpression(lineageObjectFactory, expression);
            this.m_referencedObjects = expressionParser.getReferencedObjects();
            if (this.m_referencedObjects.size() == 0) {
                throw new MDSRVException(MDSRVErrorType.CLIENT, MDSRVErrorCode.MSR_API_InvalidParameter, expression, "objectQuery");
            }
        } else {
            ILineageParam queryParam = this.getParam("queryName");
            if (queryParam == null) {
                throw new MDSRVException(MDSRVErrorType.CLIENT, MDSRVErrorCode.MSR_API_MissingParameter, "objectQuery");
            }
            String query = queryParam.getValue();
            ILineageParam queryItemParam = this.getParam("dataItemName");
            if (queryItemParam != null) {
                String queryItem = queryItemParam.getValue();
                MFWGateway mfwGateway = connection.getMfwGateway();
                MFWNodeHandle node = connection.getModelRoots().getRootNamespaceNode();
                PropertyNodeRetrieval nodeRetrieval = new PropertyNodeRetrieval(mfwGateway, node, MFWModelRes.getInstance().RID_ID);
                String idPartValue = nodeRetrieval.getValue();
                V5UniqueNamePartPartValue rootNamespaceId = new V5UniqueNamePartPartValue(idPartValue);
                ArrayList<Object> modelObjectIdParts = new ArrayList<Object>();
                modelObjectIdParts.add(rootNamespaceId);
                V5UniqueNamePartNameValue queryNamePart = new V5UniqueNamePartNameValue(query);
                modelObjectIdParts.add(queryNamePart);
                V5UniqueNamePartNameValue queryItemNamePart = new V5UniqueNamePartNameValue(queryItem);
                modelObjectIdParts.add(queryItemNamePart);
                MfwLineageQuery lineageQuery = new MfwLineageQuery(mfwGateway, connection.getLocalizedSchemaValues(), connection.getMultilingualPropertyTranslater());
                V5UniqueNamePieceNamePartList modelObjectIdNamedReference = new V5UniqueNamePieceNamePartList(modelObjectIdParts);
                LineageObjectId modelObjectId = new LineageObjectId((IV5UniqueNamePiece)modelObjectIdNamedReference);
                IMfwLineageObject lineageObject = lineageQuery.query(modelObjectId);
                if (lineageObject != null) {
                    this.m_referencedObjects.add(lineageObject);
                }
            }
        }
    }

    public Collection<IMfwLineageObject> getReferencedObjects() {
        return this.m_referencedObjects;
    }

    public String getItemId(boolean bAppendReportPrefix) {
        String sItemRefId;
        ILineageParam modelItemParam = this.getParam("modelItemRef");
        if (modelItemParam != null) {
            sItemRefId = modelItemParam.getValue();
        } else {
            String sQueryName = this.getParam("queryName").getValue();
            String sItemName = this.getParam("dataItemName").getValue();
            sItemRefId = QuerySetIDHelper.buildItemId(sQueryName, sItemName, bAppendReportPrefix);
        }
        return sItemRefId;
    }

    @Override
    public QueryResult convertToQueryResult() {
        QueryResult queryResult = new QueryResult();
        queryResult.setObjectQueryRef(this.getId());
        queryResult.setObjectRef(this.getItemId(true));
        return queryResult;
    }
}

