/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.metadataService.command.lineage.adapters.request;

import com.cognos.metadataService.command.CommandFixtures;
import com.cognos.metadataService.command.lineage.adapters.request.Connection;
import com.cognos.metadataService.command.lineage.adapters.request.DataTypeAquisition;
import com.cognos.metadataService.command.lineage.adapters.request.IMfwGatewayFactory;
import com.cognos.metadataService.command.lineage.adapters.request.ObjectQuery;
import com.cognos.metadataService.command.lineage.adapters.request.Param;
import com.cognos.metadataService.command.lineage.api.interfaces.ILineageConnection;
import com.cognos.metadataService.command.lineage.api.interfaces.ILineageObjectQuery;
import com.cognos.metadataService.command.lineage.api.interfaces.ILineageParam;
import com.cognos.metadataService.command.lineage.api.interfaces.ILineageParamContainer;
import com.cognos.metadataService.command.lineage.api.interfaces.ILineageRequest;
import com.cognos.metadataService.command.lineage.api.interfaces.ILineageRequestQuery;
import com.cognos.metadataService.sources.contentmanager.CMQuery;
import com.cognos.metadataService.util.errors.MDSRVErrorCode;
import com.cognos.metadataService.util.errors.MDSRVErrorType;
import com.cognos.metadataService.util.errors.MDSRVException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import org.dom4j.Element;

public class Request
implements ILineageRequest {
    private static String rolapDataType = "RO";
    private Connection m_connection = new Connection();
    private Collection<ILineageObjectQuery> m_objectQueryList = new Vector<ILineageObjectQuery>();
    private String m_sQuerySet;

    public Request(Element requestElem) {
        Iterator requestChildElemIter = requestElem.elementIterator();
        while (requestChildElemIter.hasNext()) {
            Element requestChildElem = (Element)requestChildElemIter.next();
            String elemName = requestChildElem.getName();
            if (elemName.equals("connection")) {
                this.m_connection = new Connection();
                this.deserializeParamContainer(requestChildElem, this.m_connection);
                continue;
            }
            if (elemName.equals("V5QuerySet")) {
                this.m_sQuerySet = requestChildElem.getText();
                continue;
            }
            if (!elemName.equals("objectQuery")) continue;
            ObjectQuery objectQuery = new ObjectQuery();
            objectQuery.setId(requestChildElem.attributeValue("id"));
            this.deserializeParamContainer(requestChildElem, objectQuery);
            this.addObjectQuery(objectQuery);
        }
    }

    @Override
    public String getQuerySet() {
        return this.m_sQuerySet;
    }

    @Override
    public ILineageConnection getConnection() {
        return this.m_connection;
    }

    public void bind(CMQuery cmQuery, String passport, IMfwGatewayFactory mfwGatewayFactory, Element parametersElem, HashMap<CommandFixtures, Object> fixtures) {
        ILineageParam searchPathParam = this.m_connection.getParam("searchPath");
        DataTypeAquisition dta = new DataTypeAquisition(searchPathParam.getValue(), passport);
        dta.testQueryModelDataSources();
        if (!dta.hasMultipleDatasources() && dta.hasROLAPDatasource()) {
            throw new MDSRVException(MDSRVErrorType.CLIENT, MDSRVErrorCode.MSR_LIN_NoROLAPLineage, "objectQuery");
        }
        this.m_connection.bind(cmQuery, mfwGatewayFactory, passport, parametersElem, fixtures);
        for (ObjectQuery objectQuery : this.m_objectQueryList) {
            objectQuery.bind(this.m_connection);
        }
    }

    @Override
    public ILineageObjectQuery getObjectQuery(String id) {
        ILineageObjectQuery objectQuery = null;
        Iterator<ILineageObjectQuery> objectQueryListIter = this.m_objectQueryList.iterator();
        while (objectQueryListIter.hasNext() && objectQuery == null) {
            ILineageObjectQuery currentObjectQuery = objectQueryListIter.next();
            if (!id.equals(currentObjectQuery.getId())) continue;
            objectQuery = currentObjectQuery;
        }
        return objectQuery;
    }

    public Collection<ILineageObjectQuery> getObjectQueryList() {
        return this.m_objectQueryList;
    }

    @Override
    public Collection<ILineageRequestQuery> getRequestQueryList() {
        Vector<ILineageRequestQuery> requestQueryList = new Vector<ILineageRequestQuery>();
        for (ILineageObjectQuery objectQuery : this.m_objectQueryList) {
            requestQueryList.add(objectQuery);
        }
        return requestQueryList;
    }

    @Override
    public void addObjectQuery(ILineageObjectQuery objectQuery) {
        this.m_objectQueryList.add(objectQuery);
    }

    private void deserializeParamContainer(Element requestChildElem, ILineageParamContainer paramContainer) {
        Iterator paramIter = requestChildElem.elementIterator("param");
        while (paramIter.hasNext()) {
            Element paramElem = (Element)paramIter.next();
            Param param = new Param();
            String attributeValue = paramElem.attributeValue("name");
            param.setName(attributeValue);
            String text = paramElem.getText();
            param.setValue(text);
            paramContainer.addParam(param);
        }
    }

    public boolean containsDataItem(String sQueryName, String sDataItemName) {
        for (ObjectQuery objectQuery : this.m_objectQueryList) {
            if (!objectQuery.containsDataItem(sQueryName, sDataItemName)) continue;
            return true;
        }
        return false;
    }
}

