/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.metadataService.command.lineage.adapters.response;

import com.cognos.developer.schemas.bibus._3.BaseClass;
import com.cognos.developer.schemas.bibus._3.PropEnum;
import com.cognos.metadataService.command.lineage.adapters.response.BasicLineagePropertyContainer;
import com.cognos.metadataService.command.lineage.adapters.response.ObjectPositionCompare;
import com.cognos.metadataService.command.lineage.api.interfaces.ILineageObject;
import com.cognos.metadataService.command.lineage.api.interfaces.ILineageProperty;
import com.cognos.metadataService.command.lineage.api.interfaces.ILineageTransformation;
import com.cognos.metadataService.sources.contentmanager.CMObject;
import com.cognos.metadataService.sources.contentmanager.CMQuery;
import com.cognos.metadataService.sources.mfw.LocalizedSchemaValues;
import com.cognos.metadataService.util.misc.AxisTypesHelper;
import com.cognos.metadataService.util.misc.LocalizedStrings;
import java.util.Collection;
import java.util.Collections;
import java.util.Vector;

public class CMLineageObject
implements ILineageObject {
    public static final PropEnum[] baseClassQueryProps = new PropEnum[]{PropEnum.storeID, PropEnum.searchPath, PropEnum.objectClass, PropEnum.defaultName, PropEnum.owner, PropEnum.parent, PropEnum.version};
    public static final PropEnum[] uiClassQueryProps = CMQuery.concatProps(baseClassQueryProps, new PropEnum[]{PropEnum.defaultDescription, PropEnum.defaultScreenTip, PropEnum.contact, PropEnum.contactEMail});
    LocalizedStrings m_strings;
    CMObject m_cmObj;
    Class<? extends BaseClass> m_axisClassType;
    ILineageTransformation m_transformation;
    BasicLineagePropertyContainer m_properties = new BasicLineagePropertyContainer();
    ILineageObject m_parent;
    Vector<ILineageObject> m_children = new Vector();

    public static PropEnum[] getBaseClassQueryProps(PropEnum[] additionalQueryProps) {
        return CMQuery.concatProps(baseClassQueryProps, additionalQueryProps);
    }

    public static PropEnum[] getUIClassQueryProps(PropEnum[] additionalQueryProps) {
        return CMQuery.concatProps(uiClassQueryProps, additionalQueryProps);
    }

    public CMLineageObject(Class<? extends BaseClass> axisClassType, CMObject uiClassObj) {
        this.m_cmObj = uiClassObj;
        this.m_strings = new LocalizedStrings(this.m_cmObj.getSourceQuery().getProductLocale());
        this.m_axisClassType = axisClassType;
        LocalizedStrings mfwStrings = new LocalizedStrings(this.m_cmObj.getSourceQuery().getProductLocale(), "mfwModel");
        this.m_properties.addProperty("objectType", mfwStrings.getLocalizedValue(LocalizedSchemaValues.MSGSECTIONPREFIX + "objectType"), this.m_cmObj.getObjectClass(), this.m_strings.getLocalizedValue("MSR_OM_" + this.m_cmObj.getObjectClass()));
        this.addProperty(PropEnum.description, uiClassObj.getStringPropValue(PropEnum.defaultDescription));
        this.addProperty(PropEnum.screenTip, uiClassObj.getStringPropValue(PropEnum.defaultScreenTip));
        this.addProperty(PropEnum.contact, uiClassObj.getRefObjPropValue(PropEnum.contact, PropEnum.defaultName));
        this.addProperty(PropEnum.contactEMail, uiClassObj.getStringPropValue(PropEnum.contactEMail));
        this.addProperty(PropEnum.owner, uiClassObj.getRefObjPropValue(PropEnum.owner, PropEnum.defaultName));
        this.addProperty(PropEnum.version, uiClassObj.getStringPropValue(PropEnum.version));
    }

    public void addProperty(PropEnum prop, String propValue) {
        if (propValue != null && propValue.length() > 0) {
            this.m_properties.addProperty(prop.getValue(), this.getPropDisplayName(prop, this.m_cmObj.getSourceQuery().getProductLocale()), propValue, null);
        }
    }

    private String getPropDisplayName(PropEnum propertyName, String productLocale) {
        String propertyDisplayName = this.m_strings.getLocalizedValue("MSR_OM_" + propertyName);
        if (propertyDisplayName == null || propertyDisplayName.length() == 0) {
            propertyDisplayName = propertyName.getValue();
        }
        return propertyDisplayName;
    }

    @Override
    public void addChild(ILineageObject child) {
        child.setParent(this);
        this.m_children.add(child);
    }

    @Override
    public Collection<ILineageObject> getChildren() {
        Collections.sort(this.m_children, new ObjectPositionCompare());
        return this.m_children;
    }

    @Override
    public String getId() {
        return this.m_cmObj.getSearchPath();
    }

    @Override
    public String getName() {
        return this.m_cmObj.getDefaultName();
    }

    @Override
    public String getType() {
        return AxisTypesHelper.getOMClassTypeName(this.m_axisClassType);
    }

    @Override
    public ILineageObject getParent() {
        return this.m_parent;
    }

    @Override
    public void setParent(ILineageObject parent) {
        this.m_parent = parent;
    }

    @Override
    public void addProperty(ILineageProperty prop) {
        this.m_properties.addProperty(prop);
    }

    @Override
    public Collection<ILineageProperty> getProperties() {
        return this.m_properties.getProperties();
    }

    @Override
    public ILineageProperty getProperty(String propertyName) {
        return this.m_properties.getProperty(propertyName);
    }

    @Override
    public void setId(String id) {
    }

    @Override
    public void setName(String name) {
    }

    @Override
    public void setType(String type) {
    }

    @Override
    public ILineageTransformation getTransformation() {
        return null;
    }

    @Override
    public void setTransformation(ILineageTransformation transformation) {
    }

    public CMObject getCmObj() {
        return this.m_cmObj;
    }
}

