/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.metadataService.command.lineage.adapters.response;

import com.cognos.metadataService.command.lineage.adapters.response.BasicLineagePropertyContainer;
import com.cognos.metadataService.command.lineage.adapters.response.IMfwLineageObject;
import com.cognos.metadataService.command.lineage.adapters.response.LineageObjectId;
import com.cognos.metadataService.command.lineage.adapters.response.MfwLineageObjectMissingId;
import com.cognos.metadataService.command.lineage.adapters.response.MfwLineageObjectProperties;
import com.cognos.metadataService.command.lineage.adapters.response.MfwLineageObjectViaShortcut;
import com.cognos.metadataService.command.lineage.adapters.response.MfwLineageProperty;
import com.cognos.metadataService.command.lineage.adapters.response.ObjectPositionCompare;
import com.cognos.metadataService.command.lineage.adapters.response.ViaShortcutStack;
import com.cognos.metadataService.command.lineage.api.interfaces.ILineageObject;
import com.cognos.metadataService.command.lineage.api.interfaces.ILineageProperty;
import com.cognos.metadataService.command.lineage.api.interfaces.ILineageTransformation;
import com.cognos.metadataService.command.lineage.source.model.LineageProps;
import com.cognos.metadataService.command.lineage.source.model.ObjectTypeInfo;
import com.cognos.metadataService.sources.mfw.ContentManagerMetadataSourceRetrieval;
import com.cognos.metadataService.sources.mfw.LocalizedSchemaValues;
import com.cognos.metadataService.sources.mfw.MultilingualPropertyTranslater;
import com.cognos.metadataService.sources.mfw.NodeQuery;
import com.cognos.metadataService.sources.mfw.ObjectAccessibility;
import com.cognos.metadataService.sources.mfw.PropertyNodeRetrieval;
import com.cognos.metadataService.sources.mfw.RIDHacks;
import com.cognos.metadataService.util.logging.MDSRVLogUtil;
import com.cognos.mfw4j.framework.MFWGateway;
import com.cognos.mfw4j.framework.MFWInfo;
import com.cognos.mfw4j.framework.MFWModelRes;
import com.cognos.mfw4j.framework.MFWNodeHandle;
import com.cognos.xqe.ast.v5Exp.uniqueName.IV5UniqueNamePiece;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Vector;

public class MfwLineageObject
implements IMfwLineageObject {
    private static final long serialVersionUID = -4650691642506948715L;
    private MDSRVLogUtil m_logUtil;
    private MFWGateway m_mfwGateway;
    private final MFWNodeHandle m_node;
    private final ObjectTypeInfo m_objectTypeInfo;
    private String m_name;
    private BasicLineagePropertyContainer m_propertyContainer;
    private ILineageTransformation m_transformation;
    private ILineageObject m_parent;
    private Vector<ILineageObject> m_children = new Vector();
    private long m_position = -1L;
    private LocalizedSchemaValues m_localizedSchemaValues;
    private MultilingualPropertyTranslater m_multilingualPropertyTranslater;
    private LineageProps m_lineageRules = new LineageProps();
    private MfwLineageObjectProperties m_propertyFactory = null;
    private final MFWModelRes m_mfwModelRes;

    MfwLineageObject(MFWGateway mfwGateway, MFWNodeHandle node, LocalizedSchemaValues localizedSchemaValues, MultilingualPropertyTranslater multilingualPropertyTranslater) {
        this.m_mfwGateway = mfwGateway;
        this.m_localizedSchemaValues = localizedSchemaValues;
        this.m_multilingualPropertyTranslater = multilingualPropertyTranslater;
        this.m_logUtil = MDSRVLogUtil.getLogUtilInstance();
        MFWInfo nodeInfo = node.getInfo();
        short nodeInfoRid = nodeInfo.getRID();
        this.m_mfwModelRes = MFWModelRes.getInstance();
        if (this.m_mfwModelRes.RID_shortcut != nodeInfoRid) {
            this.m_node = node;
        } else {
            PropertyNodeRetrieval propertyNodeRetrieval = new PropertyNodeRetrieval(this.m_mfwGateway, node, this.m_mfwModelRes.RID_refobj);
            String idValue = propertyNodeRetrieval.getValue();
            LineageObjectId lineageObjectId = new LineageObjectId(idValue);
            NodeQuery nodeQuery = new NodeQuery(this.m_mfwGateway);
            IV5UniqueNamePiece namedReference = lineageObjectId.getNamedReference();
            this.m_node = nodeQuery.findObjectNodeForId(namedReference);
        }
        MFWInfo m_nodeInfo = this.m_node.getInfo();
        short m_nodeInfoRid = m_nodeInfo.getRID();
        this.m_objectTypeInfo = this.m_lineageRules.getObjectInfo(m_nodeInfoRid);
        if (this.m_objectTypeInfo != null) {
            ObjectAccessibility objectAccessibility = new ObjectAccessibility(mfwGateway, node);
            if (!objectAccessibility.isAccessible() && this.m_logUtil.isTraceInformativeEnabled()) {
                LineageObjectId objectId = this.getObjectId();
                String objectIdValue = objectId.getValue();
                this.m_logUtil.traceInformative("object " + objectIdValue + ", type " + this.m_mfwModelRes.getResource(nodeInfoRid) + "is not accessible");
            }
            this.m_propertyFactory = new MfwLineageObjectProperties(mfwGateway, localizedSchemaValues, multilingualPropertyTranslater, this.m_node, this.m_objectTypeInfo);
        }
    }

    @Override
    public String getId() {
        MFWNodeHandle node = this.getNode();
        PropertyNodeRetrieval idRetrieval = new PropertyNodeRetrieval(this.m_mfwGateway, node, this.m_mfwModelRes.RID_ID);
        return idRetrieval.getValue();
    }

    @Override
    public String getType() {
        return RIDHacks.getNameForRID(this.m_node.getInfo().getRID());
    }

    @Override
    public String getName() {
        if (this.m_name == null) {
            PropertyNodeRetrieval propertyNodeRetrieval = new PropertyNodeRetrieval(this.m_mfwGateway, this.m_node, this.m_mfwModelRes.RID_name, this.m_multilingualPropertyTranslater);
            this.m_name = propertyNodeRetrieval.getValue();
        }
        return this.m_name;
    }

    @Override
    public MFWNodeHandle getNode() {
        return this.m_node;
    }

    @Override
    public MfwLineageProperty getTransformationProperty() {
        return this.m_propertyFactory.transformationProperty();
    }

    @Override
    public ILineageTransformation getTransformation() {
        return this.m_transformation;
    }

    @Override
    public void setTransformation(ILineageTransformation transformation) {
        this.m_transformation = transformation;
    }

    @Override
    public ILineageObject getParent() {
        return this.m_parent;
    }

    @Override
    public void setParent(ILineageObject parent) {
        this.m_parent = parent;
    }

    @Override
    public void addChild(ILineageObject child) {
        this.m_children.add(child);
    }

    @Override
    public Collection<ILineageObject> getChildren() {
        ObjectPositionCompare objectPositionCompare = new ObjectPositionCompare();
        Collections.sort(this.m_children, objectPositionCompare);
        return this.m_children;
    }

    @Override
    public void addProperty(ILineageProperty prop) {
        BasicLineagePropertyContainer propertyContainer = this.getPropertyContainer();
        propertyContainer.addProperty(prop);
    }

    @Override
    public ILineageProperty getProperty(String propertyName) {
        BasicLineagePropertyContainer propertyContainer = this.getPropertyContainer();
        return propertyContainer.getProperty(propertyName);
    }

    @Override
    public Collection<ILineageProperty> getProperties() {
        return this.getPropertyContainer().getProperties();
    }

    private BasicLineagePropertyContainer getPropertyContainer() {
        if (this.m_propertyContainer == null) {
            this.m_propertyContainer = new BasicLineagePropertyContainer();
            MFWNodeHandle node = this.getNode();
            MFWInfo nodeInfo = node.getInfo();
            if (null != nodeInfo.findChildInfo(this.m_mfwModelRes.RID_ID)) {
                String localizedObjectIDPropertyName = this.m_localizedSchemaValues.getLocalizedObjectIDPropertyName();
                String localizedId = this.getLocalizedId();
                this.m_propertyContainer.addProperty("objectId", localizedObjectIDPropertyName, localizedId, null);
                String localizedObjectNamePropertyName = this.m_localizedSchemaValues.getLocalizedObjectNamePropertyName();
                String localizedObjectName = this.getName();
                this.m_propertyContainer.addProperty("objectName", localizedObjectNamePropertyName, localizedObjectName, null);
            }
            String localizedObjectTypePropertyName = this.m_localizedSchemaValues.getLocalizedObjectTypePropertyName();
            String localizedType = this.getLocalizedType();
            this.m_propertyContainer.addProperty("objectType", localizedObjectTypePropertyName, localizedType, null);
            List<MfwLineageProperty> props = this.m_propertyFactory.props();
            for (MfwLineageProperty prop : props) {
                this.m_propertyContainer.addProperty(prop);
            }
        }
        return this.m_propertyContainer;
    }

    @Override
    public String getLocalizedId() {
        boolean hasMultilingualName = this.hasMultilingualName();
        LineageObjectId localizedObjectId = this.getObjectId();
        if (hasMultilingualName) {
            LineageObjectId translated;
            localizedObjectId = translated = localizedObjectId.translate(this.m_mfwGateway, this.m_multilingualPropertyTranslater);
        }
        String localizedIdValue = localizedObjectId.getValue();
        return localizedIdValue;
    }

    @Override
    public boolean hasMultilingualName() {
        MFWInfo localeInfo = null;
        MFWNodeHandle node = this.getNode();
        MFWInfo nodeInfo = node.getInfo();
        MFWInfo nameNodeInfo = nodeInfo.findChildInfo(this.m_mfwModelRes.RID_name);
        if (nameNodeInfo != null) {
            localeInfo = nameNodeInfo.findChildInfo(this.m_mfwModelRes.RID_locale);
        }
        return localeInfo != null;
    }

    @Override
    public long getPosition() {
        if (this.m_position == -1L) {
            MFWNodeHandle currentNode = this.getNode();
            MFWNodeHandle currentNodeParent = currentNode.getParent();
            MFWNodeHandle[] siblingNodes = this.m_mfwGateway.getAllObjectChildren(currentNodeParent);
            for (int siblingNodesIdx = 0; this.m_position == -1L && siblingNodesIdx < siblingNodes.length; ++siblingNodesIdx) {
                MFWNodeHandle siblingNode = siblingNodes[siblingNodesIdx];
                if (!currentNode.equals((Object)siblingNode)) continue;
                this.m_position = siblingNodesIdx;
            }
            this.m_position = this.m_position == -1L ? 0L : this.m_position;
        }
        return this.m_position;
    }

    @Override
    public String getLocalizedType() {
        return this.m_localizedSchemaValues.getLocalizedValue(this.m_node.getInfo().getRID());
    }

    @Override
    public void setId(String id) {
    }

    @Override
    public void setType(String type) {
    }

    @Override
    public void setName(String name) {
    }

    @Override
    public String getSourceSearchPath() {
        ContentManagerMetadataSourceRetrieval metadataSourceRetrieval = new ContentManagerMetadataSourceRetrieval();
        return metadataSourceRetrieval.getCmSearchPath(this.m_mfwGateway, this.m_node);
    }

    public MFWGateway getModelGateway() {
        return this.m_mfwGateway;
    }

    @Override
    public LineageObjectId getObjectId() {
        return new LineageObjectId(this.getId());
    }

    @Override
    public IMfwLineageObject buildChildMfwObj(MFWNodeHandle childNode) {
        IMfwLineageObject childNodeObj = new MfwLineageObject(this.m_mfwGateway, childNode, this.m_localizedSchemaValues, this.m_multilingualPropertyTranslater);
        boolean childNodeIsProperty = childNode.isProperty();
        MFWInfo childNodeInfo = childNode.getInfo();
        if (childNodeIsProperty || null == childNodeInfo.findChildInfo(this.m_mfwModelRes.RID_ID)) {
            childNodeObj = new MfwLineageObjectMissingId(this.m_mfwGateway, childNodeObj, this, this.m_localizedSchemaValues, this.m_multilingualPropertyTranslater);
        } else {
            short childNodeInfoRid = childNodeInfo.getRID();
            if (this.m_mfwModelRes.RID_shortcut == childNodeInfoRid) {
                childNodeObj = new MfwLineageObjectViaShortcut(this.m_mfwGateway, childNodeObj, new ViaShortcutStack(this.m_mfwGateway, childNode), this.m_localizedSchemaValues, this.m_multilingualPropertyTranslater);
            }
        }
        return childNodeObj;
    }

    @Override
    public IMfwLineageObject buildParent() {
        MFWInfo parentNodeInfo;
        short parentNodeInfoRid;
        MFWNodeHandle parentNode;
        MfwLineageObject parentObj = null;
        MFWNodeHandle node = this.getNode();
        MFWInfo nodeInfo = node.getInfo();
        short nodeInfoRid = nodeInfo.getRID();
        if (this.m_mfwModelRes.RID_namespace != nodeInfoRid && null != (parentNode = node.getParent()) && null != this.m_lineageRules.getObjectInfo(parentNodeInfoRid = (parentNodeInfo = parentNode.getInfo()).getRID())) {
            parentObj = new MfwLineageObject(this.m_mfwGateway, parentNode, this.m_localizedSchemaValues, this.m_multilingualPropertyTranslater);
        }
        return parentObj;
    }

    @Override
    public List<MfwLineageProperty> getTransformationProperties() {
        return this.m_propertyFactory.transformationProperties();
    }
}

