/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.metadataService.command.lineage.adapters.response;

import com.cognos.metadataService.command.lineage.adapters.response.MfwLineageProperty;
import com.cognos.metadataService.command.lineage.source.model.ObjectTypeInfo;
import com.cognos.metadataService.command.lineage.source.model.PropertyTypeInfo;
import com.cognos.metadataService.sources.mfw.LocalizedSchemaValues;
import com.cognos.metadataService.sources.mfw.MultilingualPropertyTranslater;
import com.cognos.metadataService.sources.mfw.PropertyNodeRetrieval;
import com.cognos.mfw4j.framework.MFWGateway;
import com.cognos.mfw4j.framework.MFWNodeHandle;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.Vector;

public class MfwLineageObjectProperties {
    private List<MfwLineageProperty> m_modelProps = new ArrayList<MfwLineageProperty>();
    List<MfwLineageProperty> m_transformationProperties = new ArrayList<MfwLineageProperty>();
    private final MFWNodeHandle m_node;
    private boolean loaded;
    private final MFWGateway m_mfwGateway;
    private final LocalizedSchemaValues m_localizedSchemaValues;
    private final MultilingualPropertyTranslater m_multilingualPropertyTranslater;
    private final ObjectTypeInfo m_objectTypeInfo;

    public MfwLineageObjectProperties(MFWGateway mfwGateway, LocalizedSchemaValues localizedSchemaValues, MultilingualPropertyTranslater multilingualPropertyTranslater, MFWNodeHandle node, ObjectTypeInfo objectTypeInfo) {
        this.m_mfwGateway = mfwGateway;
        this.m_localizedSchemaValues = localizedSchemaValues;
        this.m_multilingualPropertyTranslater = multilingualPropertyTranslater;
        this.m_node = node;
        this.m_objectTypeInfo = objectTypeInfo;
        this.loaded = false;
    }

    public List<MfwLineageProperty> props() {
        this.loadProps();
        return this.m_modelProps;
    }

    public MfwLineageProperty transformationProperty() {
        this.loadProps();
        if (this.m_transformationProperties.isEmpty()) {
            return null;
        }
        return this.m_transformationProperties.get(0);
    }

    public List<MfwLineageProperty> transformationProperties() {
        this.loadProps();
        return this.m_transformationProperties;
    }

    private void loadProps() {
        if (!this.loaded) {
            if (this.m_node.isProperty()) {
                MfwLineageProperty mfwLineageProperty = new MfwLineageProperty(this.m_mfwGateway, this.m_node, this.m_localizedSchemaValues, this.m_multilingualPropertyTranslater);
                this.m_transformationProperties.add(mfwLineageProperty);
                this.m_modelProps.add(mfwLineageProperty);
            } else {
                Vector<PropertyTypeInfo> propertyInfoList = this.m_objectTypeInfo.getPropertyList();
                for (PropertyTypeInfo propertyInfo : propertyInfoList) {
                    short rid = propertyInfo.getRid();
                    PropertyNodeRetrieval nodeRetrieval = new PropertyNodeRetrieval(this.m_mfwGateway, this.m_node, rid, this.m_multilingualPropertyTranslater);
                    MFWNodeHandle propertyNode = nodeRetrieval.getPropertyNode();
                    if (propertyNode == null) continue;
                    MfwLineageProperty mfwLineageProperty = new MfwLineageProperty(this.m_mfwGateway, propertyNode, this.m_localizedSchemaValues, this.m_multilingualPropertyTranslater);
                    this.m_modelProps.add(mfwLineageProperty);
                }
                HashMap<Short, Integer> transformationPropertyMap = this.m_objectTypeInfo.getTransformationPropertyMap();
                if (!transformationPropertyMap.isEmpty()) {
                    Set<Short> keys = transformationPropertyMap.keySet();
                    for (Short id : keys) {
                        Integer count = transformationPropertyMap.get(id);
                        PropertyNodeRetrieval propertyNodeRetrieval = new PropertyNodeRetrieval(this.m_mfwGateway, this.m_node, (short)id, count);
                        ArrayList<MFWNodeHandle> PropNodes = propertyNodeRetrieval.getPropertyNodes();
                        for (int pn = 0; pn < PropNodes.size(); ++pn) {
                            MFWNodeHandle propertyNode = PropNodes.get(pn);
                            if (propertyNode == null) continue;
                            MfwLineageProperty mfwLineageProperty = new MfwLineageProperty(this.m_mfwGateway, propertyNode, this.m_localizedSchemaValues, this.m_multilingualPropertyTranslater);
                            this.m_transformationProperties.add(mfwLineageProperty);
                        }
                    }
                }
            }
        }
        this.loaded = true;
    }
}

