/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.metadataService.command.lineage.adapters.response;

import com.cognos.metadataService.command.lineage.adapters.response.BasicLineageProperty;
import com.cognos.metadataService.command.lineage.adapters.response.IMfwLineageObject;
import com.cognos.metadataService.command.lineage.adapters.response.LineageObjectId;
import com.cognos.metadataService.command.lineage.adapters.response.MfwLineageObject;
import com.cognos.metadataService.command.lineage.adapters.response.MfwLineageObjectDecorator;
import com.cognos.metadataService.command.lineage.adapters.response.ViaShortcutStack;
import com.cognos.metadataService.command.lineage.api.interfaces.ILineageProperty;
import com.cognos.metadataService.sources.mfw.LocalizedSchemaValues;
import com.cognos.metadataService.sources.mfw.MultilingualPropertyTranslater;
import com.cognos.metadataService.sources.mfw.PropertyNodeRetrieval;
import com.cognos.mfw4j.framework.MFWGateway;
import com.cognos.mfw4j.framework.MFWModelRes;
import com.cognos.mfw4j.framework.MFWNodeHandle;
import com.cognos.xqe.ast.v5Exp.uniqueName.IV5UniqueNamePart;
import com.cognos.xqe.ast.v5Exp.uniqueName.IV5UniqueNamePiece;
import com.cognos.xqe.ast.v5Exp.uniqueName.adapters.V5UniqueNamePieceNamePartList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Vector;

public class MfwLineageObjectViaShortcut
extends MfwLineageObjectDecorator {
    private static final long serialVersionUID = -1810685221154188690L;
    private LineageObjectId m_objectId;
    private ViaShortcutStack m_viaShortcutStack;
    private IMfwLineageObject m_parent;
    private MFWGateway m_mfwGateway;
    private LocalizedSchemaValues m_localizedSchemaValues;
    private MultilingualPropertyTranslater m_multilingualPropertyTranslater;
    private Vector<ILineageProperty> m_props;
    private final MFWModelRes m_mfwRes;

    public MfwLineageObjectViaShortcut(MFWGateway mfwGateway, IMfwLineageObject lineageObject, LineageObjectId id, LocalizedSchemaValues localizedSchemaValues, MultilingualPropertyTranslater multilingualPropertyTranslater) {
        this(mfwGateway, lineageObject, localizedSchemaValues, multilingualPropertyTranslater);
        this.m_objectId = id;
    }

    public MfwLineageObjectViaShortcut(MFWGateway mfwGateway, IMfwLineageObject lineageObject, ViaShortcutStack viaShortcutStack, LocalizedSchemaValues localizedSchemaValues, MultilingualPropertyTranslater multilingualPropertyTranslater) {
        this(mfwGateway, lineageObject, localizedSchemaValues, multilingualPropertyTranslater);
        this.m_viaShortcutStack = viaShortcutStack;
        if (viaShortcutStack.getCurrentShortcutNode() == null) {
            throw new NullPointerException();
        }
    }

    private MfwLineageObjectViaShortcut(MFWGateway mfwGateway, IMfwLineageObject lineageObject, LocalizedSchemaValues localizedSchemaValues, MultilingualPropertyTranslater multilingualPropertyTranslater) {
        super(lineageObject);
        this.m_mfwGateway = mfwGateway;
        this.m_localizedSchemaValues = localizedSchemaValues;
        this.m_multilingualPropertyTranslater = multilingualPropertyTranslater;
        this.m_mfwRes = MFWModelRes.getInstance();
    }

    @Override
    public IMfwLineageObject buildChildMfwObj(MFWNodeHandle childNode) {
        IMfwLineageObject childNodeObj = super.buildChildMfwObj(childNode);
        if (childNodeObj != null) {
            childNodeObj = new MfwLineageObjectViaShortcut(this.m_mfwGateway, childNodeObj, this.getViaShortcutStack(), this.m_localizedSchemaValues, this.m_multilingualPropertyTranslater);
        }
        return childNodeObj;
    }

    @Override
    public IMfwLineageObject buildParent() {
        short rid;
        MFWNodeHandle parentNode;
        if (this.m_parent == null && (parentNode = this.getNode().getParent()) != null && this.m_mfwRes.RID_namespace != (rid = this.getNode().getInfo().getRID())) {
            MFWNodeHandle currentShortcutTargetNode = this.getViaShortcutStack().getCurrentShortcutTargetNode();
            MFWNodeHandle parentLineageObjShortcutNode = null;
            MFWNodeHandle parentLineageObjNode = null;
            if (currentShortcutTargetNode == null) {
                parentLineageObjNode = parentNode;
            } else if (currentShortcutTargetNode.equals((Object)this.getNode())) {
                short shortcutTargetRid = currentShortcutTargetNode.getInfo().getRID();
                if (this.m_mfwRes.RID_namespace != shortcutTargetRid && this.m_mfwRes.RID_folder != shortcutTargetRid) {
                    parentLineageObjNode = this.getViaShortcutStack().getCurrentShortcutNode().getParent();
                    this.getViaShortcutStack().pop();
                }
            } else {
                parentLineageObjNode = parentNode;
                parentLineageObjShortcutNode = this.getViaShortcutStack().getCurrentShortcutNode();
            }
            if (parentLineageObjNode != null) {
                this.m_parent = new MfwLineageObject(this.m_mfwGateway, parentLineageObjNode, this.m_localizedSchemaValues, this.m_multilingualPropertyTranslater);
                if (parentLineageObjShortcutNode != null) {
                    this.m_parent = new MfwLineageObjectViaShortcut(this.m_mfwGateway, this.m_parent, this.getViaShortcutStack(), this.m_localizedSchemaValues, this.m_multilingualPropertyTranslater);
                }
            }
        }
        return this.m_parent;
    }

    @Override
    public void setId(String id) {
        this.m_objectId = new LineageObjectId(id);
        this.m_viaShortcutStack = null;
    }

    @Override
    public String getId() {
        return this.getObjectId().getValue();
    }

    @Override
    public LineageObjectId getObjectId() {
        if (this.m_objectId == null) {
            ArrayList<IV5UniqueNamePart> newObjectIdParts = new ArrayList<IV5UniqueNamePart>();
            MFWNodeHandle currentShortcutNode = this.getViaShortcutStack().getCurrentShortcutNode();
            MFWNodeHandle currentShortcutTargetNode = this.getViaShortcutStack().getCurrentShortcutTargetNode();
            PropertyNodeRetrieval propertyNodeRetrieval = new PropertyNodeRetrieval(this.m_mfwGateway, currentShortcutNode, this.m_mfwRes.RID_ID);
            String idValue = propertyNodeRetrieval.getValue();
            short rid = this.getNode().getInfo().getRID();
            if (this.m_mfwRes.RID_namespace == rid || this.m_mfwRes.RID_folder == rid && currentShortcutTargetNode.equals((Object)this.getNode())) {
                this.m_objectId = new LineageObjectId(idValue);
            } else {
                int childObjectStartPos;
                newObjectIdParts.addAll(new LineageObjectId(idValue).getParts());
                List<IV5UniqueNamePart> superIdParts = super.getObjectId().getParts();
                for (int childObjectIdPartsIdx = childObjectStartPos = newObjectIdParts.size(); childObjectIdPartsIdx < superIdParts.size(); ++childObjectIdPartsIdx) {
                    IV5UniqueNamePart namePart = superIdParts.get(childObjectIdPartsIdx);
                    newObjectIdParts.add(namePart);
                }
                V5UniqueNamePieceNamePartList newObjectIdNamedReference = new V5UniqueNamePieceNamePartList(newObjectIdParts);
                this.m_objectId = new LineageObjectId((IV5UniqueNamePiece)newObjectIdNamedReference, super.getObjectId().getComplexPropertySuffix());
            }
        }
        return this.m_objectId;
    }

    @Override
    public String getLocalizedId() {
        return this.getObjectId().translate(this.m_mfwGateway, this.m_multilingualPropertyTranslater).getValue();
    }

    public ViaShortcutStack getViaShortcutStack() {
        if (this.m_viaShortcutStack == null) {
            this.m_viaShortcutStack = new ViaShortcutStack(this.m_mfwGateway, this.getObjectId());
        }
        return this.m_viaShortcutStack;
    }

    @Override
    public String getName() {
        String name;
        MFWNodeHandle thisNode;
        ViaShortcutStack viaShortcutStack = this.getViaShortcutStack();
        MFWNodeHandle currentShortcutTargetNode = viaShortcutStack.getCurrentShortcutTargetNode();
        if (currentShortcutTargetNode.equals((Object)(thisNode = this.getNode()))) {
            PropertyNodeRetrieval propertyNodeRetrieval = new PropertyNodeRetrieval(this.m_mfwGateway, viaShortcutStack.getCurrentShortcutNode(), this.m_mfwRes.RID_name, this.m_multilingualPropertyTranslater);
            name = propertyNodeRetrieval.getValue();
        } else {
            name = super.getName();
        }
        return name;
    }

    @Override
    public Collection<ILineageProperty> getProperties() {
        if (this.m_props == null) {
            Collection<ILineageProperty> targetObjProps = super.getProperties();
            this.m_props = new Vector(targetObjProps.size());
            for (ILineageProperty currentTargetObjProp : targetObjProps) {
                if (currentTargetObjProp == null) continue;
                String newValue = null;
                if ("objectId".equals(currentTargetObjProp.getName())) {
                    newValue = this.getLocalizedId();
                } else if ("objectName".equals(currentTargetObjProp.getName())) {
                    newValue = this.getName();
                }
                if (newValue == null) {
                    this.m_props.add(currentTargetObjProp);
                    continue;
                }
                BasicLineageProperty newLineageProperty = new BasicLineageProperty();
                newLineageProperty.setName(currentTargetObjProp.getName());
                newLineageProperty.setDisplayName(currentTargetObjProp.getDisplayName());
                newLineageProperty.setDisplayValue(currentTargetObjProp.getDisplayValue());
                newLineageProperty.setValue(newValue);
                this.m_props.add(newLineageProperty);
            }
        }
        return this.m_props;
    }
}

