/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.metadataService.command.lineage.adapters.response;

import com.cognos.metadataService.command.lineage.adapters.response.BasicLineagePropertyContainer;
import com.cognos.metadataService.command.lineage.adapters.response.IMfwLineageObject;
import com.cognos.metadataService.command.lineage.adapters.response.LineageObjectId;
import com.cognos.metadataService.command.lineage.adapters.response.MfwLineageProperty;
import com.cognos.metadataService.command.lineage.adapters.response.MfwLineageQuery;
import com.cognos.metadataService.command.lineage.adapters.response.MfwTransformationSourceHelper;
import com.cognos.metadataService.command.lineage.api.interfaces.ILineageObject;
import com.cognos.metadataService.command.lineage.api.interfaces.ILineageProperty;
import com.cognos.metadataService.command.lineage.api.interfaces.ILineageRequest;
import com.cognos.metadataService.command.lineage.api.interfaces.ILineageTransformation;
import com.cognos.metadataService.command.lineage.source.model.DataSourceRetrieval;
import com.cognos.metadataService.command.lineage.source.model.MfwLineageExpression;
import com.cognos.mfw4j.framework.MFWGateway;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Vector;

public class MfwTransformation
implements ILineageTransformation {
    IMfwLineageObject m_parentObj;
    MfwLineageProperty m_transformationProp;
    BasicLineagePropertyContainer m_propertyContainer = new BasicLineagePropertyContainer();
    Vector<ILineageObject> m_transformationSources = new Vector();

    public MfwTransformation(IMfwLineageObject parentObj, MfwLineageProperty transformationProp) {
        this.m_parentObj = parentObj;
        this.m_transformationProp = transformationProp;
        this.m_propertyContainer = new BasicLineagePropertyContainer();
        this.m_propertyContainer.addProperty(this.m_transformationProp);
    }

    @Override
    public String getType() {
        MfwLineageExpression expressionParser = this.m_transformationProp.getExpressionParser();
        return expressionParser != null && expressionParser.getReferencedObjects().size() == 1 && expressionParser.isObjectReference() ? "objectReference" : "transformation";
    }

    @Override
    public Collection<ILineageObject> getTransformationSources() {
        return this.m_transformationSources;
    }

    @Override
    public void addLineageObj(ILineageObject lineageObj) {
        this.m_transformationSources.add(lineageObj);
    }

    @Override
    public void addProperty(ILineageProperty prop) {
        this.m_propertyContainer.addProperty(prop);
    }

    @Override
    public Collection<ILineageProperty> getProperties() {
        return this.m_propertyContainer.getProperties();
    }

    @Override
    public ILineageProperty getProperty(String propertyName) {
        return this.m_propertyContainer.getProperty(propertyName);
    }

    public Collection<IMfwLineageObject> getSourceModelObjects(MFWGateway mfwGateway, MfwLineageQuery lineageObjectFactory) {
        MfwLineageExpression expressionParser = this.m_transformationProp.getExpressionParser();
        LinkedHashMap<LineageObjectId, IMfwLineageObject> transformationSourceModelObjects = new LinkedHashMap<LineageObjectId, IMfwLineageObject>();
        if (expressionParser != null) {
            Collection<IMfwLineageObject> referencedObjects = expressionParser.getReferencedObjects();
            for (IMfwLineageObject currentObj : referencedObjects) {
                MfwTransformationSourceHelper m_transformationSourceHelper = new MfwTransformationSourceHelper(mfwGateway);
                Collection<IMfwLineageObject> sources = m_transformationSourceHelper.getSources(lineageObjectFactory, currentObj);
                for (IMfwLineageObject transformationSource : sources) {
                    LineageObjectId transformationSourceObjectId = transformationSource.getObjectId();
                    transformationSourceModelObjects.put(transformationSourceObjectId, transformationSource);
                }
            }
        } else {
            DataSourceRetrieval dataSourceRetrieval = new DataSourceRetrieval(mfwGateway, this.m_parentObj, lineageObjectFactory);
            Collection<IMfwLineageObject> referencedDataSourceObjects = dataSourceRetrieval.getReferencedDataSourceObjects();
            for (IMfwLineageObject transformationSource : referencedDataSourceObjects) {
                LineageObjectId transformationSourceObjectId = transformationSource.getObjectId();
                transformationSourceModelObjects.put(transformationSourceObjectId, transformationSource);
            }
        }
        return transformationSourceModelObjects.values();
    }

    @Override
    public void setType(String type) {
    }

    @Override
    public void addLineageRequest(ILineageRequest lineageRequest) {
    }
}

