/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.metadataService.command.lineage.adapters.response;

import com.cognos.metadataService.command.lineage.adapters.response.IMfwLineageObject;
import com.cognos.metadataService.command.lineage.adapters.response.IV5UniqueNameLineageObjectQuery;
import com.cognos.metadataService.command.lineage.source.model.LineageProps;
import com.cognos.metadataService.command.lineage.source.model.ObjectTypeInfo;
import com.cognos.metadataService.sources.mfw.PropertyNodeRetrieval;
import com.cognos.mfw4j.framework.MFWGateway;
import com.cognos.mfw4j.framework.MFWInfo;
import com.cognos.mfw4j.framework.MFWModelRes;
import com.cognos.mfw4j.framework.MFWNodeHandle;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.Collection;
import java.util.Vector;

public class MfwTransformationSourceHelper {
    private static final String _BUSINESS_KEY = "_businessKey";
    private static final String _MEMBER_CAPTION = "_memberCaption";
    private MFWModelRes m_modelRes = MFWModelRes.getInstance();
    MFWGateway m_mfwGateway;
    LineageProps m_lineageRules;
    short[] m_childRids;

    public MfwTransformationSourceHelper(MFWGateway mfwGateway) {
        this.m_mfwGateway = mfwGateway;
        this.m_lineageRules = new LineageProps();
        this.m_childRids = this.m_lineageRules.getObjectRids();
        Arrays.sort(this.m_childRids);
    }

    public Collection<IMfwLineageObject> getSources(IV5UniqueNameLineageObjectQuery lineageObjectFactory, IMfwLineageObject modelObject) {
        return this.getSources(lineageObjectFactory, modelObject, false);
    }

    public Collection<IMfwLineageObject> getSourcesDeep(IV5UniqueNameLineageObjectQuery lineageObjectFactory, IMfwLineageObject modelObject) {
        return this.getSources(lineageObjectFactory, modelObject, true);
    }

    public static void dump(String line) {
        PrintWriter outputStream = null;
        try {
            outputStream = new PrintWriter(new FileWriter("mdsrv-dump.txt", true));
            outputStream.println(line);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (outputStream != null) {
                outputStream.close();
            }
        }
    }

    private Collection<IMfwLineageObject> getSources(IV5UniqueNameLineageObjectQuery lineageObjectFactory, IMfwLineageObject modelObject, boolean bDeep) {
        Vector<IMfwLineageObject> transformationSources = new Vector<IMfwLineageObject>();
        MFWInfo info = modelObject.getNode().getInfo();
        if (info.findChildInfo(MFWModelRes.getInstance().RID_ID) != null || info.getRID() == MFWModelRes.getInstance().RID_querySubjectRefs) {
            short objRid = info.getRID();
            ObjectTypeInfo objectInfo = this.m_lineageRules.getObjectInfo(objRid);
            boolean bProcessDeep = bDeep;
            Short[] transformationPropRids = objectInfo.getTransformationPropertyList();
            MFWNodeHandle transformationProp = null;
            for (int transformationPropRidsIdx = 0; transformationProp == null && transformationPropRidsIdx < transformationPropRids.length; ++transformationPropRidsIdx) {
                PropertyNodeRetrieval propertyNodeRetrieval = new PropertyNodeRetrieval(this.m_mfwGateway, modelObject.getNode(), transformationPropRids[transformationPropRidsIdx]);
                transformationProp = propertyNodeRetrieval.getPropertyNode();
            }
            if (transformationProp != null) {
                transformationSources.add(modelObject);
                bProcessDeep = false;
                if (info.getRID() == MFWModelRes.getInstance().RID_querySubjectRefs) {
                    bProcessDeep = true;
                }
            } else if (this.m_modelRes.RID_level == objRid || this.m_modelRes.RID_hierarchy == objRid) {
                MFWNodeHandle memberCaptionQueryItemNode;
                MFWNodeHandle businessKeyQueryItemNode = this.getQueryItemWithRole(lineageObjectFactory, modelObject, _BUSINESS_KEY);
                if (null != businessKeyQueryItemNode) {
                    IMfwLineageObject childObj = modelObject.buildChildMfwObj(businessKeyQueryItemNode);
                    transformationSources.add(childObj);
                }
                if (null != (memberCaptionQueryItemNode = this.getQueryItemWithRole(lineageObjectFactory, modelObject, _MEMBER_CAPTION))) {
                    IMfwLineageObject childObj = modelObject.buildChildMfwObj(memberCaptionQueryItemNode);
                    transformationSources.add(childObj);
                }
                boolean bl = bProcessDeep = this.m_modelRes.RID_hierarchy == objRid && businessKeyQueryItemNode == null && memberCaptionQueryItemNode == null;
            }
            if (bProcessDeep) {
                MFWNodeHandle[] childNodes = this.m_mfwGateway.getAllObjectChildren(modelObject.getNode());
                for (int childNodesIdx = 0; childNodesIdx < childNodes.length; ++childNodesIdx) {
                    IMfwLineageObject childObject;
                    MFWNodeHandle childNode = childNodes[childNodesIdx];
                    if (Arrays.binarySearch(this.m_childRids, childNode.getInfo().getRID()) < 0 || (childObject = modelObject.buildChildMfwObj(childNode)) == null) continue;
                    Collection<IMfwLineageObject> childObjectsTransformationSources = this.getSources(lineageObjectFactory, childObject, bDeep);
                    transformationSources.addAll(childObjectsTransformationSources);
                }
            }
        }
        return transformationSources;
    }

    private MFWNodeHandle getQueryItemWithRole(IV5UniqueNameLineageObjectQuery lineageObjectFactory, IMfwLineageObject parentObj, String role) {
        MFWNodeHandle foundNode = null;
        MFWNodeHandle[] queryItemNodes = this.m_mfwGateway.getObjectChildren(parentObj.getNode(), this.m_modelRes.RID_queryItem);
        for (int queryItemNodesIdx = 0; foundNode == null && queryItemNodesIdx < queryItemNodes.length; ++queryItemNodesIdx) {
            MFWNodeHandle queryItemNode = queryItemNodes[queryItemNodesIdx];
            MFWNodeHandle[] roleNodes = this.m_mfwGateway.getObjectChildren(queryItemNode, this.m_modelRes.RID_role);
            for (int roleNodesIdx = 0; foundNode == null && roleNodesIdx < roleNodes.length; ++roleNodesIdx) {
                MFWNodeHandle roleNode = roleNodes[roleNodesIdx];
                MFWNodeHandle[] foundValueNodes = this.m_mfwGateway.findChildObjects(roleNode, this.m_modelRes.RID_name, this.m_modelRes.RID__Value, role);
                if (foundValueNodes == null || foundValueNodes.length <= 0) continue;
                foundNode = queryItemNode;
            }
        }
        return foundNode;
    }
}

